/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.model;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.reflect.model.Declaration;
import net.morimekta.providence.reflect.model.IncludeDeclaration;
import net.morimekta.providence.reflect.model.NamespaceDeclaration;

public class ProgramDeclaration {
    private final String documentation;
    private final String programName;
    private final List<IncludeDeclaration> includes;
    private final List<NamespaceDeclaration> namespaces;
    private final List<Declaration> declarationList;

    public ProgramDeclaration(@Nullable String documentation, @Nonnull String programName, @Nonnull List<IncludeDeclaration> includes, @Nonnull List<NamespaceDeclaration> namespaces, @Nonnull List<Declaration> declarationList) {
        this.documentation = documentation;
        this.programName = programName;
        this.includes = includes;
        this.namespaces = namespaces;
        this.declarationList = declarationList;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getProgramName() {
        return this.programName;
    }

    public List<IncludeDeclaration> getIncludes() {
        return this.includes;
    }

    public List<NamespaceDeclaration> getNamespaces() {
        return this.namespaces;
    }

    public List<Declaration> getDeclarationList() {
        return this.declarationList;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProgramDeclaration)) {
            return false;
        }
        ProgramDeclaration other = (ProgramDeclaration)obj;
        return Objects.equals(this.documentation, other.documentation) && Objects.equals(this.programName, other.programName) && Objects.equals(this.includes, other.includes) && Objects.equals(this.namespaces, other.namespaces) && Objects.equals(this.declarationList, other.declarationList);
    }

    public String toString() {
        return "ThriftProgram{" + this.programName + ".{" + this.declarationList.stream().map(Declaration::getName).collect(Collectors.joining(",")) + "}}";
    }
}

