/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.reflect.parser.ThriftToken;
import net.morimekta.providence.reflect.util.ReflectionUtils;

public class IncludeDeclaration {
    private final ThriftToken includeToken;
    private final ThriftToken filePath;
    private final ThriftToken programName;

    public IncludeDeclaration(@Nonnull ThriftToken includeToken, @Nonnull ThriftToken filePath, @Nullable ThriftToken programName) {
        this.includeToken = includeToken;
        this.filePath = filePath;
        this.programName = programName;
    }

    @Nonnull
    public ThriftToken getIncludeToken() {
        return this.includeToken;
    }

    @Nonnull
    public String getFilePath() {
        return this.filePath.decodeString(false);
    }

    @Nonnull
    public ThriftToken getFilePathToken() {
        return this.filePath;
    }

    @Nonnull
    public String getProgramName() {
        if (this.programName != null) {
            return this.programName.toString();
        }
        return ReflectionUtils.programNameFromPath(this.getFilePath());
    }

    @Nullable
    public ThriftToken getProgramNameToken() {
        return this.programName;
    }

    public String toString() {
        return "ThriftInclude{" + (Object)((Object)this.programName) + "=\"" + this.getFilePath() + "\"}";
    }
}

