/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CInterfaceDescriptor;
import net.morimekta.providence.reflect.contained.CMessageDescriptor;
import net.morimekta.providence.reflect.contained.CUnion;
import net.morimekta.util.collect.UnmodifiableMap;

public class CUnionDescriptor
extends PUnionDescriptor<CUnion>
implements CMessageDescriptor {
    private final CField<CUnion>[] fields;
    private final Map<Integer, CField<CUnion>> fieldIdMap;
    private final Map<String, CField<CUnion>> fieldNameMap;
    private final Map<String, CField<CUnion>> fieldPojoNameMap;
    private final Map<String, String> annotations;
    private final String comment;
    private final PDescriptorProvider implementing;
    private final boolean innerType;
    private final boolean autoType;

    public CUnionDescriptor(String comment, String packageName, String name, List<CField<CUnion>> fields, Map<String, String> annotations, PDescriptorProvider implementing) {
        super(packageName, name, (Supplier)new _Factory(), false);
        ((_Factory)this.getBuilderSupplier()).setType(this);
        this.innerType = name.contains(".");
        this.autoType = this.innerType && name.indexOf(".") != name.lastIndexOf(".");
        this.comment = comment;
        this.fields = fields.toArray(CField.EMPTY_ARRAY);
        this.annotations = annotations;
        UnmodifiableMap.Builder fieldIdMap = UnmodifiableMap.builder((int)this.fields.length);
        UnmodifiableMap.Builder fieldNameMap = UnmodifiableMap.builder((int)this.fields.length);
        UnmodifiableMap.Builder fieldPojoNameMap = UnmodifiableMap.builder((int)this.fields.length);
        for (CField<CUnion> field : fields) {
            fieldIdMap.put((Object)field.getId(), field);
            fieldNameMap.put((Object)field.getName(), field);
            fieldPojoNameMap.put((Object)field.getPojoName(), field);
        }
        this.fieldIdMap = fieldIdMap.build();
        this.fieldNameMap = fieldNameMap.build();
        this.fieldPojoNameMap = fieldPojoNameMap.build();
        this.implementing = implementing;
    }

    public boolean isInnerType() {
        return this.innerType;
    }

    public boolean isAutoType() {
        return this.autoType;
    }

    @Override
    public final String getDocumentation() {
        return this.comment;
    }

    @Nonnull
    public CField<CUnion>[] getFields() {
        return Arrays.copyOf(this.fields, this.fields.length);
    }

    @Override
    public CField<CUnion> findFieldByName(String name) {
        return this.fieldNameMap.get(name);
    }

    public CField<CUnion> findFieldByPojoName(String pojoName) {
        return this.fieldPojoNameMap.get(pojoName);
    }

    @Override
    public CField<CUnion> findFieldById(int id) {
        return this.fieldIdMap.get(id);
    }

    @Override
    @Nullable
    public CInterfaceDescriptor getImplementing() {
        if (this.implementing == null) {
            return null;
        }
        return (CInterfaceDescriptor)this.implementing.descriptor();
    }

    @Override
    public boolean isSimple() {
        for (CField<CUnion> field : this.getFields()) {
            switch (field.getType()) {
                case MAP: 
                case SET: 
                case LIST: 
                case MESSAGE: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Nonnull
    public Set<String> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAnnotation(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.get(name);
        }
        return null;
    }

    @Nonnull
    public CUnion.Builder builder() {
        return (CUnion.Builder)super.builder();
    }

    private static class _Factory
    implements Supplier<PMessageBuilder<CUnion>> {
        private CUnionDescriptor mType;

        private _Factory() {
        }

        public void setType(CUnionDescriptor type) {
            this.mType = type;
        }

        @Override
        @Nonnull
        public PMessageBuilder<CUnion> get() {
            return new CUnion.Builder(this.mType);
        }
    }
}

