/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.reflect.contained.CConst;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableMap;
import net.morimekta.util.collect.UnmodifiableSet;

public class CProgram {
    private final String programFilePath;
    private final String documentation;
    private final String programName;
    private final Set<String> includedPrograms;
    private final List<String> includedFiles;
    private final Map<String, String> namespaces;
    private final Map<String, String> typedefs;
    private final List<PDeclaredDescriptor<?>> declaredTypes;
    private final List<CService> services;
    private final List<CConst> constants;

    public CProgram(@Nonnull String programFilePath, String documentation, @Nonnull String programName, Map<String, String> namespaces, Collection<String> includedPrograms, Collection<String> includedFiles, Map<String, String> typedefs, Collection<PDeclaredDescriptor<?>> declaredTypes, Collection<CService> services, Collection<CConst> constants) {
        this.programFilePath = programFilePath;
        this.documentation = documentation;
        this.programName = programName;
        this.namespaces = namespaces == null ? UnmodifiableMap.mapOf() : UnmodifiableMap.copyOf(namespaces);
        this.includedPrograms = includedPrograms == null ? UnmodifiableSet.setOf() : UnmodifiableSet.copyOf(includedPrograms);
        this.includedFiles = includedFiles == null ? UnmodifiableList.listOf() : UnmodifiableList.copyOf(includedFiles);
        this.typedefs = typedefs == null ? UnmodifiableMap.mapOf() : UnmodifiableMap.copyOf(typedefs);
        this.declaredTypes = declaredTypes == null ? UnmodifiableList.listOf() : UnmodifiableList.copyOf(declaredTypes);
        this.services = services == null ? UnmodifiableList.listOf() : UnmodifiableList.copyOf(services);
        this.constants = constants == null ? UnmodifiableList.listOf() : UnmodifiableList.copyOf(constants);
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getProgramName() {
        return this.programName;
    }

    public Set<String> getIncludedPrograms() {
        return this.includedPrograms;
    }

    public List<String> getIncludedFiles() {
        return this.includedFiles;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public Map<String, String> getTypedefs() {
        return this.typedefs;
    }

    public List<PDeclaredDescriptor<?>> getDeclaredTypes() {
        return this.declaredTypes;
    }

    public List<CService> getServices() {
        return this.services;
    }

    public List<CConst> getConstants() {
        return this.constants;
    }

    public String getNamespaceForLanguage(String language) {
        return this.namespaces.get(language);
    }

    public String getProgramFilePath() {
        return this.programFilePath;
    }
}

