/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.util.collect.UnmodifiableMap;

public class CConst
extends PDeclaredDescriptor<Object>
implements CAnnotatedDescriptor {
    private final String comment;
    private final PDescriptorProvider typeProvider;
    private final PValueProvider valueProvider;
    private final Map<String, String> annotations;

    public CConst(@Nullable String docs, @Nonnull String programName, @Nonnull String name, @Nonnull PDescriptorProvider typeProvider, @Nonnull PValueProvider valueProvider, @Nullable Map<String, String> annotations) {
        super(programName, name);
        this.comment = docs;
        this.typeProvider = typeProvider;
        this.valueProvider = valueProvider;
        this.annotations = annotations == null ? UnmodifiableMap.mapOf() : UnmodifiableMap.copyOf(annotations);
    }

    public boolean isInnerType() {
        return false;
    }

    public boolean isAutoType() {
        return false;
    }

    @Override
    public String getDocumentation() {
        return this.comment;
    }

    @Nonnull
    public PDescriptor getDescriptor() {
        return this.typeProvider.descriptor();
    }

    public boolean hasDefaultValue() {
        return true;
    }

    public Object getDefaultValue() {
        try {
            return this.valueProvider.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to parse default value " + this.getName(), e);
        }
    }

    @Nonnull
    public PType getType() {
        return this.typeProvider.descriptor().getType();
    }

    @Override
    @Nonnull
    public Set<String> getAnnotations() {
        return this.annotations.keySet();
    }

    @Override
    public boolean hasAnnotation(@Nonnull String name) {
        return this.annotations.containsKey(name);
    }

    @Override
    public String getAnnotationValue(@Nonnull String name) {
        if (this.annotations.containsKey(name)) {
            return this.annotations.get(name);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CField)) {
            return false;
        }
        CField other = (CField)o;
        return CConst.equalsQualifiedName(this.getDescriptor(), other.getDescriptor()) && this.getName().equals(other.getName()) && Objects.equals(this.valueProvider.get(), other.getDefaultValue());
    }

    public int hashCode() {
        return Objects.hash(CField.class, this.getName(), this.getDescriptor(), this.getDefaultValue());
    }

    private static boolean equalsQualifiedName(PDescriptor a, PDescriptor b) {
        return a != null && b != null && a.getQualifiedName().equals(b.getQualifiedName());
    }
}

