/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.model.ProgramDeclaration;
import net.morimekta.providence.types.TypeReference;
import net.morimekta.providence.types.WritableTypeRegistry;
import net.morimekta.util.collect.UnmodifiableList;

public class ProgramRegistry
extends WritableTypeRegistry {
    private final String programContext;
    private CProgram program;
    private ProgramDeclaration programType;
    private final Map<String, TypeReference> typedefs;
    private final Map<String, PDeclaredDescriptor<?>> declaredTypes;
    private final Map<String, PService> services;
    private final Map<String, PValueProvider> constants;
    private final Map<String, ProgramRegistry> includes;

    ProgramRegistry(@Nonnull String programContext) {
        this.programContext = programContext;
        this.declaredTypes = new LinkedHashMap();
        this.services = new LinkedHashMap<String, PService>();
        this.includes = new LinkedHashMap<String, ProgramRegistry>();
        this.typedefs = new LinkedHashMap<String, TypeReference>();
        this.constants = new LinkedHashMap<String, PValueProvider>();
    }

    public String getProgramContext() {
        return this.programContext;
    }

    public CProgram getProgram() {
        return this.program;
    }

    public ProgramDeclaration getProgramType() {
        return this.programType;
    }

    @Nonnull
    public Optional<ProgramRegistry> getRegistry(@Nonnull String program) {
        if (this.programContext.equals(program)) {
            return Optional.of(this);
        }
        return Optional.ofNullable(this.includes.get(program));
    }

    @Nonnull
    public Optional<PDeclaredDescriptor<?>> getDeclaredType(@Nonnull TypeReference reference) {
        reference = this.finalTypeReference(reference);
        if (this.programContext.equals(reference.programName)) {
            return Optional.ofNullable(this.declaredTypes.get(reference.typeName));
        }
        if (this.includes.containsKey(reference.programName)) {
            return this.includes.get(reference.programName).getDeclaredType(reference);
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<PService> getService(@Nonnull TypeReference reference) {
        if (this.includes.containsKey(reference.programName)) {
            return this.includes.get(reference.programName).getService(reference);
        }
        return Optional.ofNullable(this.services.get(reference.typeName));
    }

    @Nonnull
    public <T> Optional<T> getConstantValue(@Nonnull TypeReference reference) {
        if (this.includes.containsKey(reference.programName)) {
            return this.includes.get(reference.programName).getConstantValue(reference);
        }
        return Optional.ofNullable(this.constants.get(reference.typeName)).map(PValueProvider::get);
    }

    @Nonnull
    public Optional<TypeReference> getTypedef(@Nonnull TypeReference reference) {
        if (this.programContext.equals(reference.programName)) {
            return Optional.ofNullable(this.typedefs.get(reference.typeName));
        }
        if (this.includes.containsKey(reference.programName)) {
            return this.includes.get(reference.programName).getTypedef(reference);
        }
        return Optional.empty();
    }

    public List<PDeclaredDescriptor<?>> getDeclaredTypes() {
        return UnmodifiableList.copyOf(this.declaredTypes.values());
    }

    public boolean isKnownProgram(@Nonnull String program) {
        return this.programContext.equals(program) || this.includes.containsKey(program);
    }

    public void registerTypedef(@Nonnull TypeReference reference, @Nonnull TypeReference target) {
        if (!this.programContext.equals(reference.programName)) {
            throw new IllegalArgumentException("Unable to register typedef " + reference + " = " + target);
        }
        this.typedefs.put(reference.typeName, target);
    }

    public <T> void registerType(PDeclaredDescriptor<T> declaredType) {
        if (!this.programContext.equals(declaredType.getProgramName())) {
            throw new IllegalArgumentException("Unable to register " + declaredType.getType() + " " + declaredType.getQualifiedName());
        }
        this.declaredTypes.put(declaredType.getName(), declaredType);
    }

    public void registerService(@Nonnull PService service) {
        if (this.programContext.equals(service.getProgramName())) {
            this.services.put(service.getName(), service);
            for (PServiceMethod method : service.getMethods()) {
                PUnionDescriptor returnType = method.getResponseType();
                if (returnType != null) {
                    this.registerType((PDeclaredDescriptor)returnType);
                }
                PStructDescriptor requestType = method.getRequestType();
                this.registerType((PDeclaredDescriptor)requestType);
            }
        } else {
            throw new IllegalArgumentException("Unable to register service " + service.getQualifiedName());
        }
    }

    public void registerConstant(@Nonnull TypeReference reference, @Nonnull PValueProvider value) {
        if (!this.programContext.equals(reference.programName)) {
            throw new IllegalArgumentException("Unable to register constant " + reference);
        }
        this.constants.put(reference.typeName, value);
    }

    void setProgram(CProgram program) {
        this.program = program;
    }

    void setProgramType(ProgramDeclaration type) {
        this.programType = type;
    }

    void addInclude(String programName, ProgramRegistry included) {
        this.includes.put(programName, included);
    }
}

