package net.morimekta.providence.reflect.model;

import net.morimekta.providence.reflect.parser.ThriftToken;
import net.morimekta.providence.reflect.util.ReflectionUtils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * <pre>{@code
 * include ::= 'include' {file_path} ('as' {programName})?
 * }</pre>
 */
public class IncludeDeclaration {
    private final ThriftToken includeToken;
    private final ThriftToken filePath;
    private final ThriftToken programName;

    public IncludeDeclaration(@Nonnull ThriftToken includeToken,
                              @Nonnull ThriftToken filePath,
                              @Nullable ThriftToken programName) {
        this.includeToken = includeToken;
        this.filePath = filePath;
        this.programName = programName;
    }

    @Nonnull
    public ThriftToken getIncludeToken() {
        return includeToken;
    }

    @Nonnull
    public String getFilePath() {
        return filePath.decodeString(false);
    }

    @Nonnull
    public ThriftToken getFilePathToken() {
        return filePath;
    }

    @Nonnull
    public String getProgramName() {
        if (programName != null) {
            return programName.toString();
        }
        return ReflectionUtils.programNameFromPath(getFilePath());
    }

    @Nullable
    public ThriftToken getProgramNameToken() {
        return programName;
    }

    @Override
    public String toString() {
        return "ThriftInclude{" + programName + "=\"" + getFilePath() + "\"}";
    }
}
