/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.util.Strings;

public class ReflectionUtils {
    public static boolean isDeclaredType(PDeclaredDescriptor descriptor) {
        return !descriptor.isAutoType();
    }

    public static boolean isThriftFile(@Nonnull File file) {
        return ReflectionUtils.isThriftFile(file.getName());
    }

    public static boolean isThriftFile(@Nonnull String filePath) {
        return ReflectionUtils.programNameFromPath(filePath).length() > 0;
    }

    public static boolean isProvidenceFile(@Nonnull File file) {
        return ReflectionUtils.isProvidenceFile(file.getName());
    }

    public static boolean isProvidenceFile(@Nonnull String filePath) {
        String lowerCased = Paths.get(filePath, new String[0]).getFileName().toString().toLowerCase(Locale.US);
        return lowerCased.endsWith(".providence") || lowerCased.endsWith(".pvd");
    }

    @Nonnull
    public static String programNameFromPath(@Nonnull String filePath) {
        int lastDot;
        if (filePath.contains("/") || filePath.contains("\\")) {
            filePath = filePath.replaceAll(".*[/\\\\]", "");
        }
        if ((lastDot = filePath.lastIndexOf(".")) < 1) {
            return "";
        }
        String suffix = filePath.substring(lastDot + 1).toLowerCase(Locale.US);
        String name = filePath.substring(0, lastDot);
        switch (suffix) {
            case "providence": 
            case "pvd": 
            case "thrift": 
            case "thr": {
                break;
            }
            default: {
                return "";
            }
        }
        return name.replaceAll("[^a-zA-Z0-9_]", "_");
    }

    @Nonnull
    public static String longestCommonPrefixPath(Collection<String> paths) {
        if (paths.size() == 0) {
            throw new IllegalArgumentException("Empty paths");
        }
        String prefix = paths.iterator().next();
        for (String s : paths) {
            int len = Strings.commonPrefix((String)s, (String)prefix);
            if (len >= prefix.length()) continue;
            prefix = prefix.substring(0, len);
        }
        if (prefix.contains("/")) {
            return prefix.replaceAll("/[^/]*$", "/");
        }
        return "";
    }

    @Nonnull
    public static List<String> stripCommonPrefix(List<String> paths) {
        String prefix = ReflectionUtils.longestCommonPrefixPath(paths);
        if (prefix.length() > 0) {
            return paths.stream().map(s -> s.substring(prefix.length())).collect(Collectors.toList());
        }
        return paths;
    }

    private ReflectionUtils() {
    }
}

