/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.model;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.reflect.model.AnnotationDeclaration;
import net.morimekta.providence.reflect.model.Declaration;
import net.morimekta.providence.reflect.model.DeclarationUtil;
import net.morimekta.providence.reflect.parser.ThriftToken;

public class FieldDeclaration
extends Declaration {
    private final ThriftToken id;
    private final int fieldId;
    private final ThriftToken requirement;
    private final List<ThriftToken> type;
    private final List<ThriftToken> defaultValue;

    public FieldDeclaration(@Nullable String documentation, @Nullable ThriftToken id, int fieldId, @Nullable ThriftToken requirement, @Nonnull ThriftToken name, @Nonnull List<ThriftToken> type, @Nullable List<ThriftToken> defaultValue, @Nullable List<AnnotationDeclaration> annotations) {
        super(documentation, name, annotations);
        this.id = id;
        this.fieldId = fieldId;
        this.requirement = requirement;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public int getId() {
        return this.fieldId;
    }

    public ThriftToken getIdToken() {
        return this.id;
    }

    @Nonnull
    public PRequirement getRequirement() {
        if (this.requirement != null) {
            switch (this.requirement.toString()) {
                case "required": {
                    return PRequirement.REQUIRED;
                }
                case "optional": {
                    return PRequirement.OPTIONAL;
                }
            }
        }
        return PRequirement.DEFAULT;
    }

    @Nullable
    public ThriftToken getRequirementToken() {
        return this.requirement;
    }

    public String getDefaultValue() {
        if (this.defaultValue != null) {
            return DeclarationUtil.toValueString(this.defaultValue);
        }
        return null;
    }

    @Nullable
    public List<ThriftToken> getDefaultValueTokens() {
        return this.defaultValue;
    }

    @Nonnull
    public String getType() {
        return DeclarationUtil.toTypeString(this.type);
    }

    @Nonnull
    public ThriftToken getTypeToken() {
        return DeclarationUtil.toTypeToken(this.type);
    }

    @Nonnull
    public List<ThriftToken> getTypeTokens() {
        return this.type;
    }
}

