/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.model;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.reflect.parser.ThriftToken;

@Immutable
public class AnnotationDeclaration {
    private final ThriftToken tagToken;
    private final ThriftToken valueToken;

    public AnnotationDeclaration(@Nonnull ThriftToken tagToken, @Nullable ThriftToken valueToken) {
        this.tagToken = tagToken;
        this.valueToken = valueToken;
    }

    public PAnnotation getAnnotation() {
        return PAnnotation.forTag((String)this.tagToken.toString());
    }

    public String getTag() {
        return this.tagToken.toString();
    }

    public String getValue() {
        if (this.valueToken == null) {
            return "";
        }
        return this.valueToken.decodeString(false);
    }

    public ThriftToken getTagToken() {
        return this.tagToken;
    }

    public ThriftToken getValueToken() {
        return this.valueToken;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.tagToken.toString());
        if (this.valueToken != null) {
            builder.append(": ").append((CharSequence)((Object)this.valueToken));
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AnnotationDeclaration)) {
            return false;
        }
        AnnotationDeclaration other = (AnnotationDeclaration)obj;
        return Objects.equals(this.tagToken.toString(), other.tagToken.toString()) && this.valueToken == null == (other.valueToken == null) && this.valueToken != null && Objects.equals(this.valueToken.toString(), other.valueToken.toString());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.tagToken, this.valueToken});
    }
}

