/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CServiceMethod;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableMap;

public class CService
extends PService
implements CAnnotatedDescriptor {
    private final Map<String, String> annotations;
    private String documentation;

    public CService(String documentation, String programName, String name, PServiceProvider extendsService, Collection<CServiceMethod> methods, Map<String, String> annotations) {
        super(programName, name, extendsService, methods);
        this.documentation = documentation;
        this.annotations = annotations == null ? Collections.EMPTY_MAP : UnmodifiableMap.copyOf(annotations);
    }

    @Nonnull
    public Collection<CServiceMethod> getMethods() {
        return super.getMethods();
    }

    public CServiceMethod getMethod(String name) {
        for (CServiceMethod method : this.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        if (this.getExtendsService() != null) {
            return this.getExtendsService().getMethod(name);
        }
        return null;
    }

    public CService getExtendsService() {
        return (CService)super.getExtendsService();
    }

    public Collection<CServiceMethod> getMethodsIncludingExtended() {
        CService extended = this.getExtendsService();
        if (extended == null) {
            return this.getMethods();
        }
        ArrayList<CServiceMethod> out = new ArrayList<CServiceMethod>();
        out.addAll(extended.getMethodsIncludingExtended());
        out.addAll(this.getMethods());
        return UnmodifiableList.copyOf(out);
    }

    @Override
    @Nonnull
    public Set<String> getAnnotations() {
        return this.annotations.keySet();
    }

    @Override
    public boolean hasAnnotation(@Nonnull String name) {
        return this.annotations.containsKey(name);
    }

    @Override
    public String getAnnotationValue(@Nonnull String name) {
        return this.annotations.get(name);
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }
}

