/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.reflect.ProgramRegistry;
import net.morimekta.providence.reflect.util.ReflectionUtils;
import net.morimekta.providence.types.TypeReference;
import net.morimekta.providence.types.TypeRegistry;
import net.morimekta.util.FileUtil;
import net.morimekta.util.collect.UnmodifiableList;

public class GlobalRegistry
extends TypeRegistry {
    private final Map<String, ProgramRegistry> pathToRegistry = new LinkedHashMap<String, ProgramRegistry>();

    @Nonnull
    public ProgramRegistry registryForPath(String filePath) {
        try {
            String absolute = FileUtil.readCanonicalPath((Path)Paths.get(filePath, new String[0]).toAbsolutePath()).toString();
            return this.pathToRegistry.computeIfAbsent(absolute, path -> new ProgramRegistry(ReflectionUtils.programNameFromPath(absolute)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    public List<ProgramRegistry> getRegistries() {
        return UnmodifiableList.copyOf(this.pathToRegistry.values());
    }

    @Nonnull
    public Optional<PDeclaredDescriptor<?>> getDeclaredType(@Nonnull TypeReference reference) {
        for (ProgramRegistry registry : this.pathToRegistry.values()) {
            Optional<PDeclaredDescriptor<?>> out;
            if (!registry.getProgramContext().equals(reference.programName) || !(out = registry.getDeclaredType(reference)).isPresent()) continue;
            return out;
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<PService> getService(@Nonnull TypeReference reference) {
        for (ProgramRegistry registry : this.pathToRegistry.values()) {
            Optional<PService> out;
            if (!registry.getProgramContext().equals(reference.programName) || !(out = registry.getService(reference)).isPresent()) continue;
            return out;
        }
        return Optional.empty();
    }

    @Nonnull
    public <T> Optional<T> getConstantValue(@Nonnull TypeReference reference) {
        for (ProgramRegistry registry : this.pathToRegistry.values()) {
            Optional out;
            if (!registry.getProgramContext().equals(reference.programName) || !(out = registry.getConstantValue(reference)).isPresent()) continue;
            return out;
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<TypeReference> getTypedef(@Nonnull TypeReference reference) {
        for (ProgramRegistry registry : this.pathToRegistry.values()) {
            Optional<TypeReference> out;
            if (!registry.getProgramContext().equals(reference.programName) || !(out = registry.getTypedef(reference)).isPresent()) continue;
            return out;
        }
        return Optional.empty();
    }

    public List<PDeclaredDescriptor<?>> getDeclaredTypes() {
        HashSet combined = new HashSet();
        for (ProgramRegistry registry : this.pathToRegistry.values()) {
            combined.addAll(registry.getDeclaredTypes());
        }
        return UnmodifiableList.copyOf(combined);
    }

    public boolean isKnownProgram(@Nonnull String program) {
        for (ProgramRegistry registry : this.pathToRegistry.values()) {
            if (!registry.getProgramContext().equals(program)) continue;
            return true;
        }
        return false;
    }
}

