/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableMap;
import net.morimekta.util.collect.UnmodifiableSet;
import net.morimekta.util.collect.UnmodifiableSortedMap;
import net.morimekta.util.collect.UnmodifiableSortedSet;

public abstract class CMessageBuilder<Builder extends CMessageBuilder<Builder, Message>, Message extends PMessage<Message>>
extends PMessageBuilder<Message> {
    private final Map<Integer, Object> values = new TreeMap<Integer, Object>();
    private final Set<Integer> modified = new TreeSet<Integer>();

    @Nonnull
    public Builder merge(@Nonnull Message from) {
        for (PField field : this.descriptor().getFields()) {
            int key = field.getId();
            if (!from.has(key)) continue;
            switch (field.getType()) {
                case MESSAGE: {
                    if (this.values.containsKey(key)) {
                        this.mutator(key).merge((PMessage)from.get(key));
                        break;
                    }
                    this.set(key, from.get(key));
                    break;
                }
                case SET: {
                    if (this.values.containsKey(key)) {
                        LinkedHashSet set = (LinkedHashSet)this.values.get(key);
                        if (!(set instanceof LinkedHashSet)) {
                            set = new LinkedHashSet(set);
                            this.values.put(key, set);
                        }
                        set.addAll((Collection)from.get(key));
                        break;
                    }
                    this.set(key, from.get(key));
                    break;
                }
                case MAP: {
                    if (this.values.containsKey(key)) {
                        LinkedHashMap map = (LinkedHashMap)this.values.get(key);
                        if (!(map instanceof LinkedHashMap)) {
                            map = new LinkedHashMap(map);
                            this.values.put(key, map);
                        }
                        map.putAll((Map)from.get(key));
                        break;
                    }
                    this.set(key, from.get(key));
                    break;
                }
                default: {
                    this.set(key, from.get(key));
                }
            }
            this.modified.add(key);
        }
        return (Builder)((Object)this);
    }

    @Nonnull
    public PMessageBuilder mutator(int key) {
        PField field = this.descriptor().findFieldById(key);
        if (field == null) {
            throw new IllegalArgumentException("No such field ID " + key);
        }
        if (field.getType() != PType.MESSAGE) {
            throw new IllegalArgumentException("Not a message field ID " + key + ": " + field.getName());
        }
        Object current = this.values.get(key);
        if (current == null) {
            current = ((PMessageDescriptor)field.getDescriptor()).builder();
            this.values.put(key, current);
        } else if (current instanceof PMessage) {
            current = ((PMessage)current).mutate();
            this.values.put(key, current);
        } else if (!(current instanceof PMessageBuilder)) {
            throw new IllegalArgumentException("Invalid value in map on message type: " + current.getClass().getSimpleName());
        }
        this.modified.add(key);
        return (PMessageBuilder)current;
    }

    public boolean valid() {
        for (PField field : this.descriptor().getFields()) {
            if (field.getRequirement() != PRequirement.REQUIRED || this.values.containsKey(field.getId())) continue;
            return false;
        }
        return true;
    }

    public Builder validate() {
        ArrayList<String> missing = new ArrayList<String>();
        for (PField field : this.descriptor().getFields()) {
            if (field.getRequirement() != PRequirement.REQUIRED || this.values.containsKey(field.getId())) continue;
            missing.add(field.getName());
        }
        if (missing.size() > 0) {
            throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message " + this.descriptor().getQualifiedName());
        }
        return (Builder)((Object)this);
    }

    @Nonnull
    public Builder set(int key, Object value) {
        CField field = (CField)this.descriptor().findFieldById(key);
        if (field == null) {
            return (Builder)((Object)this);
        }
        if (value == null) {
            this.values.remove(key);
        } else {
            switch (field.getType()) {
                case LIST: {
                    this.values.put(key, UnmodifiableList.copyOf((Collection)((Collection)value)));
                    break;
                }
                case SET: {
                    PContainer.Type ctype = PContainer.typeForName((String)field.getAnnotationValue(PAnnotation.CONTAINER));
                    if (ctype == PContainer.Type.SORTED) {
                        this.values.put(key, UnmodifiableSortedSet.copyOf((Collection)((Collection)value)));
                        break;
                    }
                    this.values.put(key, UnmodifiableSet.copyOf((Collection)((Collection)value)));
                    break;
                }
                case MAP: {
                    PContainer.Type ctype = PContainer.typeForName((String)field.getAnnotationValue(PAnnotation.CONTAINER));
                    if (ctype == PContainer.Type.SORTED) {
                        this.values.put(key, UnmodifiableSortedMap.copyOf((Map)((Map)value)));
                        break;
                    }
                    this.values.put(key, UnmodifiableMap.copyOf((Map)((Map)value)));
                    break;
                }
                default: {
                    this.values.put(key, value);
                }
            }
        }
        this.modified.add(key);
        return (Builder)((Object)this);
    }

    public boolean isSet(int key) {
        return this.values.containsKey(key);
    }

    public boolean isModified(int key) {
        return this.modified.contains(key);
    }

    @Nonnull
    public Builder addTo(int key, Object value) {
        CField field = (CField)this.descriptor().findFieldById(key);
        if (field == null) {
            return (Builder)((Object)this);
        }
        if (value == null) {
            throw new IllegalArgumentException("Adding null value");
        }
        if (field.getType() == PType.LIST) {
            ArrayList<Object> list = (ArrayList<Object>)this.values.get(field.getId());
            if (list == null) {
                list = new ArrayList<Object>();
                this.values.put(field.getId(), list);
            } else if (!(list instanceof ArrayList)) {
                list = new ArrayList(list);
                this.values.put(field.getId(), list);
            }
            list.add(value);
        } else if (field.getType() == PType.SET) {
            LinkedHashSet<Object> set = (LinkedHashSet<Object>)this.values.get(field.getId());
            if (set == null) {
                set = new LinkedHashSet<Object>();
                this.values.put(field.getId(), set);
            } else if (!(set instanceof LinkedHashSet)) {
                set = new LinkedHashSet(set);
                this.values.put(field.getId(), set);
            }
            set.add(value);
        } else {
            throw new IllegalArgumentException("Field " + field.getName() + " in " + this.descriptor().getQualifiedName() + " is not a collection: " + field.getType());
        }
        this.modified.add(key);
        return (Builder)((Object)this);
    }

    @Nonnull
    public Builder clear(int key) {
        this.values.remove(key);
        this.modified.add(key);
        return (Builder)((Object)this);
    }

    Map<Integer, Object> getValueMap() {
        UnmodifiableMap.Builder out = UnmodifiableMap.builder();
        for (CField field : (CField[])this.descriptor().getFields()) {
            int key = field.getId();
            if (this.values.containsKey(key)) {
                block0 : switch (field.getType()) {
                    case LIST: {
                        out.put((Object)key, (Object)UnmodifiableList.copyOf((Collection)((List)this.values.get(key))));
                        break;
                    }
                    case SET: {
                        PContainer.Type ctype = PContainer.typeForName((String)field.getAnnotationValue(PAnnotation.CONTAINER));
                        switch (ctype) {
                            case SORTED: {
                                out.put((Object)key, (Object)UnmodifiableSortedSet.copyOf((Collection)((Set)this.values.get(key))));
                                break block0;
                            }
                        }
                        out.put((Object)key, (Object)UnmodifiableSet.copyOf((Collection)((Set)this.values.get(key))));
                        break;
                    }
                    case MAP: {
                        PContainer.Type ctype = PContainer.typeForName((String)field.getAnnotationValue(PAnnotation.CONTAINER));
                        switch (ctype) {
                            case SORTED: {
                                out.put((Object)key, (Object)UnmodifiableSortedMap.copyOf((Map)((Map)this.values.get(key))));
                                break block0;
                            }
                        }
                        out.put((Object)key, (Object)UnmodifiableMap.copyOf((Map)((Map)this.values.get(key))));
                        break;
                    }
                    case MESSAGE: {
                        Object current = this.values.get(key);
                        if (current instanceof PMessageBuilder) {
                            out.put((Object)key, ((PMessageBuilder)current).build());
                            break;
                        }
                        out.put((Object)key, current);
                        break;
                    }
                    default: {
                        out.put((Object)key, this.values.get(key));
                        break;
                    }
                }
                continue;
            }
            if (field.getRequirement() == PRequirement.OPTIONAL) continue;
            if (field.hasDefaultValue()) {
                out.put((Object)key, field.getDefaultValue());
                continue;
            }
            if (field.getDescriptor().getDefaultValue() == null) continue;
            out.put((Object)key, field.getDescriptor().getDefaultValue());
        }
        return out.build();
    }

    public String toString() {
        return this.descriptor().getQualifiedName() + "._Builder{values=" + this.values + ", modified=" + this.modified + "}";
    }

    public boolean has(int key) {
        CField field = (CField)this.descriptor().findFieldById(key);
        if (field == null) {
            return false;
        }
        if (field.getRequirement() != PRequirement.OPTIONAL && field.getDefaultValue() != null) {
            return true;
        }
        return this.values.containsKey(key);
    }

    public <T> T get(int key) {
        CField field = (CField)this.descriptor().findFieldById(key);
        if (field == null) {
            return null;
        }
        if (this.values.containsKey(key)) {
            return (T)this.values.get(key);
        }
        return (T)field.getDefaultValue();
    }
}

