/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PInterfaceDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.util.collect.UnmodifiableMap;

public class CField<M extends PMessage<M>>
implements PField<M>,
CAnnotatedDescriptor {
    public static final CField[] EMPTY_ARRAY = new CField[0];
    private final String comment;
    private final int id;
    private final PRequirement requirement;
    private final PDescriptorProvider typeProvider;
    private final String name;
    private final PValueProvider defaultValue;
    private final Map<String, String> annotations;
    private final PStructDescriptorProvider argumentsProvider;
    private final PDescriptorProvider implementing;

    public CField(@Nullable String docs, int id, @Nonnull PRequirement requirement, @Nonnull String name, @Nonnull PDescriptorProvider typeProvider, @Nullable PStructDescriptorProvider argumentsProvider, @Nullable PValueProvider defaultValue, @Nullable Map<String, String> annotations, @Nullable PDescriptorProvider implementing) {
        this.comment = docs;
        this.id = id;
        this.requirement = requirement;
        this.typeProvider = typeProvider;
        this.argumentsProvider = argumentsProvider;
        this.name = name;
        this.defaultValue = defaultValue;
        this.annotations = annotations == null ? UnmodifiableMap.mapOf() : UnmodifiableMap.copyOf(annotations);
        this.implementing = implementing;
    }

    @Override
    public String getDocumentation() {
        return this.comment;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public PRequirement getRequirement() {
        return this.requirement;
    }

    @Nonnull
    public PDescriptor getDescriptor() {
        return this.typeProvider.descriptor();
    }

    public PStructDescriptor getArgumentsType() {
        return this.argumentsProvider == null ? this.argumentsFromInterface() : this.argumentsProvider.descriptor();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null || this.hasDefaultFromInterface();
    }

    public Object getDefaultValue() {
        try {
            return this.defaultValue != null ? this.defaultValue.get() : this.defaultFromInterfaceOrType();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to parse default value " + this.getName(), e);
        }
    }

    @Override
    @Nonnull
    public Set<String> getAnnotations() {
        if (this.implementing != null) {
            HashSet<String> union = new HashSet<String>(this.annotations.keySet());
            CField field = (CField)this.getImplementing().findFieldByName(this.getName());
            if (field != null) {
                union.addAll(field.getAnnotations());
            }
            return union;
        }
        return this.annotations.keySet();
    }

    @Override
    public boolean hasAnnotation(@Nonnull String name) {
        CField field;
        if (this.annotations.containsKey(name)) {
            return true;
        }
        if (this.implementing != null && (field = (CField)this.getImplementing().findFieldByName(this.getName())) != null) {
            return field.hasAnnotation(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(@Nonnull String name) {
        CField field;
        if (this.annotations.containsKey(name)) {
            return this.annotations.get(name);
        }
        if (this.implementing != null && (field = (CField)this.getImplementing().findFieldByName(this.getName())) != null) {
            return field.getAnnotationValue(name);
        }
        return null;
    }

    public String toString() {
        return PField.asString((PField)this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CField)) {
            return false;
        }
        CField other = (CField)o;
        return this.id == other.id && this.requirement == other.requirement && CField.equalsQualifiedName(this.getDescriptor(), other.getDescriptor()) && this.name.equals(other.name) && Objects.equals(this.defaultValue, other.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(CField.class, this.id, this.requirement, this.name, this.getDefaultValue());
    }

    private PInterfaceDescriptor getImplementing() {
        return (PInterfaceDescriptor)this.implementing.descriptor();
    }

    private boolean hasDefaultFromInterface() {
        if (this.implementing == null) {
            return false;
        }
        PField ifField = this.getImplementing().findFieldByName(this.getName());
        if (ifField == null) {
            return false;
        }
        return ifField.hasDefaultValue();
    }

    private Object defaultFromInterfaceOrType() {
        if (this.implementing == null) {
            return this.getDescriptor().getDefaultValue();
        }
        PField ifField = this.getImplementing().findFieldByName(this.getName());
        if (ifField == null) {
            return this.getDescriptor().getDefaultValue();
        }
        return ifField.getDefaultValue();
    }

    private PStructDescriptor argumentsFromInterface() {
        if (this.implementing == null) {
            return null;
        }
        PField ifField = this.getImplementing().findFieldByName(this.getName());
        if (ifField == null) {
            return null;
        }
        return ifField.getArgumentsType();
    }

    private static boolean equalsQualifiedName(PDescriptor a, PDescriptor b) {
        return a != null && b != null && a.getQualifiedName().equals(b.getQualifiedName());
    }
}

