/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PExceptionDescriptor;
import net.morimekta.providence.reflect.contained.CException;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CInterfaceDescriptor;
import net.morimekta.providence.reflect.contained.CMessageDescriptor;
import net.morimekta.util.collect.UnmodifiableMap;

public class CExceptionDescriptor
extends PExceptionDescriptor<CException>
implements CMessageDescriptor {
    private final CField<CException>[] fields;
    private final Map<Integer, CField<CException>> fieldIdMap;
    private final Map<String, CField<CException>> fieldNameMap;
    private final Map<String, String> annotations;
    private final String comment;

    public CExceptionDescriptor(String comment, String packageName, String name, List<CField<CException>> fields, Map<String, String> annotations) {
        super(packageName, name, (Supplier)new _BuilderSupplier(), false);
        ((_BuilderSupplier)this.getBuilderSupplier()).setType(this);
        this.comment = comment;
        this.fields = fields.toArray(CField.EMPTY_ARRAY);
        this.annotations = annotations;
        UnmodifiableMap.Builder fieldIdMap = UnmodifiableMap.builder((int)this.fields.length);
        UnmodifiableMap.Builder fieldNameMap = UnmodifiableMap.builder((int)this.fields.length);
        for (CField<CException> field : fields) {
            fieldIdMap.put((Object)field.getId(), field);
            fieldNameMap.put((Object)field.getName(), field);
        }
        this.fieldIdMap = fieldIdMap.build();
        this.fieldNameMap = fieldNameMap.build();
    }

    @Override
    public final String getDocumentation() {
        return this.comment;
    }

    @Nonnull
    public CField<CException>[] getFields() {
        return Arrays.copyOf(this.fields, this.fields.length);
    }

    @Override
    public CField<CException> findFieldByName(String name) {
        return this.fieldNameMap.get(name);
    }

    @Override
    public CField<CException> findFieldById(int id) {
        return this.fieldIdMap.get(id);
    }

    @Override
    @Nullable
    public CInterfaceDescriptor getImplementing() {
        return null;
    }

    @Override
    @Nonnull
    public Set<String> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAnnotation(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.get(name);
        }
        return null;
    }

    @Override
    public boolean isSimple() {
        for (CField<CException> field : this.getFields()) {
            switch (field.getType()) {
                case MAP: 
                case SET: 
                case LIST: 
                case MESSAGE: {
                    return false;
                }
            }
        }
        return true;
    }

    private static class _BuilderSupplier
    implements Supplier<PMessageBuilder<CException>> {
        private CExceptionDescriptor mType;

        private _BuilderSupplier() {
        }

        public void setType(CExceptionDescriptor type) {
            this.mType = type;
        }

        @Override
        @Nonnull
        public PMessageBuilder<CException> get() {
            return new CException.Builder(this.mType);
        }
    }
}

