/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

@Immutable
public class ProgramMeta
implements PMessage<ProgramMeta, _Field>,
Comparable<ProgramMeta>,
Serializable,
BinaryWriter {
    private static final long serialVersionUID = 2739564556465784838L;
    private final transient String mFilePath;
    private final transient List<String> mFileLines;
    private final transient ProgramType mProgram;
    private final transient Map<String, ProgramMeta> mIncludes;
    private volatile transient int tHashCode;
    private transient ProgramMeta tSerializeInstance;
    public static final PStructDescriptor<ProgramMeta, _Field> kDescriptor = new _Descriptor();

    private ProgramMeta(_Builder builder) {
        this.mFilePath = builder.mFilePath;
        this.mFileLines = builder.isSetFileLines() ? ImmutableList.copyOf((Collection)builder.mFileLines) : null;
        this.mProgram = builder.mProgram_builder != null ? builder.mProgram_builder.build() : builder.mProgram;
        this.mIncludes = builder.isSetIncludes() ? ImmutableMap.copyOf((Map)builder.mIncludes) : null;
    }

    public boolean hasFilePath() {
        return this.mFilePath != null;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    @Nonnull
    public Optional<String> optionalFilePath() {
        return Optional.ofNullable(this.mFilePath);
    }

    public int numFileLines() {
        return this.mFileLines != null ? this.mFileLines.size() : 0;
    }

    public boolean hasFileLines() {
        return this.mFileLines != null;
    }

    public List<String> getFileLines() {
        return this.mFileLines;
    }

    @Nonnull
    public Optional<List<String>> optionalFileLines() {
        return Optional.ofNullable(this.mFileLines);
    }

    public boolean hasProgram() {
        return this.mProgram != null;
    }

    public ProgramType getProgram() {
        return this.mProgram;
    }

    @Nonnull
    public Optional<ProgramType> optionalProgram() {
        return Optional.ofNullable(this.mProgram);
    }

    public int numIncludes() {
        return this.mIncludes != null ? this.mIncludes.size() : 0;
    }

    public boolean hasIncludes() {
        return this.mIncludes != null;
    }

    public Map<String, ProgramMeta> getIncludes() {
        return this.mIncludes;
    }

    @Nonnull
    public Optional<Map<String, ProgramMeta>> optionalIncludes() {
        return Optional.ofNullable(this.mIncludes);
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.mFilePath != null;
            }
            case 2: {
                return this.mFileLines != null;
            }
            case 3: {
                return this.mProgram != null;
            }
            case 4: {
                return this.mIncludes != null;
            }
        }
        return false;
    }

    public <T> T get(int key) {
        switch (key) {
            case 1: {
                return (T)this.mFilePath;
            }
            case 2: {
                return (T)this.mFileLines;
            }
            case 3: {
                return (T)this.mProgram;
            }
            case 4: {
                return (T)this.mIncludes;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        ProgramMeta other = (ProgramMeta)o;
        return Objects.equals(this.mFilePath, other.mFilePath) && Objects.equals(this.mFileLines, other.mFileLines) && Objects.equals(this.mProgram, other.mProgram) && Objects.equals(this.mIncludes, other.mIncludes);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{ProgramMeta.class, _Field.FILE_PATH, this.mFilePath, _Field.FILE_LINES, this.mFileLines, _Field.PROGRAM, this.mProgram, _Field.INCLUDES, this.mIncludes});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "pmodel.ProgramMeta" + this.asString();
    }

    @Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasFilePath()) {
            first = false;
            out.append("file_path:").append('\"').append(Strings.escape((CharSequence)this.mFilePath)).append('\"');
        }
        if (this.hasFileLines()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("file_lines:").append(Strings.asString(this.mFileLines));
        }
        if (this.hasProgram()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("program:").append(this.mProgram.asString());
        }
        if (this.hasIncludes()) {
            if (!first) {
                out.append(',');
            }
            out.append("includes:").append(Strings.asString(this.mIncludes));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(ProgramMeta other) {
        int c = Boolean.compare(this.mFilePath != null, other.mFilePath != null);
        if (c != 0) {
            return c;
        }
        if (this.mFilePath != null && (c = this.mFilePath.compareTo(other.mFilePath)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mFileLines != null, other.mFileLines != null);
        if (c != 0) {
            return c;
        }
        if (this.mFileLines != null && (c = Integer.compare(this.mFileLines.hashCode(), other.mFileLines.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mProgram != null, other.mProgram != null);
        if (c != 0) {
            return c;
        }
        if (this.mProgram != null && (c = this.mProgram.compareTo(other.mProgram)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mIncludes != null, other.mIncludes != null);
        if (c != 0) {
            return c;
        }
        if (this.mIncludes != null && (c = Integer.compare(this.mIncludes.hashCode(), other.mIncludes.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        BinarySerializer serializer = new BinarySerializer(false);
        serializer.serialize((OutputStream)oos, (PMessage)this);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        BinarySerializer serializer = new BinarySerializer(false);
        this.tSerializeInstance = (ProgramMeta)serializer.deserialize((InputStream)ois, kDescriptor);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.tSerializeInstance;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        if (this.hasFilePath()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)1);
            Binary tmp_1 = Binary.wrap((byte[])this.mFilePath.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_1.length());
            length += writer.writeBinary(tmp_1);
        }
        if (this.hasFileLines()) {
            length += writer.writeByte((byte)15);
            length += writer.writeShort((short)2);
            length += writer.writeByte((byte)11);
            length += writer.writeUInt32(this.mFileLines.size());
            for (String string : this.mFileLines) {
                Binary tmp_3 = Binary.wrap((byte[])string.getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_3.length());
                length += writer.writeBinary(tmp_3);
            }
        }
        if (this.hasProgram()) {
            length += writer.writeByte((byte)12);
            length += writer.writeShort((short)3);
            length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessage)this.mProgram);
        }
        if (this.hasIncludes()) {
            length += writer.writeByte((byte)13);
            length += writer.writeShort((short)4);
            length += writer.writeByte((byte)11);
            length += writer.writeByte((byte)12);
            length += writer.writeUInt32(this.mIncludes.size());
            for (Map.Entry entry : this.mIncludes.entrySet()) {
                Binary tmp_5 = Binary.wrap((byte[])((String)entry.getKey()).getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_5.length());
                length += writer.writeBinary(tmp_5);
                length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessage)((ProgramMeta)entry.getValue()));
            }
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    @Nonnull
    public static PStructDescriptorProvider<ProgramMeta, _Field> provider() {
        return new _Provider();
    }

    @Nonnull
    public PStructDescriptor<ProgramMeta, _Field> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<ProgramMeta, _Field>
    implements BinaryReader {
        private BitSet optionals = new BitSet(4);
        private BitSet modified = new BitSet(4);
        private String mFilePath;
        private List<String> mFileLines;
        private ProgramType mProgram;
        private ProgramType._Builder mProgram_builder;
        private Map<String, ProgramMeta> mIncludes;

        public _Builder() {
        }

        public _Builder(ProgramMeta base) {
            this();
            if (base.hasFilePath()) {
                this.optionals.set(0);
                this.mFilePath = base.mFilePath;
            }
            if (base.hasFileLines()) {
                this.optionals.set(1);
                this.mFileLines = base.mFileLines;
            }
            if (base.hasProgram()) {
                this.optionals.set(2);
                this.mProgram = base.mProgram;
            }
            if (base.hasIncludes()) {
                this.optionals.set(3);
                this.mIncludes = base.mIncludes;
            }
        }

        @Nonnull
        public _Builder merge(ProgramMeta from) {
            if (from.hasFilePath()) {
                this.optionals.set(0);
                this.modified.set(0);
                this.mFilePath = from.getFilePath();
            }
            if (from.hasFileLines()) {
                this.optionals.set(1);
                this.modified.set(1);
                this.mFileLines = from.getFileLines();
            }
            if (from.hasProgram()) {
                this.optionals.set(2);
                this.modified.set(2);
                if (this.mProgram_builder != null) {
                    this.mProgram_builder.merge(from.getProgram());
                } else if (this.mProgram != null) {
                    this.mProgram_builder = this.mProgram.mutate().merge(from.getProgram());
                    this.mProgram = null;
                } else {
                    this.mProgram = from.getProgram();
                }
            }
            if (from.hasIncludes()) {
                this.optionals.set(3);
                this.modified.set(3);
                this.mutableIncludes().putAll(from.getIncludes());
            }
            return this;
        }

        @Nonnull
        public _Builder setFilePath(String value) {
            if (value == null) {
                return this.clearFilePath();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mFilePath = value;
            return this;
        }

        public boolean isSetFilePath() {
            return this.optionals.get(0);
        }

        public boolean isModifiedFilePath() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearFilePath() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mFilePath = null;
            return this;
        }

        public String getFilePath() {
            return this.mFilePath;
        }

        @Nonnull
        public _Builder setFileLines(Collection<String> value) {
            if (value == null) {
                return this.clearFileLines();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mFileLines = ImmutableList.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder addToFileLines(String ... values) {
            this.optionals.set(1);
            this.modified.set(1);
            List<String> _container = this.mutableFileLines();
            for (String item : values) {
                _container.add(item);
            }
            return this;
        }

        public boolean isSetFileLines() {
            return this.optionals.get(1);
        }

        public boolean isModifiedFileLines() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearFileLines() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mFileLines = null;
            return this;
        }

        @Nonnull
        public List<String> mutableFileLines() {
            this.optionals.set(1);
            this.modified.set(1);
            if (this.mFileLines == null) {
                this.mFileLines = new ArrayList<String>();
            } else if (!(this.mFileLines instanceof ArrayList)) {
                this.mFileLines = new ArrayList<String>(this.mFileLines);
            }
            return this.mFileLines;
        }

        @Nonnull
        public _Builder setProgram(ProgramType value) {
            if (value == null) {
                return this.clearProgram();
            }
            this.optionals.set(2);
            this.modified.set(2);
            this.mProgram = value;
            this.mProgram_builder = null;
            return this;
        }

        @Nonnull
        public _Builder setProgram(ProgramType._Builder builder) {
            return this.setProgram(builder == null ? null : builder.build());
        }

        public boolean isSetProgram() {
            return this.optionals.get(2);
        }

        public boolean isModifiedProgram() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearProgram() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mProgram = null;
            this.mProgram_builder = null;
            return this;
        }

        @Nonnull
        public ProgramType._Builder mutableProgram() {
            this.optionals.set(2);
            this.modified.set(2);
            if (this.mProgram != null) {
                this.mProgram_builder = this.mProgram.mutate();
                this.mProgram = null;
            } else if (this.mProgram_builder == null) {
                this.mProgram_builder = ProgramType.builder();
            }
            return this.mProgram_builder;
        }

        public ProgramType getProgram() {
            if (this.mProgram_builder != null) {
                return this.mProgram_builder.build();
            }
            return this.mProgram;
        }

        @Nonnull
        public _Builder setIncludes(Map<String, ProgramMeta> value) {
            if (value == null) {
                return this.clearIncludes();
            }
            this.optionals.set(3);
            this.modified.set(3);
            this.mIncludes = ImmutableMap.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder putInIncludes(String key, ProgramMeta value) {
            this.optionals.set(3);
            this.modified.set(3);
            this.mutableIncludes().put(key, value);
            return this;
        }

        public boolean isSetIncludes() {
            return this.optionals.get(3);
        }

        public boolean isModifiedIncludes() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearIncludes() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mIncludes = null;
            return this;
        }

        @Nonnull
        public Map<String, ProgramMeta> mutableIncludes() {
            this.optionals.set(3);
            this.modified.set(3);
            if (this.mIncludes == null) {
                this.mIncludes = new HashMap<String, ProgramMeta>();
            } else if (!(this.mIncludes instanceof HashMap)) {
                this.mIncludes = new HashMap<String, ProgramMeta>(this.mIncludes);
            }
            return this.mIncludes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
                return false;
            }
            _Builder other = (_Builder)((Object)o);
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mFilePath, other.mFilePath) && Objects.equals(this.mFileLines, other.mFileLines) && Objects.equals(this.getProgram(), other.getProgram()) && Objects.equals(this.mIncludes, other.mIncludes);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{ProgramMeta.class, this.optionals, _Field.FILE_PATH, this.mFilePath, _Field.FILE_LINES, this.mFileLines, _Field.PROGRAM, this.getProgram(), _Field.INCLUDES, this.mIncludes});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                case 3: {
                    return this.mutableProgram();
                }
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setFilePath((String)value);
                    break;
                }
                case 2: {
                    this.setFileLines((List)value);
                    break;
                }
                case 3: {
                    this.setProgram((ProgramType)value);
                    break;
                }
                case 4: {
                    this.setIncludes((Map)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 3: {
                    return this.optionals.get(2);
                }
                case 4: {
                    return this.optionals.get(3);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 3: {
                    return this.modified.get(2);
                }
                case 4: {
                    return this.modified.get(3);
                }
            }
            return false;
        }

        @Nonnull
        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 2: {
                    this.addToFileLines((String)value);
                    break;
                }
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearFilePath();
                    break;
                }
                case 2: {
                    this.clearFileLines();
                    break;
                }
                case 3: {
                    this.clearProgram();
                    break;
                }
                case 4: {
                    this.clearIncludes();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return true;
        }

        public void validate() {
        }

        @Nonnull
        public PStructDescriptor<ProgramMeta, _Field> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mFilePath = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.ProgramMeta.file_path, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 15) {
                            PList.DefaultBuilder b_2 = new PList.DefaultBuilder();
                            byte t_4 = reader.expectByte();
                            if (t_4 == 11) {
                                int len_3 = reader.expectUInt32();
                                for (int i_5 = 0; i_5 < len_3; ++i_5) {
                                    int len_7 = reader.expectUInt32();
                                    String key_6 = new String(reader.expectBytes(len_7), StandardCharsets.UTF_8);
                                    b_2.add((Object)key_6);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_4) + " for pmodel.ProgramMeta.file_lines, should be string(11)", new Object[0]);
                            }
                            this.mFileLines = b_2.build();
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.ProgramMeta.file_lines, should be struct(12)", new Object[0]);
                    }
                    case 3: {
                        if (type == 12) {
                            this.mProgram = (ProgramType)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, ProgramType.kDescriptor, (boolean)strict);
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.ProgramMeta.program, should be struct(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 13) {
                            PMap.DefaultBuilder b_8 = new PMap.DefaultBuilder();
                            byte t_10 = reader.expectByte();
                            byte t_11 = reader.expectByte();
                            if (t_10 == 11 && t_11 == 12) {
                                int len_9 = reader.expectUInt32();
                                for (int i_12 = 0; i_12 < len_9; ++i_12) {
                                    int len_15 = reader.expectUInt32();
                                    String key_13 = new String(reader.expectBytes(len_15), StandardCharsets.UTF_8);
                                    ProgramMeta val_14 = (ProgramMeta)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, kDescriptor, (boolean)strict);
                                    b_8.put((Object)key_13, (Object)val_14);
                                }
                            } else {
                                throw new SerializerException("Wrong key type " + BinaryType.asString((byte)t_10) + " or value type " + BinaryType.asString((byte)t_11) + " for pmodel.ProgramMeta.includes, should be string(11) and struct(12)", new Object[0]);
                            }
                            this.mIncludes = b_8.build();
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.ProgramMeta.includes, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        public ProgramMeta build() {
            return new ProgramMeta(this);
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<ProgramMeta, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<ProgramMeta, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<ProgramMeta, _Field> {
        public _Descriptor() {
            super("pmodel", "ProgramMeta", _Builder::new, false);
        }

        @Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    public static enum _Field implements PField
    {
        FILE_PATH(1, PRequirement.OPTIONAL, "file_path", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        FILE_LINES(2, PRequirement.OPTIONAL, "file_lines", (PDescriptorProvider)PList.provider((PDescriptorProvider)PPrimitive.STRING.provider()), null),
        PROGRAM(3, PRequirement.OPTIONAL, "program", (PDescriptorProvider)ProgramType.provider(), null),
        INCLUDES(4, PRequirement.OPTIONAL, "includes", (PDescriptorProvider)PMap.provider((PDescriptorProvider)PPrimitive.STRING.provider(), ProgramMeta.provider()), null);

        private final int mId;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int id, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mId = id;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getId() {
            return this.mId;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field findById(int id) {
            switch (id) {
                case 1: {
                    return FILE_PATH;
                }
                case 2: {
                    return FILE_LINES;
                }
                case 3: {
                    return PROGRAM;
                }
                case 4: {
                    return INCLUDES;
                }
            }
            return null;
        }

        public static _Field findByName(String name) {
            switch (name) {
                case "file_path": {
                    return FILE_PATH;
                }
                case "file_lines": {
                    return FILE_LINES;
                }
                case "program": {
                    return PROGRAM;
                }
                case "includes": {
                    return INCLUDES;
                }
            }
            return null;
        }

        public static _Field fieldForId(int id) {
            _Field field = _Field.findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in pmodel.ProgramMeta");
            }
            return field;
        }

        public static _Field fieldForName(String name) {
            _Field field = _Field.findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in pmodel.ProgramMeta");
            }
            return field;
        }
    }
}

