/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.FieldRequirement;
import net.morimekta.providence.model.FilePos;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

@Immutable
public class FieldType
implements PMessage<FieldType, _Field>,
Comparable<FieldType>,
Serializable,
BinaryWriter {
    private static final long serialVersionUID = 3572042762986343919L;
    private static final int kDefaultId = 0;
    private static final FieldRequirement kDefaultRequirement = FieldRequirement.DEFAULT;
    private static final String kDefaultType = "";
    private static final String kDefaultName = "";
    private final transient String mDocumentation;
    private final transient int mId;
    private final transient FieldRequirement mRequirement;
    private final transient String mType;
    private final transient String mName;
    private final transient String mDefaultValue;
    private final transient Map<String, String> mAnnotations;
    private final transient FilePos mValueStartPos;
    private final transient FilePos mStartPos;
    private final transient FilePos mEndPos;
    private volatile transient int tHashCode;
    private transient FieldType tSerializeInstance;
    public static final PStructDescriptor<FieldType, _Field> kDescriptor = new _Descriptor();

    private FieldType(_Builder builder) {
        this.mDocumentation = builder.mDocumentation;
        this.mId = builder.mId;
        this.mRequirement = builder.mRequirement;
        this.mType = builder.isSetType() ? builder.mType : "";
        this.mName = builder.isSetName() ? builder.mName : "";
        this.mDefaultValue = builder.mDefaultValue;
        this.mAnnotations = builder.isSetAnnotations() ? ImmutableSortedMap.copyOf((Map)builder.mAnnotations) : null;
        this.mValueStartPos = builder.mValueStartPos_builder != null ? builder.mValueStartPos_builder.build() : builder.mValueStartPos;
        this.mStartPos = builder.mStartPos_builder != null ? builder.mStartPos_builder.build() : builder.mStartPos;
        this.mEndPos = builder.mEndPos_builder != null ? builder.mEndPos_builder.build() : builder.mEndPos;
    }

    public boolean hasDocumentation() {
        return this.mDocumentation != null;
    }

    public String getDocumentation() {
        return this.mDocumentation;
    }

    @Nonnull
    public Optional<String> optionalDocumentation() {
        return Optional.ofNullable(this.mDocumentation);
    }

    public boolean hasId() {
        return true;
    }

    public int getId() {
        return this.mId;
    }

    public boolean hasRequirement() {
        return this.mRequirement != null;
    }

    public FieldRequirement getRequirement() {
        return this.hasRequirement() ? this.mRequirement : kDefaultRequirement;
    }

    @Nonnull
    public Optional<FieldRequirement> optionalRequirement() {
        return Optional.ofNullable(this.mRequirement);
    }

    public boolean hasType() {
        return true;
    }

    @Nonnull
    public String getType() {
        return this.mType;
    }

    public boolean hasName() {
        return true;
    }

    @Nonnull
    public String getName() {
        return this.mName;
    }

    public boolean hasDefaultValue() {
        return this.mDefaultValue != null;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    @Nonnull
    public Optional<String> optionalDefaultValue() {
        return Optional.ofNullable(this.mDefaultValue);
    }

    public int numAnnotations() {
        return this.mAnnotations != null ? this.mAnnotations.size() : 0;
    }

    public boolean hasAnnotations() {
        return this.mAnnotations != null;
    }

    public Map<String, String> getAnnotations() {
        return this.mAnnotations;
    }

    @Nonnull
    public Optional<Map<String, String>> optionalAnnotations() {
        return Optional.ofNullable(this.mAnnotations);
    }

    public boolean hasValueStartPos() {
        return this.mValueStartPos != null;
    }

    public FilePos getValueStartPos() {
        return this.mValueStartPos;
    }

    @Nonnull
    public Optional<FilePos> optionalValueStartPos() {
        return Optional.ofNullable(this.mValueStartPos);
    }

    public boolean hasStartPos() {
        return this.mStartPos != null;
    }

    public FilePos getStartPos() {
        return this.mStartPos;
    }

    @Nonnull
    public Optional<FilePos> optionalStartPos() {
        return Optional.ofNullable(this.mStartPos);
    }

    public boolean hasEndPos() {
        return this.mEndPos != null;
    }

    public FilePos getEndPos() {
        return this.mEndPos;
    }

    @Nonnull
    public Optional<FilePos> optionalEndPos() {
        return Optional.ofNullable(this.mEndPos);
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.mDocumentation != null;
            }
            case 2: {
                return true;
            }
            case 3: {
                return this.mRequirement != null;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return this.mDefaultValue != null;
            }
            case 7: {
                return this.mAnnotations != null;
            }
            case 9: {
                return this.mValueStartPos != null;
            }
            case 10: {
                return this.mStartPos != null;
            }
            case 11: {
                return this.mEndPos != null;
            }
        }
        return false;
    }

    public <T> T get(int key) {
        switch (key) {
            case 1: {
                return (T)this.mDocumentation;
            }
            case 2: {
                return (T)Integer.valueOf(this.mId);
            }
            case 3: {
                return (T)((Object)this.mRequirement);
            }
            case 4: {
                return (T)this.mType;
            }
            case 5: {
                return (T)this.mName;
            }
            case 6: {
                return (T)this.mDefaultValue;
            }
            case 7: {
                return (T)this.mAnnotations;
            }
            case 9: {
                return (T)this.mValueStartPos;
            }
            case 10: {
                return (T)this.mStartPos;
            }
            case 11: {
                return (T)this.mEndPos;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        FieldType other = (FieldType)o;
        return Objects.equals(this.mDocumentation, other.mDocumentation) && Objects.equals(this.mId, other.mId) && Objects.equals((Object)this.mRequirement, (Object)other.mRequirement) && Objects.equals(this.mType, other.mType) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mDefaultValue, other.mDefaultValue) && Objects.equals(this.mAnnotations, other.mAnnotations) && Objects.equals(this.mValueStartPos, other.mValueStartPos) && Objects.equals(this.mStartPos, other.mStartPos) && Objects.equals(this.mEndPos, other.mEndPos);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{FieldType.class, _Field.DOCUMENTATION, this.mDocumentation, _Field.ID, this.mId, _Field.REQUIREMENT, this.mRequirement, _Field.TYPE, this.mType, _Field.NAME, this.mName, _Field.DEFAULT_VALUE, this.mDefaultValue, _Field.ANNOTATIONS, this.mAnnotations, _Field.VALUE_START_POS, this.mValueStartPos, _Field.START_POS, this.mStartPos, _Field.END_POS, this.mEndPos});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "pmodel.FieldType" + this.asString();
    }

    @Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasDocumentation()) {
            first = false;
            out.append("documentation:").append('\"').append(Strings.escape((CharSequence)this.mDocumentation)).append('\"');
        }
        if (!first) {
            out.append(',');
        }
        out.append("id:").append(this.mId);
        if (this.hasRequirement()) {
            out.append(',');
            out.append("requirement:").append(this.mRequirement.asString());
        }
        out.append(',');
        out.append("type:").append('\"').append(Strings.escape((CharSequence)this.mType)).append('\"');
        out.append(',');
        out.append("name:").append('\"').append(Strings.escape((CharSequence)this.mName)).append('\"');
        if (this.hasDefaultValue()) {
            out.append(',');
            out.append("default_value:").append('\"').append(Strings.escape((CharSequence)this.mDefaultValue)).append('\"');
        }
        if (this.hasAnnotations()) {
            out.append(',');
            out.append("annotations:").append(Strings.asString(this.mAnnotations));
        }
        if (this.hasValueStartPos()) {
            out.append(',');
            out.append("value_start_pos:").append(this.mValueStartPos.asString());
        }
        if (this.hasStartPos()) {
            out.append(',');
            out.append("start_pos:").append(this.mStartPos.asString());
        }
        if (this.hasEndPos()) {
            out.append(',');
            out.append("end_pos:").append(this.mEndPos.asString());
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(FieldType other) {
        int c = Boolean.compare(this.mDocumentation != null, other.mDocumentation != null);
        if (c != 0) {
            return c;
        }
        if (this.mDocumentation != null && (c = this.mDocumentation.compareTo(other.mDocumentation)) != 0) {
            return c;
        }
        c = Integer.compare(this.mId, other.mId);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mRequirement != null, other.mRequirement != null);
        if (c != 0) {
            return c;
        }
        if (this.mRequirement != null && (c = Integer.compare(this.mRequirement.ordinal(), this.mRequirement.ordinal())) != 0) {
            return c;
        }
        c = this.mType.compareTo(other.mType);
        if (c != 0) {
            return c;
        }
        c = this.mName.compareTo(other.mName);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mDefaultValue != null, other.mDefaultValue != null);
        if (c != 0) {
            return c;
        }
        if (this.mDefaultValue != null && (c = this.mDefaultValue.compareTo(other.mDefaultValue)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mAnnotations != null, other.mAnnotations != null);
        if (c != 0) {
            return c;
        }
        if (this.mAnnotations != null && (c = Integer.compare(this.mAnnotations.hashCode(), other.mAnnotations.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mValueStartPos != null, other.mValueStartPos != null);
        if (c != 0) {
            return c;
        }
        if (this.mValueStartPos != null && (c = this.mValueStartPos.compareTo(other.mValueStartPos)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mStartPos != null, other.mStartPos != null);
        if (c != 0) {
            return c;
        }
        if (this.mStartPos != null && (c = this.mStartPos.compareTo(other.mStartPos)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mEndPos != null, other.mEndPos != null);
        if (c != 0) {
            return c;
        }
        if (this.mEndPos != null && (c = this.mEndPos.compareTo(other.mEndPos)) != 0) {
            return c;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        BinarySerializer serializer = new BinarySerializer(false);
        serializer.serialize((OutputStream)oos, (PMessage)this);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        BinarySerializer serializer = new BinarySerializer(false);
        this.tSerializeInstance = (FieldType)serializer.deserialize((InputStream)ois, kDescriptor);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.tSerializeInstance;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        if (this.hasDocumentation()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)1);
            Binary tmp_1 = Binary.wrap((byte[])this.mDocumentation.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_1.length());
            length += writer.writeBinary(tmp_1);
        }
        length += writer.writeByte((byte)8);
        length += writer.writeShort((short)2);
        length += writer.writeInt(this.mId);
        if (this.hasRequirement()) {
            length += writer.writeByte((byte)8);
            length += writer.writeShort((short)3);
            length += writer.writeInt(this.mRequirement.asInteger());
        }
        length += writer.writeByte((byte)11);
        length += writer.writeShort((short)4);
        Binary tmp_2 = Binary.wrap((byte[])this.mType.getBytes(StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_2.length());
        length += writer.writeBinary(tmp_2);
        length += writer.writeByte((byte)11);
        length += writer.writeShort((short)5);
        Binary tmp_3 = Binary.wrap((byte[])this.mName.getBytes(StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_3.length());
        length += writer.writeBinary(tmp_3);
        if (this.hasDefaultValue()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)6);
            Binary tmp_4 = Binary.wrap((byte[])this.mDefaultValue.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_4.length());
            length += writer.writeBinary(tmp_4);
        }
        if (this.hasAnnotations()) {
            length += writer.writeByte((byte)13);
            length += writer.writeShort((short)7);
            length += writer.writeByte((byte)11);
            length += writer.writeByte((byte)11);
            length += writer.writeUInt32(this.mAnnotations.size());
            for (Map.Entry<String, String> entry_5 : this.mAnnotations.entrySet()) {
                Binary tmp_6 = Binary.wrap((byte[])entry_5.getKey().getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_6.length());
                length += writer.writeBinary(tmp_6);
                Binary tmp_7 = Binary.wrap((byte[])entry_5.getValue().getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_7.length());
                length += writer.writeBinary(tmp_7);
            }
        }
        if (this.hasValueStartPos()) {
            length += writer.writeByte((byte)12);
            length += writer.writeShort((short)9);
            length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessage)this.mValueStartPos);
        }
        if (this.hasStartPos()) {
            length += writer.writeByte((byte)12);
            length += writer.writeShort((short)10);
            length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessage)this.mStartPos);
        }
        if (this.hasEndPos()) {
            length += writer.writeByte((byte)12);
            length += writer.writeShort((short)11);
            length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessage)this.mEndPos);
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    @Nonnull
    public static PStructDescriptorProvider<FieldType, _Field> provider() {
        return new _Provider();
    }

    @Nonnull
    public PStructDescriptor<FieldType, _Field> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<FieldType, _Field>
    implements BinaryReader {
        private BitSet optionals = new BitSet(10);
        private BitSet modified = new BitSet(10);
        private String mDocumentation;
        private int mId = 0;
        private FieldRequirement mRequirement;
        private String mType = "";
        private String mName = "";
        private String mDefaultValue;
        private Map<String, String> mAnnotations;
        private FilePos mValueStartPos;
        private FilePos._Builder mValueStartPos_builder;
        private FilePos mStartPos;
        private FilePos._Builder mStartPos_builder;
        private FilePos mEndPos;
        private FilePos._Builder mEndPos_builder;

        public _Builder() {
        }

        public _Builder(FieldType base) {
            this();
            if (base.hasDocumentation()) {
                this.optionals.set(0);
                this.mDocumentation = base.mDocumentation;
            }
            this.optionals.set(1);
            this.mId = base.mId;
            if (base.hasRequirement()) {
                this.optionals.set(2);
                this.mRequirement = base.mRequirement;
            }
            this.optionals.set(3);
            this.mType = base.mType;
            this.optionals.set(4);
            this.mName = base.mName;
            if (base.hasDefaultValue()) {
                this.optionals.set(5);
                this.mDefaultValue = base.mDefaultValue;
            }
            if (base.hasAnnotations()) {
                this.optionals.set(6);
                this.mAnnotations = base.mAnnotations;
            }
            if (base.hasValueStartPos()) {
                this.optionals.set(7);
                this.mValueStartPos = base.mValueStartPos;
            }
            if (base.hasStartPos()) {
                this.optionals.set(8);
                this.mStartPos = base.mStartPos;
            }
            if (base.hasEndPos()) {
                this.optionals.set(9);
                this.mEndPos = base.mEndPos;
            }
        }

        @Nonnull
        public _Builder merge(FieldType from) {
            if (from.hasDocumentation()) {
                this.optionals.set(0);
                this.modified.set(0);
                this.mDocumentation = from.getDocumentation();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mId = from.getId();
            if (from.hasRequirement()) {
                this.optionals.set(2);
                this.modified.set(2);
                this.mRequirement = from.getRequirement();
            }
            this.optionals.set(3);
            this.modified.set(3);
            this.mType = from.getType();
            this.optionals.set(4);
            this.modified.set(4);
            this.mName = from.getName();
            if (from.hasDefaultValue()) {
                this.optionals.set(5);
                this.modified.set(5);
                this.mDefaultValue = from.getDefaultValue();
            }
            if (from.hasAnnotations()) {
                this.optionals.set(6);
                this.modified.set(6);
                this.mutableAnnotations().putAll(from.getAnnotations());
            }
            if (from.hasValueStartPos()) {
                this.optionals.set(7);
                this.modified.set(7);
                if (this.mValueStartPos_builder != null) {
                    this.mValueStartPos_builder.merge(from.getValueStartPos());
                } else if (this.mValueStartPos != null) {
                    this.mValueStartPos_builder = this.mValueStartPos.mutate().merge(from.getValueStartPos());
                    this.mValueStartPos = null;
                } else {
                    this.mValueStartPos = from.getValueStartPos();
                }
            }
            if (from.hasStartPos()) {
                this.optionals.set(8);
                this.modified.set(8);
                if (this.mStartPos_builder != null) {
                    this.mStartPos_builder.merge(from.getStartPos());
                } else if (this.mStartPos != null) {
                    this.mStartPos_builder = this.mStartPos.mutate().merge(from.getStartPos());
                    this.mStartPos = null;
                } else {
                    this.mStartPos = from.getStartPos();
                }
            }
            if (from.hasEndPos()) {
                this.optionals.set(9);
                this.modified.set(9);
                if (this.mEndPos_builder != null) {
                    this.mEndPos_builder.merge(from.getEndPos());
                } else if (this.mEndPos != null) {
                    this.mEndPos_builder = this.mEndPos.mutate().merge(from.getEndPos());
                    this.mEndPos = null;
                } else {
                    this.mEndPos = from.getEndPos();
                }
            }
            return this;
        }

        @Nonnull
        public _Builder setDocumentation(String value) {
            if (value == null) {
                return this.clearDocumentation();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mDocumentation = value;
            return this;
        }

        public boolean isSetDocumentation() {
            return this.optionals.get(0);
        }

        public boolean isModifiedDocumentation() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearDocumentation() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mDocumentation = null;
            return this;
        }

        public String getDocumentation() {
            return this.mDocumentation;
        }

        @Nonnull
        public _Builder setId(int value) {
            this.optionals.set(1);
            this.modified.set(1);
            this.mId = value;
            return this;
        }

        public boolean isSetId() {
            return this.optionals.get(1);
        }

        public boolean isModifiedId() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearId() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mId = 0;
            return this;
        }

        public int getId() {
            return this.mId;
        }

        @Nonnull
        public _Builder setRequirement(FieldRequirement value) {
            if (value == null) {
                return this.clearRequirement();
            }
            this.optionals.set(2);
            this.modified.set(2);
            this.mRequirement = value;
            return this;
        }

        public boolean isSetRequirement() {
            return this.optionals.get(2);
        }

        public boolean isModifiedRequirement() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearRequirement() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mRequirement = null;
            return this;
        }

        public FieldRequirement getRequirement() {
            return this.isSetRequirement() ? this.mRequirement : kDefaultRequirement;
        }

        @Nonnull
        public _Builder setType(String value) {
            if (value == null) {
                return this.clearType();
            }
            this.optionals.set(3);
            this.modified.set(3);
            this.mType = value;
            return this;
        }

        public boolean isSetType() {
            return this.optionals.get(3);
        }

        public boolean isModifiedType() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearType() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mType = "";
            return this;
        }

        public String getType() {
            return this.mType;
        }

        @Nonnull
        public _Builder setName(String value) {
            if (value == null) {
                return this.clearName();
            }
            this.optionals.set(4);
            this.modified.set(4);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(4);
        }

        public boolean isModifiedName() {
            return this.modified.get(4);
        }

        @Nonnull
        public _Builder clearName() {
            this.optionals.clear(4);
            this.modified.set(4);
            this.mName = "";
            return this;
        }

        public String getName() {
            return this.mName;
        }

        @Nonnull
        public _Builder setDefaultValue(String value) {
            if (value == null) {
                return this.clearDefaultValue();
            }
            this.optionals.set(5);
            this.modified.set(5);
            this.mDefaultValue = value;
            return this;
        }

        public boolean isSetDefaultValue() {
            return this.optionals.get(5);
        }

        public boolean isModifiedDefaultValue() {
            return this.modified.get(5);
        }

        @Nonnull
        public _Builder clearDefaultValue() {
            this.optionals.clear(5);
            this.modified.set(5);
            this.mDefaultValue = null;
            return this;
        }

        public String getDefaultValue() {
            return this.mDefaultValue;
        }

        @Nonnull
        public _Builder setAnnotations(Map<String, String> value) {
            if (value == null) {
                return this.clearAnnotations();
            }
            this.optionals.set(6);
            this.modified.set(6);
            this.mAnnotations = ImmutableSortedMap.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder putInAnnotations(String key, String value) {
            this.optionals.set(6);
            this.modified.set(6);
            this.mutableAnnotations().put(key, value);
            return this;
        }

        public boolean isSetAnnotations() {
            return this.optionals.get(6);
        }

        public boolean isModifiedAnnotations() {
            return this.modified.get(6);
        }

        @Nonnull
        public _Builder clearAnnotations() {
            this.optionals.clear(6);
            this.modified.set(6);
            this.mAnnotations = null;
            return this;
        }

        @Nonnull
        public Map<String, String> mutableAnnotations() {
            this.optionals.set(6);
            this.modified.set(6);
            if (this.mAnnotations == null) {
                this.mAnnotations = new TreeMap<String, String>();
            } else if (!(this.mAnnotations instanceof TreeMap)) {
                this.mAnnotations = new TreeMap<String, String>(this.mAnnotations);
            }
            return this.mAnnotations;
        }

        @Nonnull
        public _Builder setValueStartPos(FilePos value) {
            if (value == null) {
                return this.clearValueStartPos();
            }
            this.optionals.set(7);
            this.modified.set(7);
            this.mValueStartPos = value;
            this.mValueStartPos_builder = null;
            return this;
        }

        @Nonnull
        public _Builder setValueStartPos(FilePos._Builder builder) {
            return this.setValueStartPos(builder == null ? null : builder.build());
        }

        public boolean isSetValueStartPos() {
            return this.optionals.get(7);
        }

        public boolean isModifiedValueStartPos() {
            return this.modified.get(7);
        }

        @Nonnull
        public _Builder clearValueStartPos() {
            this.optionals.clear(7);
            this.modified.set(7);
            this.mValueStartPos = null;
            this.mValueStartPos_builder = null;
            return this;
        }

        @Nonnull
        public FilePos._Builder mutableValueStartPos() {
            this.optionals.set(7);
            this.modified.set(7);
            if (this.mValueStartPos != null) {
                this.mValueStartPos_builder = this.mValueStartPos.mutate();
                this.mValueStartPos = null;
            } else if (this.mValueStartPos_builder == null) {
                this.mValueStartPos_builder = FilePos.builder();
            }
            return this.mValueStartPos_builder;
        }

        public FilePos getValueStartPos() {
            if (this.mValueStartPos_builder != null) {
                return this.mValueStartPos_builder.build();
            }
            return this.mValueStartPos;
        }

        @Nonnull
        public _Builder setStartPos(FilePos value) {
            if (value == null) {
                return this.clearStartPos();
            }
            this.optionals.set(8);
            this.modified.set(8);
            this.mStartPos = value;
            this.mStartPos_builder = null;
            return this;
        }

        @Nonnull
        public _Builder setStartPos(FilePos._Builder builder) {
            return this.setStartPos(builder == null ? null : builder.build());
        }

        public boolean isSetStartPos() {
            return this.optionals.get(8);
        }

        public boolean isModifiedStartPos() {
            return this.modified.get(8);
        }

        @Nonnull
        public _Builder clearStartPos() {
            this.optionals.clear(8);
            this.modified.set(8);
            this.mStartPos = null;
            this.mStartPos_builder = null;
            return this;
        }

        @Nonnull
        public FilePos._Builder mutableStartPos() {
            this.optionals.set(8);
            this.modified.set(8);
            if (this.mStartPos != null) {
                this.mStartPos_builder = this.mStartPos.mutate();
                this.mStartPos = null;
            } else if (this.mStartPos_builder == null) {
                this.mStartPos_builder = FilePos.builder();
            }
            return this.mStartPos_builder;
        }

        public FilePos getStartPos() {
            if (this.mStartPos_builder != null) {
                return this.mStartPos_builder.build();
            }
            return this.mStartPos;
        }

        @Nonnull
        public _Builder setEndPos(FilePos value) {
            if (value == null) {
                return this.clearEndPos();
            }
            this.optionals.set(9);
            this.modified.set(9);
            this.mEndPos = value;
            this.mEndPos_builder = null;
            return this;
        }

        @Nonnull
        public _Builder setEndPos(FilePos._Builder builder) {
            return this.setEndPos(builder == null ? null : builder.build());
        }

        public boolean isSetEndPos() {
            return this.optionals.get(9);
        }

        public boolean isModifiedEndPos() {
            return this.modified.get(9);
        }

        @Nonnull
        public _Builder clearEndPos() {
            this.optionals.clear(9);
            this.modified.set(9);
            this.mEndPos = null;
            this.mEndPos_builder = null;
            return this;
        }

        @Nonnull
        public FilePos._Builder mutableEndPos() {
            this.optionals.set(9);
            this.modified.set(9);
            if (this.mEndPos != null) {
                this.mEndPos_builder = this.mEndPos.mutate();
                this.mEndPos = null;
            } else if (this.mEndPos_builder == null) {
                this.mEndPos_builder = FilePos.builder();
            }
            return this.mEndPos_builder;
        }

        public FilePos getEndPos() {
            if (this.mEndPos_builder != null) {
                return this.mEndPos_builder.build();
            }
            return this.mEndPos;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
                return false;
            }
            _Builder other = (_Builder)((Object)o);
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mDocumentation, other.mDocumentation) && Objects.equals(this.mId, other.mId) && Objects.equals((Object)this.mRequirement, (Object)other.mRequirement) && Objects.equals(this.mType, other.mType) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mDefaultValue, other.mDefaultValue) && Objects.equals(this.mAnnotations, other.mAnnotations) && Objects.equals(this.getValueStartPos(), other.getValueStartPos()) && Objects.equals(this.getStartPos(), other.getStartPos()) && Objects.equals(this.getEndPos(), other.getEndPos());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{FieldType.class, this.optionals, _Field.DOCUMENTATION, this.mDocumentation, _Field.ID, this.mId, _Field.REQUIREMENT, this.mRequirement, _Field.TYPE, this.mType, _Field.NAME, this.mName, _Field.DEFAULT_VALUE, this.mDefaultValue, _Field.ANNOTATIONS, this.mAnnotations, _Field.VALUE_START_POS, this.getValueStartPos(), _Field.START_POS, this.getStartPos(), _Field.END_POS, this.getEndPos()});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                case 9: {
                    return this.mutableValueStartPos();
                }
                case 10: {
                    return this.mutableStartPos();
                }
                case 11: {
                    return this.mutableEndPos();
                }
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setDocumentation((String)value);
                    break;
                }
                case 2: {
                    this.setId((Integer)value);
                    break;
                }
                case 3: {
                    this.setRequirement((FieldRequirement)((Object)value));
                    break;
                }
                case 4: {
                    this.setType((String)value);
                    break;
                }
                case 5: {
                    this.setName((String)value);
                    break;
                }
                case 6: {
                    this.setDefaultValue((String)value);
                    break;
                }
                case 7: {
                    this.setAnnotations((Map)value);
                    break;
                }
                case 9: {
                    this.setValueStartPos((FilePos)value);
                    break;
                }
                case 10: {
                    this.setStartPos((FilePos)value);
                    break;
                }
                case 11: {
                    this.setEndPos((FilePos)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 3: {
                    return this.optionals.get(2);
                }
                case 4: {
                    return this.optionals.get(3);
                }
                case 5: {
                    return this.optionals.get(4);
                }
                case 6: {
                    return this.optionals.get(5);
                }
                case 7: {
                    return this.optionals.get(6);
                }
                case 9: {
                    return this.optionals.get(7);
                }
                case 10: {
                    return this.optionals.get(8);
                }
                case 11: {
                    return this.optionals.get(9);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 3: {
                    return this.modified.get(2);
                }
                case 4: {
                    return this.modified.get(3);
                }
                case 5: {
                    return this.modified.get(4);
                }
                case 6: {
                    return this.modified.get(5);
                }
                case 7: {
                    return this.modified.get(6);
                }
                case 9: {
                    return this.modified.get(7);
                }
                case 10: {
                    return this.modified.get(8);
                }
                case 11: {
                    return this.modified.get(9);
                }
            }
            return false;
        }

        @Nonnull
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearDocumentation();
                    break;
                }
                case 2: {
                    this.clearId();
                    break;
                }
                case 3: {
                    this.clearRequirement();
                    break;
                }
                case 4: {
                    this.clearType();
                    break;
                }
                case 5: {
                    this.clearName();
                    break;
                }
                case 6: {
                    this.clearDefaultValue();
                    break;
                }
                case 7: {
                    this.clearAnnotations();
                    break;
                }
                case 9: {
                    this.clearValueStartPos();
                    break;
                }
                case 10: {
                    this.clearStartPos();
                    break;
                }
                case 11: {
                    this.clearEndPos();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return this.optionals.get(1) && this.optionals.get(3) && this.optionals.get(4) && this.optionals.get(7);
        }

        public void validate() {
            if (!this.valid()) {
                ArrayList<String> missing = new ArrayList<String>();
                if (!this.optionals.get(1)) {
                    missing.add("id");
                }
                if (!this.optionals.get(3)) {
                    missing.add("type");
                }
                if (!this.optionals.get(4)) {
                    missing.add("name");
                }
                if (!this.optionals.get(7)) {
                    missing.add("value_start_pos");
                }
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message pmodel.FieldType");
            }
        }

        @Nonnull
        public PStructDescriptor<FieldType, _Field> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mDocumentation = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.FieldType.documentation, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 8) {
                            this.mId = reader.expectInt();
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.FieldType.id, should be struct(12)", new Object[0]);
                    }
                    case 3: {
                        if (type == 8) {
                            this.mRequirement = FieldRequirement.findById(reader.expectInt());
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.FieldType.requirement, should be struct(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            this.mType = new String(reader.expectBytes(len_2), StandardCharsets.UTF_8);
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.FieldType.type, should be struct(12)", new Object[0]);
                    }
                    case 5: {
                        if (type == 11) {
                            int len_3 = reader.expectUInt32();
                            this.mName = new String(reader.expectBytes(len_3), StandardCharsets.UTF_8);
                            this.optionals.set(4);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.FieldType.name, should be struct(12)", new Object[0]);
                    }
                    case 6: {
                        if (type == 11) {
                            int len_4 = reader.expectUInt32();
                            this.mDefaultValue = new String(reader.expectBytes(len_4), StandardCharsets.UTF_8);
                            this.optionals.set(5);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.FieldType.default_value, should be struct(12)", new Object[0]);
                    }
                    case 7: {
                        if (type == 13) {
                            PMap.SortedBuilder b_5 = new PMap.SortedBuilder();
                            byte t_7 = reader.expectByte();
                            byte t_8 = reader.expectByte();
                            if (t_7 == 11 && t_8 == 11) {
                                int len_6 = reader.expectUInt32();
                                for (int i_9 = 0; i_9 < len_6; ++i_9) {
                                    int len_12 = reader.expectUInt32();
                                    String key_10 = new String(reader.expectBytes(len_12), StandardCharsets.UTF_8);
                                    int len_13 = reader.expectUInt32();
                                    String val_11 = new String(reader.expectBytes(len_13), StandardCharsets.UTF_8);
                                    b_5.put((Comparable)((Object)key_10), (Object)val_11);
                                }
                            } else {
                                throw new SerializerException("Wrong key type " + BinaryType.asString((byte)t_7) + " or value type " + BinaryType.asString((byte)t_8) + " for pmodel.FieldType.annotations, should be string(11) and string(11)", new Object[0]);
                            }
                            this.mAnnotations = b_5.build();
                            this.optionals.set(6);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.FieldType.annotations, should be struct(12)", new Object[0]);
                    }
                    case 9: {
                        if (type == 12) {
                            this.mValueStartPos = (FilePos)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, FilePos.kDescriptor, (boolean)strict);
                            this.optionals.set(7);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.FieldType.value_start_pos, should be struct(12)", new Object[0]);
                    }
                    case 10: {
                        if (type == 12) {
                            this.mStartPos = (FilePos)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, FilePos.kDescriptor, (boolean)strict);
                            this.optionals.set(8);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.FieldType.start_pos, should be struct(12)", new Object[0]);
                    }
                    case 11: {
                        if (type == 12) {
                            this.mEndPos = (FilePos)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, FilePos.kDescriptor, (boolean)strict);
                            this.optionals.set(9);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for pmodel.FieldType.end_pos, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        public FieldType build() {
            return new FieldType(this);
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<FieldType, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<FieldType, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<FieldType, _Field> {
        public _Descriptor() {
            super("pmodel", "FieldType", _Builder::new, false);
        }

        @Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    public static enum _Field implements PField
    {
        DOCUMENTATION(1, PRequirement.OPTIONAL, "documentation", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        ID(2, PRequirement.REQUIRED, "id", (PDescriptorProvider)PPrimitive.I32.provider(), null),
        REQUIREMENT(3, PRequirement.OPTIONAL, "requirement", (PDescriptorProvider)FieldRequirement.provider(), (PValueProvider<?>)new PDefaultValueProvider((Object)((Object)FieldType.access$1300()))),
        TYPE(4, PRequirement.REQUIRED, "type", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        NAME(5, PRequirement.REQUIRED, "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        DEFAULT_VALUE(6, PRequirement.OPTIONAL, "default_value", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        ANNOTATIONS(7, PRequirement.OPTIONAL, "annotations", (PDescriptorProvider)PMap.sortedProvider((PDescriptorProvider)PPrimitive.STRING.provider(), (PDescriptorProvider)PPrimitive.STRING.provider()), null),
        VALUE_START_POS(9, PRequirement.REQUIRED, "value_start_pos", (PDescriptorProvider)FilePos.provider(), null),
        START_POS(10, PRequirement.OPTIONAL, "start_pos", (PDescriptorProvider)FilePos.provider(), null),
        END_POS(11, PRequirement.OPTIONAL, "end_pos", (PDescriptorProvider)FilePos.provider(), null);

        private final int mId;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int id, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mId = id;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getId() {
            return this.mId;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field findById(int id) {
            switch (id) {
                case 1: {
                    return DOCUMENTATION;
                }
                case 2: {
                    return ID;
                }
                case 3: {
                    return REQUIREMENT;
                }
                case 4: {
                    return TYPE;
                }
                case 5: {
                    return NAME;
                }
                case 6: {
                    return DEFAULT_VALUE;
                }
                case 7: {
                    return ANNOTATIONS;
                }
                case 9: {
                    return VALUE_START_POS;
                }
                case 10: {
                    return START_POS;
                }
                case 11: {
                    return END_POS;
                }
            }
            return null;
        }

        public static _Field findByName(String name) {
            switch (name) {
                case "documentation": {
                    return DOCUMENTATION;
                }
                case "id": {
                    return ID;
                }
                case "requirement": {
                    return REQUIREMENT;
                }
                case "type": {
                    return TYPE;
                }
                case "name": {
                    return NAME;
                }
                case "default_value": {
                    return DEFAULT_VALUE;
                }
                case "annotations": {
                    return ANNOTATIONS;
                }
                case "value_start_pos": {
                    return VALUE_START_POS;
                }
                case "start_pos": {
                    return START_POS;
                }
                case "end_pos": {
                    return END_POS;
                }
            }
            return null;
        }

        public static _Field fieldForId(int id) {
            _Field field = _Field.findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in pmodel.FieldType");
            }
            return field;
        }

        public static _Field fieldForName(String name) {
            _Field field = _Field.findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in pmodel.FieldType");
            }
            return field;
        }
    }
}

