/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.serializer.pretty.Tokenizer;
import net.morimekta.providence.serializer.pretty.TokenizerException;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IOUtils;
import net.morimekta.util.io.Utf8StreamReader;

public class ThriftTokenizer
extends Tokenizer {
    public static final String kNamespace = "namespace";
    public static final String kInclude = "include";
    public static final String kTypedef = "typedef";
    public static final String kEnum = "enum";
    public static final String kStruct = "struct";
    public static final String kUnion = "union";
    public static final String kException = "exception";
    public static final String kConst = "const";
    public static final String kService = "service";
    public static final String kExtends = "extends";
    public static final String kVoid = "void";
    public static final String kOneway = "oneway";
    public static final String kThrows = "throws";
    public static final String kRequired = "required";
    public static final String kOptional = "optional";
    public static final String kLineCommentStart = "//";
    public static final String kBlockCommentStart = "/*";
    public static final String kBlockCommentEnd = "*/";
    private static final Pattern RE_BLOCK_LINE = Pattern.compile("^([\\s]*[*])?[\\s]?");

    public ThriftTokenizer(InputStream in) {
        this((Reader)new Utf8StreamReader(in));
    }

    public ThriftTokenizer(Reader reader) {
        super(reader, 2048, true);
    }

    @Nonnull
    private Token token(int off, int len, int linePos) {
        return this.token(off, len, this.lineNo, linePos);
    }

    @Nonnull
    private Token token(int off, int len, int lineNo, int linePos) {
        return new Token(this.buffer, off, len, lineNo, linePos);
    }

    @Nonnull
    protected Token nextSymbol() throws IOException {
        if (this.lastChar == 47) {
            int startOffset = this.bufferOffset;
            int startLinePos = this.linePos;
            if (!this.readNextChar()) {
                throw this.eof("Expected java-style comment, got end of file", new Object[0]);
            }
            if (this.lastChar == 47 || this.lastChar == 42) {
                this.lastChar = 0;
                return this.token(startOffset, 2, startLinePos);
            }
            throw this.failure(this.lineNo, startLinePos, 2, "Expected java-style comment, got '%s' after '/'", new Object[]{Strings.escape((char)((char)this.lastChar))});
        }
        return super.nextSymbol();
    }

    public String parseDocBlock() throws IOException {
        String block = IOUtils.readString((Reader)((Object)this), (String)kBlockCommentEnd).trim();
        String[] lines = block.split("\\r?\\n");
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(RE_BLOCK_LINE.matcher(line).replaceFirst(""));
            builder.append('\n');
        }
        return builder.toString().trim();
    }

    public Token parseValue() throws IOException {
        Token token;
        Stack<Character> enclosures = new Stack<Character>();
        int startLineNo = 0;
        int startLinePos = 0;
        int offset = -1;
        while (true) {
            token = this.expect("const value");
            if (offset < 0) {
                offset = token.getOffset();
                startLineNo = token.getLineNo();
                startLinePos = token.getLinePos();
            }
            if (token.strEquals(kBlockCommentStart)) {
                this.parseDocBlock();
                continue;
            }
            if (token.strEquals(kLineCommentStart)) {
                IOUtils.readString((Reader)((Object)this), (char)'\n');
                continue;
            }
            if (token.isSymbol('{')) {
                enclosures.push(Character.valueOf('}'));
            } else if (token.isSymbol('[')) {
                enclosures.push(Character.valueOf(']'));
            } else if ((token.isSymbol('}') || token.isSymbol(']')) && ((Character)enclosures.peek()).equals(Character.valueOf(token.charAt(0)))) {
                enclosures.pop();
            }
            if (enclosures.isEmpty()) break;
        }
        return this.token(offset, token.getOffset() - offset + token.length(), startLineNo, startLinePos);
    }

    @Nonnull
    protected TokenizerException failure(String format, Object ... params) {
        return new ParseException(format, params);
    }
}

