/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.reflect.contained.CConst;
import net.morimekta.providence.reflect.contained.CService;

public class CProgram {
    private final String programFilePath;
    private final String documentation;
    private final String programName;
    private final Set<String> includedPrograms;
    private final List<String> includedFiles;
    private final Map<String, String> namespaces;
    private final Map<String, String> typedefs;
    private final List<PDeclaredDescriptor<?>> declaredTypes;
    private final List<CService> services;
    private final List<CConst> constants;

    public CProgram(@Nonnull String programFilePath, String documentation, @Nonnull String programName, Map<String, String> namespaces, Collection<String> includedPrograms, Collection<String> includedFiles, Map<String, String> typedefs, Collection<PDeclaredDescriptor<?>> declaredTypes, Collection<CService> services, Collection<CConst> constants) {
        this.programFilePath = programFilePath;
        this.documentation = documentation;
        this.programName = programName;
        this.namespaces = namespaces == null ? ImmutableMap.of() : ImmutableMap.copyOf(namespaces);
        this.includedPrograms = includedPrograms == null ? ImmutableSet.of() : ImmutableSet.copyOf(includedPrograms);
        this.includedFiles = includedFiles == null ? ImmutableList.of() : ImmutableList.copyOf(includedFiles);
        this.typedefs = typedefs == null ? ImmutableMap.of() : ImmutableMap.copyOf(typedefs);
        this.declaredTypes = declaredTypes == null ? ImmutableList.of() : ImmutableList.copyOf(declaredTypes);
        this.services = services == null ? ImmutableList.of() : ImmutableList.copyOf(services);
        this.constants = constants == null ? ImmutableList.of() : ImmutableList.copyOf(constants);
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getProgramName() {
        return this.programName;
    }

    public Set<String> getIncludedPrograms() {
        return this.includedPrograms;
    }

    public List<String> getIncludedFiles() {
        return this.includedFiles;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public Map<String, String> getTypedefs() {
        return this.typedefs;
    }

    public List<PDeclaredDescriptor<?>> getDeclaredTypes() {
        return this.declaredTypes;
    }

    public List<CService> getServices() {
        return this.services;
    }

    public List<CConst> getConstants() {
        return this.constants;
    }

    public String getNamespaceForLanguage(String language) {
        return this.namespaces.get(language);
    }

    public String getProgramFilePath() {
        return this.programFilePath;
    }
}

