/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.util.RecursiveTypeRegistry;

public class ProgramTypeRegistry
extends RecursiveTypeRegistry {
    private CProgram program;
    private ProgramType programType;

    public ProgramTypeRegistry(@Nonnull String localProgramContext) {
        super(localProgramContext);
    }

    @Nonnull
    public CProgram getProgramForName(String programName) {
        RecursiveTypeRegistry tmp = this.getRegistryForProgramName(programName);
        if (tmp != null && tmp instanceof ProgramTypeRegistry) {
            return ((ProgramTypeRegistry)tmp).getProgram();
        }
        throw new IllegalArgumentException("No program for name " + programName);
    }

    public CProgram getProgram() {
        return this.program;
    }

    public ProgramType getProgramType() {
        return this.programType;
    }

    public void setProgram(CProgram program) {
        this.program = program;
        if (this.isEmpty()) {
            program.getTypedefs().forEach((id, type) -> this.registerTypedef((String)id, this.getLocalProgramContext(), (String)type));
            for (PDeclaredDescriptor<?> pDeclaredDescriptor : program.getDeclaredTypes()) {
                this.registerRecursively(pDeclaredDescriptor);
            }
            for (PService pService : program.getServices()) {
                this.registerRecursively(pService);
            }
        }
    }

    public void setProgramType(ProgramType type) {
        this.programType = type;
    }
}

