/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.util.ProgramTypeRegistry;
import net.morimekta.providence.reflect.util.ReflectionUtils;
import net.morimekta.providence.util.TypeRegistry;

public class ProgramRegistry
implements TypeRegistry {
    private final Map<String, ProgramTypeRegistry> registryMap = new TreeMap<String, ProgramTypeRegistry>();

    @Nonnull
    public ProgramTypeRegistry registryForPath(String path) {
        return this.registryMap.computeIfAbsent(path, p -> new ProgramTypeRegistry(ReflectionUtils.programNameFromPath(path)));
    }

    @Nonnull
    public Collection<ProgramTypeRegistry> getLoadedRegistries() {
        return ImmutableList.copyOf(this.registryMap.values());
    }

    public boolean containsProgramPath(String path) {
        return this.registryMap.containsKey(path) && this.registryMap.get(path).getProgram() != null;
    }

    public void putProgram(String path, CProgram program) {
        this.registryForPath(path).setProgram(program);
    }

    public void putProgramType(String path, ProgramType program) {
        this.registryForPath(path).setProgramType(program);
    }

    @Nonnull
    public <T extends PDeclaredDescriptor<T>> T getDeclaredType(@Nonnull String typeName, @Nonnull String programContext) {
        return (T)this.handle(typeName, programContext, false, p -> p.getDeclaredType(typeName, programContext));
    }

    @Nonnull
    public PService getService(String serviceName, String programContext) {
        return this.handle(serviceName, programContext, true, r -> r.getService(serviceName, programContext));
    }

    @Nonnull
    public PDescriptorProvider getProvider(String typeName, String programContext, Map<String, String> annotations) {
        return this.handle(typeName, programContext, false, r -> r.getProvider(typeName, programContext, annotations));
    }

    @Nonnull
    public PServiceProvider getServiceProvider(String serviceName, String programContext) {
        return this.handle(serviceName, programContext, true, r -> r.getServiceProvider(serviceName, programContext));
    }

    private <T> T handle(String typeName, String programContext, boolean isService, Function<ProgramTypeRegistry, T> f) {
        Throwable e = null;
        String context = this.getProgramContext(typeName, programContext);
        for (ProgramTypeRegistry registry : this.registryMap.values()) {
            if (!registry.getLocalProgramContext().equals(context)) continue;
            try {
                return f.apply(registry);
            }
            catch (Exception ignored) {
                e = ignored;
            }
        }
        if (e != null) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (isService) {
            throw new IllegalArgumentException("No such program \"" + context + "\" known for service \"" + typeName + "\"");
        }
        throw new IllegalArgumentException("No such program \"" + context + "\" known for type \"" + typeName + "\"");
    }

    private String getProgramContext(String typeName, String programContext) {
        String[] tmp = typeName.split("[<]", 2);
        if (tmp.length > 1) {
            return programContext;
        }
        if (typeName.contains(".")) {
            return typeName.substring(0, typeName.indexOf("."));
        }
        return programContext;
    }
}

