/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.util.BaseTypeRegistry;

public class RecursiveTypeRegistry
extends BaseTypeRegistry {
    private final String localProgramContext;
    private final Map<String, PDeclaredDescriptor<?>> declaredTypes;
    private final Map<String, PService> services;
    private final Map<String, RecursiveTypeRegistry> includes;
    private final Map<String, Object> constants;

    public RecursiveTypeRegistry(@Nonnull String localProgramContext) {
        this.localProgramContext = localProgramContext;
        this.declaredTypes = new LinkedHashMap();
        this.services = new HashMap<String, PService>();
        this.includes = new HashMap<String, RecursiveTypeRegistry>();
        this.constants = new HashMap<String, Object>();
    }

    public String getLocalProgramContext() {
        return this.localProgramContext;
    }

    public RecursiveTypeRegistry getRegistryForProgramName(String programName) {
        if (this.localProgramContext.equals(programName)) {
            return this;
        }
        for (RecursiveTypeRegistry registry : this.includes.values()) {
            if (!registry.getLocalProgramContext().equals(programName)) continue;
            return registry;
        }
        for (RecursiveTypeRegistry registry : this.includes.values()) {
            RecursiveTypeRegistry tmp = registry.getRegistryForProgramName(programName);
            if (tmp == null) continue;
            return tmp;
        }
        return null;
    }

    public void registerInclude(String programName, RecursiveTypeRegistry registry) {
        if (registry == this) {
            throw new IllegalArgumentException("Registering include back to itself: " + programName);
        }
        if (this.includes.containsKey(programName)) {
            return;
        }
        this.includes.put(programName, registry);
    }

    @Nonnull
    public <T extends PDeclaredDescriptor<T>> T getDeclaredType(@Nonnull String typeName, @Nonnull String programContext) {
        String finalName = this.finalTypename(typeName, programContext);
        String program = finalName.replaceAll("\\..*", "");
        String name = finalName.replaceAll(".*\\.", "");
        if (this.localProgramContext.equals(program)) {
            if (this.declaredTypes.containsKey(name)) {
                return (T)this.declaredTypes.get(name);
            }
            throw new IllegalArgumentException("No such type \"" + name + "\" in program \"" + program + "\"");
        }
        if (this.includes.containsKey(program)) {
            return this.includes.get(program).getDeclaredType(name, program);
        }
        throw new IllegalArgumentException("No such program \"" + program + "\" known for type \"" + typeName + "\"");
    }

    @Nullable
    public <T> T getConstantValue(@Nonnull String constReference, @Nonnull String programContext) {
        if (!constReference.contains(".")) {
            constReference = programContext + "." + constReference;
        }
        String program = constReference.replaceAll("\\..*", "");
        String name = constReference.replaceAll(".*\\.", "");
        if (this.localProgramContext.equals(program)) {
            return (T)this.constants.get(name);
        }
        if (this.includes.containsKey(program)) {
            return this.includes.get(program).getConstantValue(name, program);
        }
        return null;
    }

    @Nonnull
    public PService getService(String serviceName, String programContext) {
        String finalName = RecursiveTypeRegistry.qualifiedNameFromIdAndContext((String)serviceName, (String)programContext);
        String program = finalName.replaceAll("\\..*", "");
        String name = finalName.replaceAll(".*\\.", "");
        if (this.localProgramContext.equals(program)) {
            if (this.services.containsKey(name)) {
                return this.services.get(name);
            }
            throw new IllegalArgumentException("No such service \"" + name + "\" in program \"" + program + "\"");
        }
        if (this.includes.containsKey(program)) {
            return this.includes.get(program).getService(name, program);
        }
        throw new IllegalArgumentException("No such program \"" + program + "\" known for service \"" + serviceName + "\"");
    }

    public void registerConstant(@Nonnull String identifier, @Nonnull String program, @Nonnull Object value) {
        String origIdentifier = identifier;
        if (identifier.contains(".")) {
            String[] parts = identifier.split("[.]");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid const identifier");
            }
            identifier = parts[1];
            program = parts[0];
        }
        if (this.localProgramContext.equals(program)) {
            this.constants.put(identifier, value);
        } else if (this.includes.containsKey(program)) {
            this.includes.get(program).registerConstant(identifier, program, value);
        } else {
            throw new IllegalArgumentException("No such include \"" + program + "\" for const " + origIdentifier + " in " + this.localProgramContext);
        }
    }

    public boolean register(@Nonnull PService service) {
        String program = service.getProgramName();
        if (!this.localProgramContext.equals(program)) {
            if (this.includes.containsKey(program)) {
                this.includes.get(program).registerRecursively(service);
                return true;
            }
            throw new IllegalArgumentException("No such include \"" + program + "\" for type " + service.getQualifiedName() + " in " + this.localProgramContext);
        }
        String serviceName = service.getName();
        if (this.services.containsKey(serviceName)) {
            return false;
        }
        this.services.put(serviceName, service);
        return true;
    }

    public <T> boolean register(PDeclaredDescriptor<T> declaredType) {
        String program = declaredType.getProgramName();
        if (!this.localProgramContext.equals(program)) {
            if (this.includes.containsKey(program)) {
                this.includes.get(program).registerRecursively(declaredType);
            }
            throw new IllegalArgumentException("No include for type: " + declaredType.getQualifiedName());
        }
        String typeName = declaredType.getName();
        if (this.declaredTypes.containsKey(typeName)) {
            return false;
        }
        this.declaredTypes.put(typeName, declaredType);
        return true;
    }

    protected boolean isEmpty() {
        return this.declaredTypes.isEmpty() && this.services.isEmpty();
    }
}

