/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.internal.ThriftTokenizer;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.util.TypeRegistry;
import net.morimekta.util.Binary;
import net.morimekta.util.Stringable;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableMap;
import net.morimekta.util.collect.UnmodifiableSet;
import net.morimekta.util.io.Utf8StreamReader;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonToken;
import net.morimekta.util.json.JsonTokenizer;

public class ConstParser {
    private static final String NULL = "null";
    private final TypeRegistry registry;
    private final String programContext;
    private final int startLineNo;
    private final int startLinePos;

    public ConstParser(TypeRegistry registry, String programContext, int startLineNo, int startLinePos) {
        this.registry = registry;
        this.programContext = programContext;
        this.startLineNo = startLineNo;
        this.startLinePos = startLinePos;
    }

    public Object parse(InputStream inputStream, PDescriptor type) throws ParseException {
        return this.parse((Reader)new Utf8StreamReader(inputStream), type);
    }

    public Object parse(Reader reader, PDescriptor type) throws ParseException {
        try {
            ThriftTokenizer tokenizer = new ThriftTokenizer(reader);
            try {
                return this.parseTypedValue(tokenizer.expect("const value"), tokenizer, type, true);
            }
            catch (ParseException e) {
                if (this.startLineNo > 0) {
                    if (e.getLineNo() == 1) {
                        e.setLinePos(e.getLinePos() + this.startLinePos - 1);
                        if (this.startLinePos > 3) {
                            e.setLine(Strings.times((String)".", (int)(this.startLinePos - 4)) + " = " + tokenizer.getLine());
                        } else {
                            e.setLine(Strings.times((String)" ", (int)(this.startLinePos - 1)) + tokenizer.getLine());
                        }
                    }
                    e.setLineNo(e.getLineNo() + this.startLineNo - 1);
                }
                throw e;
            }
        }
        catch (ParseException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ParseException(e, "Unable to read const data from input: " + e.getMessage(), new Object[0]);
        }
    }

    private <Message extends PMessage<Message, Field>, Field extends PField> Message parseMessage(ThriftTokenizer tokenizer, PMessageDescriptor<Message, Field> type) throws IOException {
        PMessageBuilder builder = type.builder();
        if (tokenizer.peek("checking for empty").isSymbol('}')) {
            tokenizer.next();
            return (Message)((PMessage)builder.build());
        }
        while (true) {
            Token token;
            if ((token = tokenizer.expect("message field name", t -> t.isStringLiteral() || t.strEquals("/*") || t.strEquals("//"))).strEquals("//")) {
                int c;
                while ((c = tokenizer.read()) >= 0 && c != 10) {
                }
                continue;
            }
            if (token.strEquals("/*")) {
                int c;
                while ((c = tokenizer.read()) >= 0 && (c != 42 || (c = tokenizer.read()) != 47)) {
                }
                continue;
            }
            PField field = type.findFieldByName(token.decodeLiteral(true));
            if (field == null) {
                throw tokenizer.failure(token, "No such field in " + type.getQualifiedName() + ": " + token.decodeLiteral(true), new Object[0]);
            }
            tokenizer.expectSymbol("message key-value sep", new char[]{':'});
            builder.set(field.getId(), this.parseTypedValue(tokenizer.expect("parsing field value"), tokenizer, field.getDescriptor(), false));
            token = tokenizer.peek("optional line sep or message end");
            if (token.isSymbol(',') || token.isSymbol(';')) {
                tokenizer.next();
                token = tokenizer.peek("optional message end");
            }
            if (token.isSymbol('}')) break;
        }
        tokenizer.next();
        return (Message)((PMessage)builder.build());
    }

    private Object parseTypedValue(Token token, ThriftTokenizer tokenizer, PDescriptor valueType, boolean allowNull) throws IOException {
        Object val;
        if ((token.isIdentifier() || token.isQualifiedIdentifier()) && (val = this.registry.getConstantValue(token.toString(), this.programContext)) != null) {
            switch (valueType.getType()) {
                case BOOL: {
                    if (val instanceof Number) {
                        return ((Number)val).longValue() != 0L;
                    }
                    if (!(val instanceof Boolean)) break;
                    return val;
                }
                case BYTE: {
                    if (!(val instanceof Number)) break;
                    return ((Number)val).byteValue();
                }
                case I16: {
                    if (!(val instanceof Number)) break;
                    return ((Number)val).shortValue();
                }
                case I32: {
                    if (val instanceof Number) {
                        return ((Number)val).intValue();
                    }
                    if (!(val instanceof PEnumValue)) break;
                    return ((PEnumValue)val).asInteger();
                }
                case I64: {
                    if (val instanceof Number) {
                        return ((Number)val).byteValue();
                    }
                    if (!(val instanceof PEnumValue)) break;
                    return (long)((PEnumValue)val).asInteger();
                }
                case DOUBLE: {
                    if (!(val instanceof Number)) break;
                    return ((Number)val).doubleValue();
                }
                case STRING: {
                    if (val instanceof Stringable) {
                        return ((Stringable)val).asString();
                    }
                    return val.toString();
                }
                case BINARY: {
                    if (!(val instanceof Binary)) break;
                    return val;
                }
                case ENUM: {
                    PEnumDescriptor ed;
                    PEnumValue ev;
                    if (val instanceof PEnumValue) {
                        return val;
                    }
                    if (val instanceof Number) {
                        int i;
                        PEnumDescriptor ed2;
                        PEnumValue ev2;
                        if (val instanceof Double || (ev2 = (ed2 = (PEnumDescriptor)valueType).findById(i = ((Number)val).intValue())) == null) break;
                        return ev2;
                    }
                    if (!(val instanceof CharSequence) || (ev = (ed = (PEnumDescriptor)valueType).findByName(val.toString())) == null) break;
                    return ev;
                }
                case MESSAGE: 
                case LIST: 
                case MAP: 
                case SET: {
                    return val;
                }
            }
            throw new IllegalArgumentException("Bad constant reference type: " + valueType + " cannot be assigned to " + val.getClass().getSimpleName() + " " + val.toString());
        }
        switch (valueType.getType()) {
            case BOOL: {
                if (token.isIdentifier()) {
                    return Boolean.parseBoolean(token.toString());
                }
                if (token.isInteger()) {
                    return token.parseInteger() != 0L;
                }
                throw tokenizer.failure(token, "Not boolean value: " + token.toString(), new Object[0]);
            }
            case BYTE: {
                if (token.isInteger()) {
                    return (byte)token.parseInteger();
                }
                return (byte)this.findEnumValue(token.toString(), token, tokenizer, "byte");
            }
            case I16: {
                if (token.isInteger()) {
                    return (short)token.parseInteger();
                }
                return (short)this.findEnumValue(token.toString(), token, tokenizer, "i16");
            }
            case I32: {
                if (token.isInteger()) {
                    return (int)token.parseInteger();
                }
                return this.findEnumValue(token.toString(), token, tokenizer, "i32");
            }
            case I64: {
                if (token.isInteger()) {
                    return token.parseInteger();
                }
                return (long)this.findEnumValue(token.toString(), token, tokenizer, "i64");
            }
            case DOUBLE: {
                if (token.isInteger() || token.isReal()) {
                    return token.parseDouble();
                }
                throw tokenizer.failure(token, token.toString() + " is not a valid double value.", new Object[0]);
            }
            case STRING: {
                if (token.isStringLiteral()) {
                    return token.decodeLiteral(true);
                }
                if (allowNull && token.toString().equals(NULL)) {
                    return null;
                }
                throw tokenizer.failure(token, "Not a valid string value.", new Object[0]);
            }
            case BINARY: {
                if (token.isStringLiteral()) {
                    return this.parseBinary(token.substring(1, -1).toString());
                }
                if (allowNull && token.toString().equals(NULL)) {
                    return null;
                }
                throw tokenizer.failure(token, "Not a valid binary value.", new Object[0]);
            }
            case ENUM: {
                PEnumBuilder eb = ((PEnumDescriptor)valueType).builder();
                String name = token.toString();
                if (name.startsWith(valueType.getName())) {
                    name = name.substring(valueType.getName().length() + 1);
                } else if (name.startsWith(valueType.getQualifiedName())) {
                    name = name.substring(valueType.getQualifiedName().length() + 1);
                }
                Object ev = Strings.isInteger((CharSequence)name) ? eb.setById(Integer.parseInt(name)).build() : eb.setByName(name).build();
                if (ev == null) {
                    if (allowNull && token.toString().equals(NULL)) {
                        return null;
                    }
                    throw tokenizer.failure(token, "No such " + valueType.getQualifiedName() + " enum value \"" + name, new Object[0]);
                }
                return ev;
            }
            case MESSAGE: {
                if (token.isSymbol('{')) {
                    return this.parseMessage(tokenizer, (PMessageDescriptor)valueType);
                }
                if (allowNull && token.toString().equals(NULL)) {
                    return null;
                }
                throw tokenizer.failure(token, "Not a valid message start.", new Object[0]);
            }
            case LIST: {
                PDescriptor itemType = ((PList)valueType).itemDescriptor();
                UnmodifiableList.Builder list = UnmodifiableList.builder();
                if (!token.isSymbol('[')) {
                    throw tokenizer.failure(token, "Expected list start, found " + token.toString(), new Object[0]);
                }
                if (tokenizer.peek("checking for empty list").isSymbol(']')) {
                    tokenizer.next();
                    return list.build();
                }
                while (true) {
                    if ((token = tokenizer.expect("list item value")).strEquals("//")) {
                        int c;
                        while ((c = tokenizer.read()) >= 0 && c != 10) {
                        }
                        continue;
                    }
                    if (token.strEquals("/*")) {
                        int c;
                        while ((c = tokenizer.read()) >= 0 && (c != 42 || (c = tokenizer.read()) != 47)) {
                        }
                        continue;
                    }
                    list.add(this.parseTypedValue(token, tokenizer, itemType, false));
                    Token sep = tokenizer.peek("optional item sep");
                    if (sep.isSymbol(',') || sep.isSymbol(';')) {
                        tokenizer.next();
                        sep = tokenizer.peek("check for set end");
                    }
                    if (sep.isSymbol(']')) break;
                }
                tokenizer.next();
                return list.build();
            }
            case SET: {
                PDescriptor itemType = ((PSet)valueType).itemDescriptor();
                UnmodifiableSet.Builder set = UnmodifiableSet.builder();
                if (!token.isSymbol('[')) {
                    throw tokenizer.failure(token, "Expected list start, found " + token.toString(), new Object[0]);
                }
                if (tokenizer.peek("checking for empty list").isSymbol(']')) {
                    tokenizer.next();
                    return set.build();
                }
                while (true) {
                    if ((token = tokenizer.expect("set item value")).strEquals("//")) {
                        int c;
                        while ((c = tokenizer.read()) >= 0 && c != 10) {
                        }
                        continue;
                    }
                    if (token.strEquals("/*")) {
                        int c;
                        while ((c = tokenizer.read()) >= 0 && (c != 42 || (c = tokenizer.read()) != 47)) {
                        }
                        continue;
                    }
                    set.add(this.parseTypedValue(token, tokenizer, itemType, false));
                    Token sep = tokenizer.peek("optional item sep");
                    if (sep.isSymbol(',') || sep.isSymbol(';')) {
                        tokenizer.next();
                        sep = tokenizer.peek("check for set end");
                    }
                    if (sep.isSymbol(']')) break;
                }
                tokenizer.next();
                return set.build();
            }
            case MAP: {
                PDescriptor itemType = ((PMap)valueType).itemDescriptor();
                PDescriptor keyType = ((PMap)valueType).keyDescriptor();
                UnmodifiableMap.Builder map = UnmodifiableMap.builder();
                if (!token.isSymbol('{')) {
                    throw tokenizer.failure(token, "Expected map start, found " + token.toString(), new Object[0]);
                }
                if (tokenizer.peek("checking for empty map").isSymbol('}')) {
                    tokenizer.next();
                    return map.build();
                }
                while (true) {
                    Object key;
                    if ((token = tokenizer.expect("map key")).strEquals("//")) {
                        int c;
                        while ((c = tokenizer.read()) >= 0 && c != 10) {
                        }
                        continue;
                    }
                    if (token.strEquals("/*")) {
                        int c;
                        while ((c = tokenizer.read()) >= 0 && (c != 42 || (c = tokenizer.read()) != 47)) {
                        }
                        continue;
                    }
                    if (token.isStringLiteral()) {
                        key = this.parsePrimitiveKey(token.decodeLiteral(true), token, tokenizer, keyType);
                    } else if (token.isIdentifier() || token.isQualifiedIdentifier()) {
                        key = this.registry.getConstantValue(token.toString(), this.programContext);
                        if (key == null) {
                            if (keyType.getType().equals((Object)PType.STRING) || keyType.getType().equals((Object)PType.BINARY)) {
                                throw tokenizer.failure(token, "Expected string literal for string key", new Object[0]);
                            }
                            key = this.parsePrimitiveKey(token.toString(), token, tokenizer, keyType);
                        }
                    } else {
                        if (keyType.getType().equals((Object)PType.STRING) || keyType.getType().equals((Object)PType.BINARY)) {
                            throw tokenizer.failure(token, "Expected string literal for string key", new Object[0]);
                        }
                        key = this.parsePrimitiveKey(token.toString(), token, tokenizer, keyType);
                    }
                    tokenizer.expectSymbol("map KV separator", new char[]{':'});
                    map.put(key, this.parseTypedValue(tokenizer.expect("map value"), tokenizer, itemType, false));
                    Token sep = tokenizer.peek("optional item sep");
                    if (sep.isSymbol(',') || sep.isSymbol(';')) {
                        tokenizer.next();
                        sep = tokenizer.peek("check for map end");
                    }
                    if (sep.isSymbol('}')) break;
                }
                tokenizer.next();
                return map.build();
            }
        }
        throw new IllegalArgumentException("Unhandled item type " + valueType.getQualifiedName());
    }

    private Object parsePrimitiveKey(String key, Token token, ThriftTokenizer tokenizer, PDescriptor keyType) throws IOException {
        switch (keyType.getType()) {
            case ENUM: {
                PEnumBuilder eb = ((PEnumDescriptor)keyType).builder();
                if (Strings.isInteger((CharSequence)key)) {
                    return eb.setById(Integer.parseInt(key)).build();
                }
                if (key.startsWith(keyType.getProgramName() + "." + keyType.getName() + ".")) {
                    key = key.substring(keyType.getProgramName().length() + keyType.getName().length() + 2);
                } else if (key.startsWith(keyType.getName() + ".")) {
                    key = key.substring(keyType.getName().length() + 1);
                }
                return eb.setByName(key).build();
            }
            case BOOL: {
                return Boolean.parseBoolean(key);
            }
            case BYTE: {
                if (Strings.isInteger((CharSequence)key)) {
                    return Byte.parseByte(key);
                }
                return (byte)this.findEnumValue(key, token, tokenizer, "byte");
            }
            case I16: {
                if (Strings.isInteger((CharSequence)key)) {
                    return Short.parseShort(key);
                }
                return (short)this.findEnumValue(key, token, tokenizer, "i16");
            }
            case I32: {
                if (Strings.isInteger((CharSequence)key)) {
                    return Integer.parseInt(key);
                }
                return this.findEnumValue(key, token, tokenizer, "i32");
            }
            case I64: {
                if (Strings.isInteger((CharSequence)key)) {
                    return Long.parseLong(key);
                }
                return (long)this.findEnumValue(key, token, tokenizer, "i64");
            }
            case DOUBLE: {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(key.getBytes(StandardCharsets.US_ASCII));
                    JsonTokenizer tokener = new JsonTokenizer((InputStream)bais);
                    JsonToken jt = tokener.expect("parsing double value");
                    return jt.doubleValue();
                }
                catch (IOException | NumberFormatException | JsonException e) {
                    throw new ParseException(e, "Unable to parse double value", new Object[0]).setLength(token.length()).setLineNo(token.getLineNo()).setLinePos(token.getLinePos()).setLine(tokenizer.getLine());
                }
            }
            case STRING: {
                return key;
            }
            case BINARY: {
                return this.parseBinary(key);
            }
        }
        throw new ParseException("Illegal key type: " + keyType.getType(), new Object[0]);
    }

    private int findEnumValue(String identifier, Token token, ThriftTokenizer tokenizer, String expectedType) throws IOException {
        String valueName;
        String typeName;
        String[] parts = identifier.split("[.]");
        if (parts.length == 3) {
            typeName = parts[0] + "." + parts[1];
            valueName = parts[2];
        } else if (parts.length == 2) {
            typeName = parts[0];
            valueName = parts[1];
        } else {
            throw tokenizer.failure(token, identifier + " is not a valid " + expectedType + " value.", new Object[0]);
        }
        try {
            PEnumDescriptor desc;
            PEnumValue value;
            PDeclaredDescriptor descriptor = this.registry.getDeclaredType(typeName, this.programContext);
            if (descriptor instanceof PEnumDescriptor && (value = (desc = (PEnumDescriptor)descriptor).findByName(valueName)) != null) {
                return value.asInteger();
            }
            throw tokenizer.failure(token, typeName + " is not an enum.", new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw tokenizer.failure(token, "No type named " + typeName + ".", new Object[0]);
        }
    }

    private Binary parseBinary(String value) {
        return Binary.fromBase64((String)value);
    }
}

