/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.model.ConstType;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.model.EnumType;
import net.morimekta.providence.model.EnumValue;
import net.morimekta.providence.model.FieldRequirement;
import net.morimekta.providence.model.FieldType;
import net.morimekta.providence.model.FilePos;
import net.morimekta.providence.model.FunctionType;
import net.morimekta.providence.model.MessageType;
import net.morimekta.providence.model.MessageVariant;
import net.morimekta.providence.model.Pmodel_Constants;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.model.ServiceType;
import net.morimekta.providence.model.TypedefType;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.ProgramParser;
import net.morimekta.providence.reflect.parser.internal.ThriftTokenizer;
import net.morimekta.providence.reflect.util.ReflectionUtils;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.serializer.pretty.TokenizerException;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IOUtils;

public class ThriftProgramParser
implements ProgramParser {
    private static final Pattern VALID_PROGRAM_NAME = Pattern.compile("[-._a-zA-Z][-._a-zA-Z0-9]*");
    public static final Pattern VALID_NAMESPACE = Pattern.compile("([_a-zA-Z][_a-zA-Z0-9]*[.])*[_a-zA-Z][_a-zA-Z0-9]*");
    public static final Pattern VALID_SDI_NAMESPACE = Pattern.compile("([_a-zA-Z][-_a-zA-Z0-9]*[.])*[_a-zA-Z][-_a-zA-Z0-9]*");
    private final boolean requireFieldId;
    private final boolean requireEnumValue;
    private final boolean allowLanguageReservedNames;

    public ThriftProgramParser() {
        this(false, false);
    }

    public ThriftProgramParser(boolean requireFieldId, boolean requireEnumValue) {
        this(requireFieldId, requireEnumValue, true);
    }

    public ThriftProgramParser(boolean requireFieldId, boolean requireEnumValue, boolean allowLanguageReservedNames) {
        this.requireFieldId = requireFieldId;
        this.requireEnumValue = requireEnumValue;
        this.allowLanguageReservedNames = allowLanguageReservedNames;
    }

    @Override
    public ProgramType parse(InputStream in, File file, Collection<File> includeDirs) throws IOException {
        try {
            return this.parseInternal(in, file, includeDirs);
        }
        catch (TokenizerException e) {
            if (e.getFile() == null) {
                e.setFile(file.getName());
            }
            throw e;
        }
    }

    private ProgramType parseInternal(InputStream in, File file, Collection<File> includeDirs) throws IOException {
        Token token;
        ProgramType._Builder program = ProgramType.builder();
        String programName = ReflectionUtils.programNameFromPath(file.getName());
        if (!VALID_PROGRAM_NAME.matcher(programName).matches()) {
            throw new ParseException("Program name \"%s\" derived from filename \"%s\" is not valid.", Strings.escape((CharSequence)programName), Strings.escape((CharSequence)file.getName()));
        }
        program.setProgramName(programName);
        ArrayList<String> include_files = new ArrayList<String>();
        HashSet<String> includedPrograms = new HashSet<String>();
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        ThriftTokenizer tokenizer = new ThriftTokenizer(in);
        boolean has_header = false;
        boolean hasDeclaration = false;
        String doc_string = null;
        block20: while ((token = tokenizer.next()) != null) {
            if (token.strEquals("//")) {
                this.parseDocLine(tokenizer);
                continue;
            }
            if (token.strEquals("/*")) {
                doc_string = tokenizer.parseDocBlock();
                continue;
            }
            String keyword = token.toString();
            if (!Pmodel_Constants.kThriftKeywords.contains(keyword)) {
                throw tokenizer.failure(token, "Unexpected token '%s'", new Object[]{token.toString()});
            }
            FilePos startPos = new FilePos(token.getLineNo(), token.getLinePos());
            switch (keyword) {
                case "namespace": {
                    if (hasDeclaration) {
                        throw tokenizer.failure(token, "Unexpected token 'namespace', expected type declaration", new Object[0]);
                    }
                    if (doc_string != null && !has_header) {
                        program.setDocumentation(doc_string);
                    }
                    doc_string = null;
                    has_header = true;
                    this.parseNamespace(tokenizer, namespaces);
                    continue block20;
                }
                case "include": {
                    if (hasDeclaration) {
                        throw tokenizer.failure(token, "Unexpected token 'include', expected type declaration", new Object[0]);
                    }
                    if (doc_string != null && !has_header) {
                        program.setDocumentation(doc_string);
                    }
                    doc_string = null;
                    has_header = true;
                    this.parseIncludes(tokenizer, include_files, file, includedPrograms, includeDirs);
                    continue block20;
                }
                case "typedef": {
                    has_header = true;
                    hasDeclaration = true;
                    this.parseTypedef(tokenizer, doc_string, declarations, includedPrograms, startPos);
                    doc_string = null;
                    continue block20;
                }
                case "enum": {
                    has_header = true;
                    hasDeclaration = true;
                    EnumType et = this.parseEnum(tokenizer, doc_string, startPos);
                    declarations.add(Declaration.withDeclEnum(et));
                    doc_string = null;
                    continue block20;
                }
                case "struct": 
                case "union": 
                case "exception": {
                    has_header = true;
                    hasDeclaration = true;
                    MessageType st = this.parseMessage(tokenizer, token.toString(), doc_string, includedPrograms, startPos);
                    declarations.add(Declaration.withDeclMessage(st));
                    doc_string = null;
                    continue block20;
                }
                case "service": {
                    has_header = true;
                    hasDeclaration = true;
                    ServiceType srv = this.parseService(tokenizer, doc_string, includedPrograms, startPos);
                    declarations.add(Declaration.withDeclService(srv));
                    doc_string = null;
                    continue block20;
                }
                case "const": {
                    has_header = true;
                    hasDeclaration = true;
                    ConstType cnst = this.parseConst(tokenizer, doc_string, includedPrograms, startPos);
                    declarations.add(Declaration.withDeclConst(cnst));
                    doc_string = null;
                    continue block20;
                }
            }
            throw tokenizer.failure(token, "Unexpected token '%s'", new Object[]{Strings.escape((CharSequence)token.toString())});
        }
        if (namespaces.size() > 0) {
            program.setNamespaces(namespaces);
        }
        if (include_files.size() > 0) {
            program.setIncludes(include_files);
        }
        if (declarations.size() > 0) {
            program.setDecl(declarations);
        }
        return program.build();
    }

    private boolean disallowedNameIdentifier(String name) {
        if (Pmodel_Constants.kThriftKeywords.contains(name)) {
            return true;
        }
        return !this.allowLanguageReservedNames && Pmodel_Constants.kReservedWords.contains(name);
    }

    private ConstType parseConst(ThriftTokenizer tokenizer, String comment, Set<String> includedPrograms, FilePos startPos) throws IOException {
        Token sep;
        Token token = tokenizer.expect("const typename", t -> t.isIdentifier() || t.isQualifiedIdentifier());
        String type = this.parseType(tokenizer, token, includedPrograms);
        Token id = tokenizer.expectIdentifier("const identifier");
        tokenizer.expectSymbol("const value separator", new char[]{'='});
        Token value = tokenizer.parseValue();
        FilePos endPos = this.endOf(value);
        if (tokenizer.hasNext() && ((sep = tokenizer.peek("")).isSymbol(',') || sep.isSymbol(';'))) {
            tokenizer.next();
        }
        return ConstType.builder().setDocumentation(comment).setName(id.toString()).setType(type).setValue(value.toString()).setStartPos(startPos).setEndPos(endPos).setValueStartPos(new FilePos(value.getLineNo(), value.getLinePos())).build();
    }

    private void parseDocLine(ThriftTokenizer tokenizer) throws IOException {
        IOUtils.readString((Reader)((Object)tokenizer), (String)"\n");
    }

    private FilePos endOf(@Nonnull Token token) {
        int lineNo = token.getLineNo();
        int linePos = token.getLinePos();
        for (int i = 0; i < token.length(); ++i) {
            if (token.charAt(i) == '\n') {
                ++lineNo;
            }
            if (token.charAt(i) == '\n') {
                linePos = 1;
                continue;
            }
            ++linePos;
        }
        return new FilePos(lineNo, linePos);
    }

    private ServiceType parseService(ThriftTokenizer tokenizer, String doc_string, Set<String> includedPrograms, FilePos startPos) throws IOException {
        Token token;
        Token token2;
        Token identifier;
        ServiceType._Builder service = ServiceType.builder();
        if (doc_string != null) {
            service.setDocumentation(doc_string);
            doc_string = null;
        }
        if (this.disallowedNameIdentifier((identifier = tokenizer.expectIdentifier("service name")).toString())) {
            throw tokenizer.failure(identifier, "Service with reserved name: " + identifier.toString(), new Object[0]);
        }
        service.setName(identifier.toString());
        service.setStartPos(startPos);
        if (tokenizer.peek("service start or extends").strEquals("extends")) {
            tokenizer.next();
            service.setExtend(tokenizer.expect("service extending identifier", t -> t.isIdentifier() || t.isQualifiedIdentifier()).toString());
        }
        tokenizer.expectSymbol("reading service start", new char[]{'{'});
        TreeSet<String> methodNames = new TreeSet<String>();
        while (!(token2 = tokenizer.expect("service method initializer")).isSymbol('}')) {
            String name;
            if (token2.strEquals("//")) {
                this.parseDocLine(tokenizer);
                continue;
            }
            if (token2.strEquals("/*")) {
                doc_string = tokenizer.parseDocBlock();
                continue;
            }
            FunctionType._Builder method = FunctionType.builder();
            if (doc_string != null) {
                method.setDocumentation(doc_string);
                doc_string = null;
            }
            method.setStartPos(new FilePos(token2.getLineNo(), token2.getLinePos()));
            if (token2.strEquals("oneway")) {
                method.setOneWay(true);
                token2 = tokenizer.expect("service method type");
            }
            if (!token2.strEquals("void")) {
                if (method.isSetOneWay()) {
                    throw tokenizer.failure(token2, "Oneway methods must have void return type, found '%s'", new Object[]{Strings.escape((CharSequence)token2.toString())});
                }
                method.setReturnType(this.parseType(tokenizer, token2, includedPrograms));
            }
            if (this.disallowedNameIdentifier(name = (token2 = tokenizer.expectIdentifier("method name")).toString())) {
                throw tokenizer.failure(token2, "Method with reserved name: " + name, new Object[0]);
            }
            String normalized = Strings.camelCase((String)"", (String)name);
            if (methodNames.contains(normalized)) {
                throw tokenizer.failure(token2, "Service method " + name + " has normalized name conflict", new Object[0]);
            }
            methodNames.add(normalized);
            method.setName(name);
            tokenizer.expectSymbol("method params begin", new char[]{'('});
            int nextAutoParamKey = -1;
            while (!(token2 = tokenizer.expect("method params")).isSymbol(')')) {
                if (token2.strEquals("//")) {
                    this.parseDocLine(tokenizer);
                    continue;
                }
                if (token2.strEquals("/*")) {
                    doc_string = tokenizer.parseDocBlock();
                    continue;
                }
                FieldType._Builder field = FieldType.builder();
                if (doc_string != null) {
                    field.setDocumentation(doc_string);
                    doc_string = null;
                }
                field.setStartPos(new FilePos(token2.getLineNo(), token2.getLinePos()));
                if (token2.isInteger()) {
                    field.setId((int)token2.parseInteger());
                    tokenizer.expectSymbol("params kv sep", new char[]{':'});
                    token2 = tokenizer.expect("param type");
                } else {
                    if (this.requireFieldId) {
                        throw tokenizer.failure(token2, "Missing param ID in strict declaration", new Object[0]);
                    }
                    field.setId(nextAutoParamKey--);
                }
                if (PRequirement.OPTIONAL.label.equals(token2.toString())) {
                    field.setRequirement(FieldRequirement.OPTIONAL);
                    token2 = tokenizer.expect("param type");
                } else if (PRequirement.REQUIRED.label.equals(token2.toString())) {
                    field.setRequirement(FieldRequirement.REQUIRED);
                    token2 = tokenizer.expect("param type");
                }
                field.setType(this.parseType(tokenizer, token2, includedPrograms));
                token2 = tokenizer.expectIdentifier("param name");
                name = token2.toString();
                if (this.disallowedNameIdentifier(name)) {
                    throw tokenizer.failure(token2, "Param with reserved name: " + name, new Object[0]);
                }
                field.setName(name);
                field.setEndPos(this.endOf(token2));
                if (tokenizer.peek("method param annotation").isSymbol('(')) {
                    tokenizer.next();
                    field.setAnnotations(this.parseAnnotations(tokenizer, "params"));
                    field.setEndPos(this.endOf(tokenizer.getLastToken()));
                }
                if ((token2 = tokenizer.peek("method params")).isSymbol(',') || token2.isSymbol(';')) {
                    tokenizer.next();
                }
                method.addToParams(field.build());
            }
            doc_string = null;
            if (tokenizer.peek("possible throws statement").strEquals("throws")) {
                tokenizer.next();
                tokenizer.expectSymbol("throws group start", new char[]{'('});
                int nextAutoExceptionKey = -1;
                while (!(token2 = tokenizer.expect("exception key, type or end throws")).isSymbol(')')) {
                    if (token2.strEquals("//")) {
                        this.parseDocLine(tokenizer);
                        continue;
                    }
                    if (token2.strEquals("/*")) {
                        doc_string = tokenizer.parseDocBlock();
                        continue;
                    }
                    FieldType._Builder field = FieldType.builder();
                    if (doc_string != null) {
                        field.setDocumentation(doc_string);
                        doc_string = null;
                    }
                    field.setStartPos(new FilePos(token2.getLineNo(), token2.getLinePos()));
                    if (token2.isInteger()) {
                        field.setId((int)token2.parseInteger());
                        tokenizer.expectSymbol("exception KV sep", new char[]{':'});
                        token2 = tokenizer.expect("exception type");
                    } else {
                        if (this.requireFieldId) {
                            throw tokenizer.failure(token2, "Missing exception ID in strict declaration", new Object[0]);
                        }
                        field.setId(nextAutoExceptionKey--);
                    }
                    field.setType(this.parseType(tokenizer, token2, includedPrograms));
                    token2 = tokenizer.expectIdentifier("exception name");
                    name = token2.toString();
                    if (this.disallowedNameIdentifier(name)) {
                        throw tokenizer.failure(token2, "Thrown field with reserved name: " + name, new Object[0]);
                    }
                    field.setName(name);
                    field.setEndPos(this.endOf(token2));
                    if (tokenizer.peek("exception annotation start").isSymbol('(')) {
                        tokenizer.next();
                        field.setAnnotations(this.parseAnnotations(tokenizer, "exception"));
                        field.setEndPos(new FilePos(tokenizer.getLineNo(), tokenizer.getLinePos() + 1));
                    }
                    method.addToExceptions(field.build());
                    token2 = tokenizer.peek("method exceptions");
                    if (!token2.isSymbol(',') && !token2.isSymbol(';')) continue;
                    tokenizer.next();
                }
            }
            method.setEndPos(this.endOf(token2));
            token2 = tokenizer.peek("");
            if (token2.isSymbol('(')) {
                tokenizer.next();
                method.setAnnotations(this.parseAnnotations(tokenizer, "method"));
                method.setEndPos(new FilePos(tokenizer.getLineNo(), tokenizer.getLinePos() + 1));
                token2 = tokenizer.peek("method or service end");
            }
            if (token2.isSymbol(',') || token2.isSymbol(';')) {
                tokenizer.next();
            }
            service.addToMethods(method.build());
        }
        FilePos endPos = new FilePos(tokenizer.getLineNo(), tokenizer.getLinePos());
        if (tokenizer.hasNext() && (token = tokenizer.peek("optional annotations")).isSymbol('(')) {
            tokenizer.next();
            service.setAnnotations(this.parseAnnotations(tokenizer, "service"));
            endPos = this.endOf(tokenizer.getLastToken());
        }
        service.setEndPos(endPos);
        return service.build();
    }

    private Map<String, String> parseAnnotations(ThriftTokenizer tokenizer, String annotationsOn) throws IOException {
        TreeMap<String, String> annotations = new TreeMap<String, String>();
        int sep = 40;
        while (sep != 41) {
            Token token = tokenizer.expect(annotationsOn + " annotation name", Token::isReferenceIdentifier);
            String name = token.toString();
            sep = tokenizer.expectSymbol(annotationsOn + " annotation KV, sep or end", new char[]{'=', ')', ')', ','});
            if (sep == 61) {
                Token value = tokenizer.expectLiteral(annotationsOn + " annotation value");
                annotations.put(name, value.decodeLiteral(true));
                sep = tokenizer.expectSymbol(annotationsOn + " annotation sep or end", new char[]{')', ',', ';'});
                continue;
            }
            annotations.put(name, "");
        }
        return annotations;
    }

    private void parseNamespace(ThriftTokenizer tokenizer, Map<String, String> namespaces) throws IOException {
        Token language = tokenizer.expect("namespace language", Token::isReferenceIdentifier);
        if (namespaces.containsKey(language.toString())) {
            throw tokenizer.failure(language, "Namespace for %s already defined.", new Object[]{language.toString()});
        }
        Token namespace = tokenizer.expect("namespace", t -> VALID_NAMESPACE.matcher(t.toString()).matches() || VALID_SDI_NAMESPACE.matcher(t.toString()).matches());
        namespaces.put(language.toString(), namespace.toString());
    }

    private void parseIncludes(ThriftTokenizer tokenizer, List<String> includeFiles, File currentFile, Set<String> includePrograms, Collection<File> includeDirs) throws IOException {
        Token include = tokenizer.expectLiteral("include file");
        String filePath = include.decodeLiteral(true);
        if (!ReflectionUtils.isThriftFile(filePath)) {
            throw tokenizer.failure(include, "Include not valid for thrift files " + filePath, new Object[0]);
        }
        if (!this.includeExists(currentFile, filePath, includeDirs)) {
            throw tokenizer.failure(include, "Included file not found " + filePath, new Object[0]);
        }
        includeFiles.add(filePath);
        includePrograms.add(ReflectionUtils.programNameFromPath(filePath));
    }

    private boolean includeExists(File currentFile, String filePath, Collection<File> includeDirs) {
        File currentDir = currentFile.getParentFile();
        if (new File(currentDir, filePath).isFile()) {
            return true;
        }
        for (File I : includeDirs) {
            if (!new File(I, filePath).isFile()) continue;
            return true;
        }
        return false;
    }

    private void parseTypedef(ThriftTokenizer tokenizer, String comment, List<Declaration> declarations, Set<String> includedPrograms, FilePos startPos) throws IOException {
        String type = this.parseType(tokenizer, tokenizer.expect("typename"), includedPrograms);
        Token id = tokenizer.expectIdentifier("typedef identifier");
        String name = id.toString();
        if (this.disallowedNameIdentifier(name)) {
            throw tokenizer.failure(id, "Typedef with reserved name: " + name, new Object[0]);
        }
        TypedefType typedef = TypedefType.builder().setDocumentation(comment).setType(type).setName(name).setStartPos(startPos).setEndPos(this.endOf(id)).build();
        declarations.add(Declaration.withDeclTypedef(typedef));
    }

    private EnumType parseEnum(ThriftTokenizer tokenizer, String doc_string, FilePos startPos) throws IOException {
        Token token;
        Token id = tokenizer.expectIdentifier("enum name");
        String enum_name = id.toString();
        if (this.disallowedNameIdentifier(enum_name)) {
            throw tokenizer.failure(id, "Enum with reserved name: " + enum_name, new Object[0]);
        }
        EnumType._Builder enum_type = EnumType.builder();
        if (doc_string != null) {
            enum_type.setDocumentation(doc_string);
            doc_string = null;
        }
        enum_type.setName(enum_name);
        enum_type.setStartPos(startPos);
        int nextValueID = 0;
        tokenizer.expectSymbol("enum start", new char[]{'{'});
        if (!tokenizer.peek("").isSymbol('}')) {
            while (!(token = tokenizer.expect("enum value or end")).isSymbol('}')) {
                if (token.strEquals("//")) {
                    this.parseDocLine(tokenizer);
                    continue;
                }
                if (token.strEquals("/*")) {
                    doc_string = tokenizer.parseDocBlock();
                    continue;
                }
                if (token.isIdentifier()) {
                    String value_name = token.toString();
                    if (this.disallowedNameIdentifier(value_name)) {
                        throw tokenizer.failure(token, "Enum value with reserved name: " + enum_name, new Object[0]);
                    }
                    EnumValue._Builder enum_value = EnumValue.builder();
                    enum_value.setStartPos(new FilePos(token.getLineNo(), token.getLinePos()));
                    FilePos endPos = this.endOf(token);
                    enum_value.setName(value_name);
                    if (doc_string != null) {
                        enum_value.setDocumentation(doc_string);
                        doc_string = null;
                    }
                    int value_id = nextValueID++;
                    if (tokenizer.peek("enum value ID").isSymbol('=')) {
                        tokenizer.next();
                        Token v = tokenizer.expectInteger("enum value");
                        endPos = this.endOf(v);
                        value_id = (int)v.parseInteger();
                        nextValueID = value_id + 1;
                    } else if (this.requireEnumValue) {
                        if (tokenizer.hasNext()) {
                            token = tokenizer.expect("");
                        }
                        throw tokenizer.failure(token, "Missing enum value in strict declaration", new Object[0]);
                    }
                    enum_value.setId(value_id);
                    if (tokenizer.peek("enum value annotation").isSymbol('(')) {
                        tokenizer.next();
                        enum_value.setAnnotations(this.parseAnnotations(tokenizer, "enum value"));
                        endPos = this.endOf(tokenizer.getLastToken());
                    }
                    enum_value.setEndPos(endPos);
                    enum_type.addToValues(enum_value.build());
                    token = tokenizer.peek("enum value or end");
                    if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
                    tokenizer.next();
                    continue;
                }
                throw tokenizer.failure(token, "Unexpected token: %s", new Object[]{token.toString()});
            }
        }
        enum_type.setEndPos(this.endOf(tokenizer.getLastToken()));
        if (tokenizer.hasNext() && (token = tokenizer.peek("optional annotations")).isSymbol('(')) {
            tokenizer.next();
            enum_type.setAnnotations(this.parseAnnotations(tokenizer, "enum type"));
            enum_type.setEndPos(this.endOf(tokenizer.getLastToken()));
        }
        return enum_type.build();
    }

    private MessageType parseMessage(ThriftTokenizer tokenizer, String variant, String comment, Set<String> includedPrograms, FilePos startPos) throws IOException {
        Token token;
        Token nameToken;
        String name;
        MessageType._Builder struct = MessageType.builder();
        if (comment != null) {
            struct.setDocumentation(comment);
            comment = null;
        }
        boolean union = variant.equals("union");
        if (!variant.equals("struct")) {
            struct.setVariant(MessageVariant.valueForName(variant.toUpperCase(Locale.US)));
        }
        if (this.disallowedNameIdentifier(name = (nameToken = tokenizer.expectIdentifier("message name identifier")).toString())) {
            throw tokenizer.failure(nameToken, "Message with reserved name: " + name, new Object[0]);
        }
        struct.setName(name);
        struct.setStartPos(startPos);
        int nextAutoFieldKey = -1;
        tokenizer.expectSymbol("message start", new char[]{'{'});
        HashSet<String> fieldNames = new HashSet<String>();
        HashSet<String> fieldNameVariants = new HashSet<String>();
        HashSet<Integer> fieldIds = new HashSet<Integer>();
        while (!(token = tokenizer.expect("field def or message end")).isSymbol('}')) {
            if (token.strEquals("//")) {
                this.parseDocLine(tokenizer);
                continue;
            }
            if (token.strEquals("/*")) {
                comment = tokenizer.parseDocBlock();
                continue;
            }
            FieldType._Builder field = FieldType.builder();
            field.setDocumentation(comment);
            comment = null;
            field.setStartPos(new FilePos(token.getLineNo(), token.getLinePos()));
            if (token.isInteger()) {
                int fId = (int)token.parseInteger();
                if (fId < 1) {
                    throw tokenizer.failure(token, "Negative or 0 field id " + fId + " not allowed.", new Object[0]);
                }
                if (fieldIds.contains(fId)) {
                    throw tokenizer.failure(token, "Field id " + fId + " already exists in " + struct.build().getName(), new Object[0]);
                }
                fieldIds.add(fId);
                field.setId(fId);
                tokenizer.expectSymbol("field id sep", new char[]{':'});
                token = tokenizer.expect("field requirement or type", t -> t.isIdentifier() || t.isQualifiedIdentifier());
            } else {
                if (this.requireFieldId) {
                    throw tokenizer.failure(token, "Missing field ID in strict declaration", new Object[0]);
                }
                field.setId(nextAutoFieldKey--);
            }
            if (token.strEquals("required")) {
                if (union) {
                    throw tokenizer.failure(token, "Found required field in union", new Object[0]);
                }
                field.setRequirement(FieldRequirement.REQUIRED);
                token = tokenizer.expect("field type", t -> t.isIdentifier() || t.isQualifiedIdentifier());
            } else if (token.strEquals("optional")) {
                if (!union) {
                    field.setRequirement(FieldRequirement.OPTIONAL);
                }
                token = tokenizer.expect("field type", t -> t.isIdentifier() || t.isQualifiedIdentifier());
            }
            field.setType(this.parseType(tokenizer, token, includedPrograms));
            nameToken = tokenizer.expectIdentifier("field name");
            String fName = nameToken.toString();
            if (this.disallowedNameIdentifier(fName)) {
                throw tokenizer.failure(nameToken, "Field with reserved name: " + fName, new Object[0]);
            }
            if (fieldNames.contains(fName)) {
                throw tokenizer.failure(nameToken, "Field %s already exists in %s", new Object[]{fName, struct.build().getName()});
            }
            if (fieldNameVariants.contains(Strings.camelCase((String)"get", (String)fName))) {
                throw tokenizer.failure(nameToken, "Field %s has field with conflicting name in %s", new Object[]{fName, struct.build().getName()});
            }
            fieldNames.add(fName);
            fieldNameVariants.add(Strings.camelCase((String)"get", (String)fName));
            field.setName(fName);
            FilePos endPos = this.endOf(nameToken);
            token = tokenizer.peek("default sep, annotation, field def or message end");
            if (token.isSymbol('=')) {
                tokenizer.next();
                Token defaultValue = tokenizer.parseValue();
                field.setValueStartPos(new FilePos(defaultValue.getLineNo(), defaultValue.getLinePos()));
                field.setDefaultValue(defaultValue.toString());
                endPos = this.endOf(defaultValue);
                token = tokenizer.peek("field annotation, def or message end");
            }
            if (token.isSymbol('(')) {
                tokenizer.next();
                field.setAnnotations(this.parseAnnotations(tokenizer, "field"));
                endPos = this.endOf(tokenizer.getLastToken());
                token = tokenizer.peek("field def or message end");
            }
            field.setEndPos(endPos);
            struct.addToFields(field.build());
            if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
            tokenizer.next();
        }
        struct.setEndPos(this.endOf(tokenizer.getLastToken()));
        if (tokenizer.hasNext() && (token = tokenizer.peek("optional annotations")).isSymbol('(')) {
            tokenizer.next();
            struct.setAnnotations(this.parseAnnotations(tokenizer, "message"));
            struct.setEndPos(this.endOf(tokenizer.getLastToken()));
        }
        return struct.build();
    }

    private String parseType(ThriftTokenizer tokenizer, Token token, Set<String> includedPrograms) throws IOException {
        String program;
        String type;
        if (!token.isQualifiedIdentifier() && !token.isIdentifier()) {
            throw tokenizer.failure(token, "Expected type identifier but found " + token.toString(), new Object[0]);
        }
        switch (type = token.toString()) {
            case "list": 
            case "set": {
                tokenizer.expectSymbol(type + " generic start", new char[]{'<'});
                String item = this.parseType(tokenizer, tokenizer.expect(type + " item type", t -> t.isIdentifier() || t.isQualifiedIdentifier()), includedPrograms);
                tokenizer.expectSymbol(type + " generic end", new char[]{'>'});
                return String.format(Locale.US, "%s<%s>", type, item);
            }
            case "map": {
                tokenizer.expectSymbol(type + " generic start", new char[]{'<'});
                String key = this.parseType(tokenizer, tokenizer.expect(type + " key type", t -> t.isIdentifier() || t.isQualifiedIdentifier()), includedPrograms);
                tokenizer.expectSymbol(type + " generic sep", new char[]{','});
                String item = this.parseType(tokenizer, tokenizer.expect(type + " item type", t -> t.isIdentifier() || t.isQualifiedIdentifier()), includedPrograms);
                tokenizer.expectSymbol(type + " generic end", new char[]{'>'});
                return String.format(Locale.US, "%s<%s,%s>", type, key, item);
            }
        }
        if (type.contains(".") && !includedPrograms.contains(program = type.replaceAll("[.].*", ""))) {
            throw tokenizer.failure(token, "Unknown program '%s' for type %s", new Object[]{program, type});
        }
        return type;
    }
}

