/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessageDescriptor;
import net.morimekta.providence.reflect.contained.CUnion;

public class CUnionDescriptor
extends PUnionDescriptor<CUnion, CField>
implements CMessageDescriptor {
    private final CField[] fields;
    private final Map<Integer, CField> fieldIdMap;
    private final Map<String, CField> fieldNameMap;
    private final Map<String, String> annotations;
    private final String comment;

    public CUnionDescriptor(String comment, String packageName, String name, List<CField> fields, Map<String, String> annotations) {
        super(packageName, name, (Supplier)new _Factory(), false);
        ((_Factory)this.getBuilderSupplier()).setType(this);
        this.comment = comment;
        this.fields = fields.toArray(CField.EMPTY_ARRAY);
        this.annotations = annotations;
        LinkedHashMap<Integer, CField> fieldIdMap = new LinkedHashMap<Integer, CField>();
        LinkedHashMap<String, CField> fieldNameMap = new LinkedHashMap<String, CField>();
        for (CField field : fields) {
            fieldIdMap.put(field.getId(), field);
            fieldNameMap.put(field.getName(), field);
        }
        this.fieldIdMap = fieldIdMap;
        this.fieldNameMap = fieldNameMap;
    }

    @Override
    public final String getDocumentation() {
        return this.comment;
    }

    @Override
    @Nonnull
    public CField[] getFields() {
        return Arrays.copyOf(this.fields, this.fields.length);
    }

    @Override
    public CField findFieldByName(String name) {
        return this.fieldNameMap.get(name);
    }

    @Override
    public CField findFieldById(int id) {
        return this.fieldIdMap.get(id);
    }

    @Override
    public boolean isSimple() {
        for (CField field : this.getFields()) {
            switch (field.getType()) {
                case MAP: 
                case SET: 
                case LIST: 
                case MESSAGE: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Nonnull
    public Set<String> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAnnotation(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.get(name);
        }
        return null;
    }

    @Nonnull
    public CUnion.Builder builder() {
        return (CUnion.Builder)super.builder();
    }

    private static class _Factory
    implements Supplier<PMessageBuilder<CUnion, CField>> {
        private CUnionDescriptor mType;

        private _Factory() {
        }

        public void setType(CUnionDescriptor type) {
            this.mType = type;
        }

        @Override
        @Nonnull
        public PMessageBuilder<CUnion, CField> get() {
            return new CUnion.Builder(this.mType);
        }
    }
}

