/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessage;
import net.morimekta.providence.reflect.contained.CMessageBuilder;
import net.morimekta.providence.reflect.contained.CStructDescriptor;
import net.morimekta.providence.serializer.PrettySerializer;
import net.morimekta.providence.serializer.json.JsonCompactible;

public class CStruct
implements CMessage<CStruct>,
JsonCompactible {
    private static final PrettySerializer PRETTY_SERIALIZER = new PrettySerializer().compact();
    private Map<Integer, Object> values;
    private CStructDescriptor descriptor;

    private CStruct(Builder builder) {
        this.descriptor = builder.descriptor;
        this.values = builder.getValueMap();
    }

    @Override
    public Map<Integer, Object> values() {
        return this.values;
    }

    public boolean jsonCompact() {
        CStructDescriptor descriptor = this.descriptor();
        if (!descriptor.isJsonCompactible()) {
            return false;
        }
        boolean missing = false;
        for (CField field : descriptor.getFields()) {
            if (this.has(field.getId())) {
                if (!missing) continue;
                return false;
            }
            missing = true;
        }
        return true;
    }

    public boolean equals(Object o) {
        return this == o || o != null && o instanceof CStruct && CStruct.equals(this, (CStruct)o);
    }

    public int hashCode() {
        return CStruct.hashCode(this);
    }

    public String toString() {
        return this.descriptor().getQualifiedName() + this.asString();
    }

    @Nonnull
    public PMessageBuilder<CStruct, CField> mutate() {
        return new Builder(this.descriptor).merge(this);
    }

    @Nonnull
    public CStructDescriptor descriptor() {
        return this.descriptor;
    }

    protected static <M extends PMessage<M, CField>> boolean equals(M a, M b) {
        PMessageDescriptor type = b.descriptor();
        if (!a.descriptor().getQualifiedName().equals(type.getQualifiedName()) || !a.descriptor().getVariant().equals((Object)type.getVariant())) {
            return false;
        }
        for (CField field : (CField[])a.descriptor().getFields()) {
            int id = field.getId();
            if (a.has(id) != b.has(id)) {
                return false;
            }
            if (Objects.equals(a.get(id), b.get(id))) continue;
            return false;
        }
        return true;
    }

    protected static <M extends CMessage<M>> int hashCode(M self) {
        int hash = self.descriptor().hashCode();
        for (CField field : (CField[])self.descriptor().getFields()) {
            hash *= 29251;
            hash ^= Objects.hash(field, self.get(field));
        }
        return hash;
    }

    protected static <Message extends PMessage<Message, CField>> String asString(Message message) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PRETTY_SERIALIZER.serialize((OutputStream)baos, message);
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    private static <T extends Comparable<T>> int compare(T o1, T o2) {
        if (o1 instanceof PMessage && o2 instanceof PMessage) {
            return CStruct.compareMessages((PMessage)o1, (PMessage)o2);
        }
        return o1.compareTo(o2);
    }

    static <T extends PMessage<T, F>, F extends PField> int compareMessages(T m1, T m2) {
        int c = m1.descriptor().getQualifiedName().compareTo(m2.descriptor().getQualifiedName());
        if (c != 0) {
            return c;
        }
        for (PField field : m1.descriptor().getFields()) {
            c = Boolean.compare(m1.has(field.getId()), m2.has(field.getId()));
            if (c != 0) {
                return c;
            }
            if (!m1.has(field.getId()) || !m2.has(field.getId()) || (c = CStruct.compare((Comparable)m1.get(field.getId()), (Comparable)m2.get(field.getId()))) == 0) continue;
            return c;
        }
        return 0;
    }

    public static class Builder
    extends CMessageBuilder<Builder, CStruct> {
        private final CStructDescriptor descriptor;

        public Builder(CStructDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Nonnull
        public CStructDescriptor descriptor() {
            return this.descriptor;
        }

        @Nonnull
        public CStruct build() {
            return new CStruct(this);
        }
    }
}

