/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.util.collect.UnmodifiableMap;

public class CEnumValue
implements PEnumValue<CEnumValue>,
CAnnotatedDescriptor {
    private final int value;
    @Nonnull
    private final String name;
    @Nonnull
    private final PEnumDescriptor<CEnumValue> type;
    @Nullable
    private final String comment;
    @Nonnull
    private final Map<String, String> annotations;

    public CEnumValue(@Nullable String comment, int value, @Nonnull String name, @Nonnull PEnumDescriptor<CEnumValue> type, @Nullable Map<String, String> annotations) {
        this.comment = comment;
        this.value = value;
        this.name = name;
        this.type = type;
        this.annotations = annotations == null ? UnmodifiableMap.mapOf() : UnmodifiableMap.copyOf(annotations);
    }

    @Override
    public String getDocumentation() {
        return this.comment;
    }

    public int asInteger() {
        return this.value;
    }

    @Nonnull
    public String asString() {
        return this.name;
    }

    @Override
    @Nonnull
    public Set<String> getAnnotations() {
        return this.annotations.keySet();
    }

    @Override
    public boolean hasAnnotation(@Nonnull String name) {
        return this.annotations.containsKey(name);
    }

    @Override
    public String getAnnotationValue(@Nonnull String name) {
        return this.annotations.get(name);
    }

    @Nonnull
    public PEnumDescriptor<CEnumValue> descriptor() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof CEnumValue)) {
            return false;
        }
        CEnumValue other = (CEnumValue)o;
        return other.descriptor().getQualifiedName().equals(this.type.getQualifiedName()) && other.asString().equals(this.name) && other.asInteger() == this.value;
    }

    public int hashCode() {
        return Objects.hash(CEnumValue.class, this.descriptor().getQualifiedName(), this.name, this.value);
    }

    public int compareTo(@Nonnull CEnumValue other) {
        return Integer.compare(this.value, other.value);
    }

    public String toString() {
        return this.name.toUpperCase(Locale.US);
    }

    public static class Builder
    extends PEnumBuilder<CEnumValue> {
        private final CEnumDescriptor mType;
        private CEnumValue mValue = null;

        public Builder(CEnumDescriptor type) {
            this.mType = type;
        }

        public CEnumValue build() {
            return this.mValue;
        }

        public boolean valid() {
            return this.mValue != null;
        }

        @Nonnull
        public Builder setById(int id) {
            this.mValue = this.mType.findById(id);
            return this;
        }

        @Nonnull
        public Builder setByName(String name) {
            this.mValue = this.mType.findByName(name);
            return this;
        }
    }
}

