/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptorProvider;

public enum MessageVariant implements PEnumValue<MessageVariant>
{
    STRUCT(1, "STRUCT"),
    UNION(2, "UNION"),
    EXCEPTION(3, "EXCEPTION");

    private final int mId;
    private final String mName;
    public static final PEnumDescriptor<MessageVariant> kDescriptor;

    private MessageVariant(int id, String name) {
        this.mId = id;
        this.mName = name;
    }

    public int asInteger() {
        return this.mId;
    }

    @Nonnull
    public String asString() {
        return this.mName;
    }

    public static MessageVariant findById(int id) {
        switch (id) {
            case 1: {
                return STRUCT;
            }
            case 2: {
                return UNION;
            }
            case 3: {
                return EXCEPTION;
            }
        }
        return null;
    }

    public static MessageVariant findById(Integer id) {
        return id == null ? null : MessageVariant.findById((int)id);
    }

    public static MessageVariant findByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name given");
        }
        switch (name) {
            case "STRUCT": {
                return STRUCT;
            }
            case "UNION": {
                return UNION;
            }
            case "EXCEPTION": {
                return EXCEPTION;
            }
        }
        return null;
    }

    @Nonnull
    public static MessageVariant valueForId(int id) {
        MessageVariant value = MessageVariant.findById(id);
        if (value == null) {
            throw new IllegalArgumentException("No pmodel.MessageVariant for id " + id);
        }
        return value;
    }

    @Nonnull
    public static MessageVariant valueForName(String name) {
        MessageVariant value = MessageVariant.findByName(name);
        if (value == null) {
            throw new IllegalArgumentException("No pmodel.MessageVariant for name \"" + name + "\"");
        }
        return value;
    }

    public PEnumDescriptor<MessageVariant> descriptor() {
        return kDescriptor;
    }

    public static PEnumDescriptorProvider<MessageVariant> provider() {
        return new PEnumDescriptorProvider(kDescriptor);
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static class _Descriptor
    extends PEnumDescriptor<MessageVariant> {
        public _Descriptor() {
            super("pmodel", "MessageVariant", _Builder::new);
        }

        @Nonnull
        public MessageVariant[] getValues() {
            return MessageVariant.values();
        }

        @Nullable
        public MessageVariant findById(int id) {
            return MessageVariant.findById(id);
        }

        @Nullable
        public MessageVariant findByName(String name) {
            return MessageVariant.findByName(name);
        }
    }

    public static class _Builder
    extends PEnumBuilder<MessageVariant> {
        private MessageVariant mValue;

        @Nonnull
        public _Builder setById(int value) {
            this.mValue = MessageVariant.findById(value);
            return this;
        }

        @Nonnull
        public _Builder setByName(String name) {
            this.mValue = MessageVariant.findByName(name);
            return this;
        }

        public boolean valid() {
            return this.mValue != null;
        }

        public MessageVariant build() {
            return this.mValue;
        }
    }
}

