/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect;

import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.ProgramParser;
import net.morimekta.providence.reflect.parser.ThriftProgramParser;
import net.morimekta.providence.reflect.util.ProgramConverter;
import net.morimekta.providence.reflect.util.ProgramRegistry;
import net.morimekta.providence.reflect.util.ProgramTypeRegistry;
import net.morimekta.providence.reflect.util.ReflectionUtils;

public class TypeLoader {
    private final ProgramRegistry programRegistry;
    private final ProgramConverter converter;
    private final ProgramParser parser;
    private final Map<String, ProgramType> loadedDocuments;
    private final Collection<File> includes;

    public TypeLoader(Collection<File> includes) {
        this(includes, new ThriftProgramParser());
    }

    public TypeLoader(Collection<File> includes, ProgramParser parser) {
        this(includes, parser, new ProgramRegistry());
    }

    private TypeLoader(Collection<File> includes, ProgramParser parser, ProgramRegistry registry) {
        this(includes, parser, registry, new ProgramConverter(registry));
    }

    protected TypeLoader(Collection<File> includes, ProgramParser parser, ProgramRegistry registry, ProgramConverter converter) {
        this.includes = includes;
        this.parser = parser;
        this.programRegistry = registry;
        this.converter = converter;
        this.loadedDocuments = new LinkedHashMap<String, ProgramType>();
    }

    public Collection<ProgramType> loadedPrograms() {
        return this.loadedDocuments.values();
    }

    public ProgramTypeRegistry load(File file) throws IOException {
        return this.loadInternal(file, new ArrayList<String>());
    }

    private ProgramTypeRegistry loadInternal(File file, List<String> loadStack) throws IOException {
        loadStack = new ArrayList<String>(loadStack);
        if (!(file = file.getCanonicalFile()).exists()) {
            throw new IllegalArgumentException("No such file " + file);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Unable to load thrift program: " + file + " is not a file.");
        }
        String path = (file = file.getAbsoluteFile()).getPath();
        if (loadStack.contains(path)) {
            while (!loadStack.get(0).equals(path)) {
                loadStack.remove(0);
            }
            loadStack.add(path);
            String prefix = ReflectionUtils.longestCommonPrefixPath(loadStack);
            if (prefix.length() > 0) {
                loadStack = ReflectionUtils.stripCommonPrefix(loadStack);
                throw new IllegalArgumentException("Circular includes detected: " + prefix + "... " + String.join((CharSequence)" -> ", loadStack));
            }
            throw new IllegalArgumentException("Circular includes detected: " + String.join((CharSequence)" -> ", loadStack));
        }
        loadStack.add(path);
        ProgramTypeRegistry registry = this.programRegistry.registryForPath(path);
        if (this.programRegistry.containsProgramPath(path)) {
            return registry;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        ProgramType doc = this.parser.parse(in, file, this.includes);
        ArrayList<File> queue = new ArrayList<File>();
        if (doc.hasIncludes()) {
            for (String string : doc.getIncludes()) {
                File location = new File(file.getParent(), string).getCanonicalFile();
                if (!location.exists()) {
                    if (string.startsWith(".") || string.startsWith(File.separator)) {
                        throw new ParseException("No such file \"" + string + "\" to include from " + file.getName(), new Object[0]);
                    }
                    for (File inc : this.includes) {
                        File i = new File(inc, string);
                        if (!i.exists()) continue;
                        location = i.getCanonicalFile();
                        break;
                    }
                }
                if (!location.exists() || queue.contains(location)) continue;
                queue.add(location.getAbsoluteFile());
            }
        }
        Collections.reverse(queue);
        this.loadedDocuments.put(path, doc);
        for (File file2 : queue) {
            registry.registerInclude(ReflectionUtils.programNameFromPath(file2.getPath()), this.loadInternal(file2, (List<String>)ImmutableList.copyOf(loadStack)));
        }
        CProgram program = this.converter.convert(path, doc);
        this.programRegistry.putProgram(path, program);
        this.programRegistry.putProgramType(path, doc);
        return registry;
    }

    public ProgramRegistry getProgramRegistry() {
        return this.programRegistry;
    }
}

