/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import com.google.common.base.Strings;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ReflectionUtils {
    public static boolean isThriftFile(@Nonnull File file) {
        return ReflectionUtils.isThriftFile(file.getName());
    }

    public static boolean isThriftFile(@Nonnull String filePath) {
        return ReflectionUtils.programNameFromPath(filePath).length() > 0;
    }

    @Nonnull
    public static String programNameFromPath(@Nonnull String filePath) {
        String lowerCased = filePath.toLowerCase();
        if (!(lowerCased.endsWith(".providence") || lowerCased.endsWith(".thrift") || lowerCased.endsWith(".thr") || lowerCased.endsWith(".pvd"))) {
            return "";
        }
        if (filePath.contains("/") || filePath.contains("\\")) {
            filePath = filePath.replaceAll(".*[/\\\\]", "");
        }
        if (lowerCased.endsWith(".providence")) {
            filePath = filePath.substring(0, filePath.length() - 11);
        } else if (lowerCased.endsWith(".thrift")) {
            filePath = filePath.substring(0, filePath.length() - 7);
        } else if (lowerCased.endsWith(".thr") || lowerCased.endsWith(".pvd")) {
            filePath = filePath.substring(0, filePath.length() - 4);
        }
        return filePath.replaceAll("[-.]", "_");
    }

    @Nonnull
    public static String longestCommonPrefixPath(Collection<String> paths) {
        if (paths.size() == 0) {
            throw new IllegalArgumentException("Empty paths");
        }
        String prefix = paths.iterator().next();
        for (String s : paths) {
            prefix = Strings.commonPrefix((CharSequence)s, (CharSequence)prefix);
        }
        if (prefix.contains("/")) {
            return prefix.replaceAll("/[^/]*$", "/");
        }
        return "";
    }

    @Nonnull
    public static List<String> stripCommonPrefix(List<String> paths) {
        String prefix = ReflectionUtils.longestCommonPrefixPath(paths);
        if (prefix.length() > 0) {
            return paths.stream().map(s -> s.substring(prefix.length())).collect(Collectors.toList());
        }
        return paths;
    }
}

