/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.reflect.parser.internal.ConstParser;
import net.morimekta.providence.util.TypeRegistry;

public class ConstProvider
implements PValueProvider<Object> {
    private final TypeRegistry registry;
    private final String typeName;
    private final String programContext;
    private final String constantString;
    private final int startLineNo;
    private final int startLinePos;
    private Object parsedValue;

    public ConstProvider(@Nonnull TypeRegistry registry, @Nonnull String typeName, @Nonnull String programContext, @Nonnull String constantString, int startLineNo, int startLinePos) {
        this.registry = registry;
        this.typeName = typeName;
        this.programContext = programContext;
        this.constantString = constantString;
        this.parsedValue = null;
        this.startLineNo = startLineNo;
        this.startLinePos = startLinePos;
    }

    public Object get() {
        if (this.parsedValue == null) {
            ConstParser parser = new ConstParser(this.registry, this.programContext, this.startLineNo, this.startLinePos);
            PDescriptor type = this.registry.getProvider(this.typeName, this.programContext, Collections.EMPTY_MAP).descriptor();
            try (ByteArrayInputStream in = new ByteArrayInputStream(this.constantString.getBytes(StandardCharsets.UTF_8));){
                this.parsedValue = parser.parse(in, type);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
        }
        return this.parsedValue;
    }
}

