/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser.internal;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.serializer.pretty.Tokenizer;
import net.morimekta.providence.serializer.pretty.TokenizerException;
import net.morimekta.util.Strings;

public class ThriftTokenizer
extends Tokenizer {
    public static final String kNamespace = "namespace";
    public static final String kInclude = "include";
    public static final String kTypedef = "typedef";
    public static final String kEnum = "enum";
    public static final String kStruct = "struct";
    public static final String kUnion = "union";
    public static final String kException = "exception";
    public static final String kConst = "const";
    public static final String kService = "service";
    public static final String kExtends = "extends";
    public static final String kVoid = "void";
    public static final String kOneway = "oneway";
    public static final String kThrows = "throws";
    public static final String kRequired = "required";
    public static final String kOptional = "optional";
    public static final String kLineCommentStart = "//";
    public static final String kBlockCommentStart = "/*";
    public static final String kBlockCommentEnd = "*/";

    public ThriftTokenizer(InputStream in) throws IOException {
        super(in, false);
    }

    protected Token nextSymbol(int lastByte) throws TokenizerException {
        if (lastByte == 47) {
            int startOffset = this.readOffset;
            int startLineNo = this.lineNo;
            int startLinePos = this.linePos;
            int next = this.read();
            if (next < 0) {
                throw this.failure(startLineNo, startLinePos, 1, "Expected java-style comment, got end of file", new Object[0]);
            }
            if (next == 47 || next == 42) {
                return this.token(startOffset, 2, startLinePos);
            }
            throw this.failure(startLineNo, startLinePos, 2, "Expected java-style comment, got '%s' after '/'", new Object[]{Strings.escape((char)((char)next))});
        }
        return super.nextSymbol(lastByte);
    }

    @Nonnull
    protected TokenizerException failure(String format, Object ... params) {
        return new ParseException(format, params);
    }
}

