/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.morimekta.providence.model.ConstType;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.model.EnumType;
import net.morimekta.providence.model.EnumValue;
import net.morimekta.providence.model.FieldRequirement;
import net.morimekta.providence.model.FieldType;
import net.morimekta.providence.model.FunctionType;
import net.morimekta.providence.model.MessageType;
import net.morimekta.providence.model.MessageVariant;
import net.morimekta.providence.model.Model_Constants;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.model.ServiceType;
import net.morimekta.providence.model.TypedefType;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.ProgramParser;
import net.morimekta.providence.reflect.parser.internal.ThriftTokenizer;
import net.morimekta.providence.reflect.util.ReflectionUtils;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.serializer.pretty.TokenizerException;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IOUtils;

public class ThriftProgramParser
implements ProgramParser {
    private static final Pattern RE_BLOCK_LINE = Pattern.compile("^([\\s]*[*])?[\\s]?");
    private static final Pattern VALID_PROGRAM_NAME = Pattern.compile("[-._a-zA-Z][-._a-zA-Z0-9]*");
    public static final Pattern VALID_NAMESPACE = Pattern.compile("([_a-zA-Z][_a-zA-Z0-9]*[.])*[_a-zA-Z][_a-zA-Z0-9]*");
    public static final Pattern VALID_SDI_NAMESPACE = Pattern.compile("([_a-zA-Z][-_a-zA-Z0-9]*[.])*[_a-zA-Z][-_a-zA-Z0-9]*");
    private final boolean requireFieldId;
    private final boolean requireEnumValue;

    public ThriftProgramParser() {
        this(false, false);
    }

    public ThriftProgramParser(boolean requireFieldId, boolean requireEnumValue) {
        this.requireFieldId = requireFieldId;
        this.requireEnumValue = requireEnumValue;
    }

    @Override
    public ProgramType parse(InputStream in, File file, Collection<File> includeDirs) throws IOException {
        try {
            return this.parseInternal(in, file, includeDirs);
        }
        catch (TokenizerException e) {
            if (e.getFile() == null) {
                e.setFile(file.getName());
            }
            throw e;
        }
    }

    private ProgramType parseInternal(InputStream in, File file, Collection<File> includeDirs) throws IOException {
        Token token;
        ProgramType._Builder program = ProgramType.builder();
        String programName = ReflectionUtils.programNameFromPath(file.getName());
        if (!VALID_PROGRAM_NAME.matcher(programName).matches()) {
            throw new ParseException("Program name \"%s\" derived from filename \"%s\" is not valid.", Strings.escape((CharSequence)programName), Strings.escape((CharSequence)file.getName()));
        }
        program.setProgramName(programName);
        LinkedList<String> include_files = new LinkedList<String>();
        HashSet<String> includedPrograms = new HashSet<String>();
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        LinkedList<Declaration> declarations = new LinkedList<Declaration>();
        ThriftTokenizer tokenizer = new ThriftTokenizer(in);
        boolean has_header = false;
        boolean hasDeclaration = false;
        String doc_string = null;
        block20: while ((token = tokenizer.next()) != null) {
            if (token.strEquals("//")) {
                doc_string = this.parseDocLine(tokenizer, doc_string);
                continue;
            }
            if (token.strEquals("/*")) {
                doc_string = this.parseDocBlock(tokenizer);
                continue;
            }
            String keyword = token.asString();
            if (!Model_Constants.kThriftKeywords.contains(keyword)) {
                throw tokenizer.failure(token, "Unexpected token '%s'", new Object[]{token.asString()});
            }
            switch (keyword) {
                case "namespace": {
                    if (hasDeclaration) {
                        throw tokenizer.failure(token, "Unexpected token 'namespace', expected type declaration", new Object[0]);
                    }
                    if (doc_string != null && !has_header) {
                        program.setDocumentation(doc_string);
                    }
                    doc_string = null;
                    has_header = true;
                    this.parseNamespace(tokenizer, namespaces);
                    continue block20;
                }
                case "include": {
                    if (hasDeclaration) {
                        throw tokenizer.failure(token, "Unexpected token 'include', expected type declaration", new Object[0]);
                    }
                    if (doc_string != null && !has_header) {
                        program.setDocumentation(doc_string);
                    }
                    doc_string = null;
                    has_header = true;
                    this.parseIncludes(tokenizer, include_files, file, includedPrograms, includeDirs);
                    continue block20;
                }
                case "typedef": {
                    has_header = true;
                    hasDeclaration = true;
                    this.parseTypedef(tokenizer, doc_string, declarations, includedPrograms);
                    doc_string = null;
                    continue block20;
                }
                case "enum": {
                    has_header = true;
                    hasDeclaration = true;
                    EnumType et = this.parseEnum(tokenizer, doc_string);
                    declarations.add(Declaration.withDeclEnum(et));
                    doc_string = null;
                    continue block20;
                }
                case "struct": 
                case "union": 
                case "exception": {
                    has_header = true;
                    hasDeclaration = true;
                    MessageType st = this.parseMessage(tokenizer, token.asString(), doc_string, includedPrograms);
                    declarations.add(Declaration.withDeclStruct(st));
                    doc_string = null;
                    continue block20;
                }
                case "service": {
                    has_header = true;
                    hasDeclaration = true;
                    ServiceType srv = this.parseService(tokenizer, doc_string, includedPrograms);
                    declarations.add(Declaration.withDeclService(srv));
                    doc_string = null;
                    continue block20;
                }
                case "const": {
                    has_header = true;
                    hasDeclaration = true;
                    ConstType cnst = this.parseConst(tokenizer, doc_string, includedPrograms);
                    declarations.add(Declaration.withDeclConst(cnst));
                    doc_string = null;
                    continue block20;
                }
            }
            throw tokenizer.failure(token, "Unexpected token '%s'", new Object[]{Strings.escape((CharSequence)token.asString())});
        }
        if (namespaces.size() > 0) {
            program.setNamespaces(namespaces);
        }
        if (include_files.size() > 0) {
            program.setIncludes(include_files);
        }
        if (declarations.size() > 0) {
            program.setDecl(declarations);
        }
        return program.build();
    }

    private ConstType parseConst(ThriftTokenizer tokenizer, String comment, Set<String> includedPrograms) throws IOException, ParseException {
        Token token = tokenizer.expect("const typename", t -> t.isIdentifier() || t.isQualifiedIdentifier());
        String type = this.parseType(tokenizer, token, includedPrograms);
        Token id = tokenizer.expectIdentifier("const identifier");
        tokenizer.expectSymbol("const value separator", new char[]{'='});
        Token value = this.parseValue(tokenizer);
        Token sep = tokenizer.peek();
        if (sep != null && (sep.isSymbol(',') || sep.isSymbol(';'))) {
            tokenizer.next();
        }
        return ConstType.builder().setDocumentation(comment).setName(id.asString()).setType(type).setValue(value.asString()).setStartLineNo(value.getLineNo()).setStartLinePos(value.getLinePos()).build();
    }

    private Token parseValue(ThriftTokenizer tokenizer) throws IOException {
        Token token;
        Stack<Character> enclosures = new Stack<Character>();
        int startLineNo = 0;
        int startLinePos = 0;
        int offset = -1;
        while (true) {
            token = tokenizer.expect("const value");
            if (offset < 0) {
                offset = token.getOffset();
                startLineNo = token.getLineNo();
                startLinePos = token.getLinePos();
            }
            if (token.strEquals("/*")) {
                this.parseDocBlock(tokenizer);
                continue;
            }
            if (token.strEquals("//")) {
                this.parseDocLine(tokenizer, null);
                continue;
            }
            if (token.isSymbol('{')) {
                enclosures.push(Character.valueOf('}'));
            } else if (token.isSymbol('[')) {
                enclosures.push(Character.valueOf(']'));
            } else if ((token.isSymbol('}') || token.isSymbol(']')) && ((Character)enclosures.peek()).equals(Character.valueOf(token.charAt(0)))) {
                enclosures.pop();
            }
            if (enclosures.isEmpty()) break;
        }
        return tokenizer.token(offset, token.getOffset() - offset + token.length(), startLineNo, startLinePos);
    }

    private String parseDocLine(ThriftTokenizer tokenizer, String comment) throws IOException {
        String line = IOUtils.readString((InputStream)((Object)tokenizer), (String)"\n").trim();
        if (comment != null) {
            return comment + "\n" + line;
        }
        return line;
    }

    private String parseDocBlock(ThriftTokenizer tokenizer) throws IOException {
        String block = IOUtils.readString((InputStream)((Object)tokenizer), (String)"*/").trim();
        String[] lines = block.split("\\r?\\n");
        StringBuilder builder = new StringBuilder();
        Pattern re = RE_BLOCK_LINE;
        for (String line : lines) {
            builder.append(re.matcher(line).replaceFirst(""));
            builder.append('\n');
        }
        return builder.toString().trim();
    }

    private ServiceType parseService(ThriftTokenizer tokenizer, String doc_string, Set<String> includedPrograms) throws IOException, ParseException {
        Token token;
        ServiceType._Builder service = ServiceType.builder();
        if (doc_string != null) {
            service.setDocumentation(doc_string);
            doc_string = null;
        }
        Token identifier = tokenizer.expectIdentifier("service name");
        service.setName(identifier.asString());
        if (tokenizer.peek("service start or extends").strEquals("extends")) {
            tokenizer.next();
            service.setExtend(tokenizer.expect("service extending identifier", t -> t.isIdentifier() || t.isQualifiedIdentifier()).asString());
        }
        tokenizer.expectSymbol("reading service start", new char[]{'{'});
        TreeSet<String> methodNames = new TreeSet<String>();
        while (!(token = tokenizer.expect("service method initializer")).isSymbol('}')) {
            String name;
            String normalized;
            if (token.strEquals("//")) {
                doc_string = this.parseDocLine(tokenizer, doc_string);
                continue;
            }
            if (token.strEquals("/*")) {
                doc_string = this.parseDocBlock(tokenizer);
                continue;
            }
            FunctionType._Builder method = FunctionType.builder();
            if (doc_string != null) {
                method.setDocumentation(doc_string);
                doc_string = null;
            }
            if (token.strEquals("oneway")) {
                method.setOneWay(true);
                token = tokenizer.expect("service method type");
            }
            if (!token.strEquals("void")) {
                if (method.isSetOneWay()) {
                    throw tokenizer.failure(token, "Oneway methods must have void return type, found '%s'", new Object[]{Strings.escape((CharSequence)token.asString())});
                }
                method.setReturnType(this.parseType(tokenizer, token, includedPrograms));
            }
            if (methodNames.contains(normalized = Strings.camelCase((String)"", (String)(name = tokenizer.expectIdentifier("method name").asString())))) {
                throw tokenizer.failure(token, "Service method " + name + " has normalized name conflict", new Object[0]);
            }
            methodNames.add(normalized);
            method.setName(name);
            tokenizer.expectSymbol("method params begin", new char[]{'('});
            int nextAutoParamKey = -1;
            while (!(token = tokenizer.expect("method params")).isSymbol(')')) {
                if (token.strEquals("//")) {
                    doc_string = this.parseDocLine(tokenizer, doc_string);
                    continue;
                }
                if (token.strEquals("/*")) {
                    doc_string = this.parseDocBlock(tokenizer);
                    continue;
                }
                FieldType._Builder field = FieldType.builder();
                if (doc_string != null) {
                    field.setDocumentation(doc_string);
                    doc_string = null;
                }
                if (token.isInteger()) {
                    field.setId((int)token.parseInteger());
                    tokenizer.expectSymbol("params kv sep", new char[]{':'});
                    token = tokenizer.expect("param type");
                } else {
                    if (this.requireFieldId) {
                        throw tokenizer.failure(token, "Missing param ID in strict declaration", new Object[0]);
                    }
                    field.setId(nextAutoParamKey--);
                }
                field.setType(this.parseType(tokenizer, token, includedPrograms));
                field.setName(tokenizer.expectIdentifier("param name").asString());
                if (tokenizer.peek("method param annotation").isSymbol('(')) {
                    tokenizer.next();
                    field.setAnnotations(this.parseAnnotations(tokenizer, "params"));
                }
                if ((token = tokenizer.peek("method params")).isSymbol(',') || token.isSymbol(';')) {
                    tokenizer.next();
                }
                method.addToParams(field.build());
            }
            doc_string = null;
            if (tokenizer.peek("possible throws statement").strEquals("throws")) {
                tokenizer.next();
                tokenizer.expectSymbol("throws group start", new char[]{'('});
                int nextAutoExceptionKey = -1;
                while (!(token = tokenizer.expect("exception key, type or end throws")).isSymbol(')')) {
                    if (token.strEquals("//")) {
                        doc_string = this.parseDocLine(tokenizer, doc_string);
                        continue;
                    }
                    if (token.strEquals("/*")) {
                        doc_string = this.parseDocBlock(tokenizer);
                        continue;
                    }
                    FieldType._Builder field = FieldType.builder();
                    if (doc_string != null) {
                        field.setDocumentation(doc_string);
                        doc_string = null;
                    }
                    if (token.isInteger()) {
                        field.setId((int)token.parseInteger());
                        tokenizer.expectSymbol("exception KV sep", new char[]{':'});
                        token = tokenizer.expect("exception type");
                    } else {
                        if (this.requireFieldId) {
                            throw tokenizer.failure(token, "Missing exception ID in strict declaration", new Object[0]);
                        }
                        field.setId(nextAutoExceptionKey--);
                    }
                    field.setType(this.parseType(tokenizer, token, includedPrograms));
                    field.setName(tokenizer.expectIdentifier("exception name").asString());
                    if (tokenizer.peek("exception annotation start").isSymbol('(')) {
                        tokenizer.next();
                        field.setAnnotations(this.parseAnnotations(tokenizer, "exception"));
                    }
                    method.addToExceptions(field.build());
                    token = tokenizer.peek("method exceptions");
                    if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
                    tokenizer.next();
                }
            }
            if ((token = tokenizer.peek("")).isSymbol('(')) {
                tokenizer.next();
                method.setAnnotations(this.parseAnnotations(tokenizer, "method"));
                token = tokenizer.peek("method or service end");
            }
            service.addToMethods(method.build());
            if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
            tokenizer.next();
        }
        token = tokenizer.peek();
        if (token != null && token.isSymbol('(')) {
            tokenizer.next();
            service.setAnnotations(this.parseAnnotations(tokenizer, "service"));
        }
        return service.build();
    }

    private Map<String, String> parseAnnotations(ThriftTokenizer tokenizer, String annotationsOn) throws IOException {
        TreeMap<String, String> annotations = new TreeMap<String, String>();
        int sep = 40;
        while (sep != 41) {
            Token token = tokenizer.expect(annotationsOn + " annotation name", Token::isReferenceIdentifier);
            String name = token.asString();
            sep = tokenizer.expectSymbol(annotationsOn + " annotation KV, sep or end", new char[]{'=', ')', ')', ','});
            if (sep == 61) {
                Token value = tokenizer.expectLiteral(annotationsOn + " annotation value");
                annotations.put(name, value.decodeLiteral(true));
                sep = tokenizer.expectSymbol(annotationsOn + " annotation sep or end", new char[]{')', ',', ';'});
                continue;
            }
            annotations.put(name, "");
        }
        return annotations;
    }

    private void parseNamespace(ThriftTokenizer tokenizer, Map<String, String> namespaces) throws IOException {
        Token language = tokenizer.expect("namespace language", Token::isReferenceIdentifier);
        if (namespaces.containsKey(language.asString())) {
            throw tokenizer.failure(language, "Namespace for %s already defined.", new Object[]{language.asString()});
        }
        Token namespace = tokenizer.expect("namespace", t -> VALID_NAMESPACE.matcher(t.asString()).matches() || VALID_SDI_NAMESPACE.matcher(t.asString()).matches());
        namespaces.put(language.asString(), namespace.asString());
    }

    private void parseIncludes(ThriftTokenizer tokenizer, List<String> includeFiles, File currentFile, Set<String> includePrograms, Collection<File> includeDirs) throws IOException {
        Token include = tokenizer.expectLiteral("include file");
        String filePath = include.decodeLiteral(true);
        if (!ReflectionUtils.isThriftFile(filePath)) {
            throw tokenizer.failure(include, "Include not valid for thrift files " + filePath, new Object[0]);
        }
        if (!this.includeExists(currentFile, filePath, includeDirs)) {
            throw tokenizer.failure(include, "Included file not found " + filePath, new Object[0]);
        }
        includeFiles.add(filePath);
        includePrograms.add(ReflectionUtils.programNameFromPath(filePath));
    }

    private boolean includeExists(File currentFile, String filePath, Collection<File> includeDirs) {
        File currentDir = currentFile.getParentFile();
        if (new File(currentDir, filePath).isFile()) {
            return true;
        }
        for (File I : includeDirs) {
            if (!new File(I, filePath).isFile()) continue;
            return true;
        }
        return false;
    }

    private void parseTypedef(ThriftTokenizer tokenizer, String comment, List<Declaration> declarations, Set<String> includedPrograms) throws IOException {
        String type = this.parseType(tokenizer, tokenizer.expect("typename"), includedPrograms);
        Token id = tokenizer.expectIdentifier("typedef identifier");
        TypedefType typedef = TypedefType.builder().setDocumentation(comment).setType(type).setName(id.asString()).build();
        declarations.add(Declaration.withDeclTypedef(typedef));
    }

    private EnumType parseEnum(ThriftTokenizer tokenizer, String doc_string) throws IOException {
        Token token;
        String enum_name = tokenizer.expectIdentifier("enum name").asString();
        EnumType._Builder enum_type = EnumType.builder();
        if (doc_string != null) {
            enum_type.setDocumentation(doc_string);
            doc_string = null;
        }
        enum_type.setName(enum_name);
        int nextValueID = 0;
        tokenizer.expectSymbol("enum start", new char[]{'{'});
        if (!tokenizer.peek("").isSymbol('}')) {
            while (!(token = tokenizer.expect("enum value or end")).isSymbol('}')) {
                if (token.strEquals("//")) {
                    doc_string = this.parseDocLine(tokenizer, doc_string);
                    continue;
                }
                if (token.strEquals("/*")) {
                    doc_string = this.parseDocBlock(tokenizer);
                    continue;
                }
                if (token.isIdentifier()) {
                    EnumValue._Builder enum_value = EnumValue.builder();
                    enum_value.setName(token.asString());
                    if (doc_string != null) {
                        enum_value.setDocumentation(doc_string);
                        doc_string = null;
                    }
                    int value_id = nextValueID++;
                    if (tokenizer.peek("enum value ID").isSymbol('=')) {
                        tokenizer.next();
                        Token v = tokenizer.expectInteger("enum value");
                        value_id = (int)v.parseInteger();
                        nextValueID = value_id + 1;
                    } else if (this.requireEnumValue) {
                        if (tokenizer.hasNext()) {
                            token = tokenizer.next();
                        }
                        throw tokenizer.failure(token, "Missing enum value in strict declaration", new Object[0]);
                    }
                    enum_value.setId(value_id);
                    if (tokenizer.peek("enum value annotation").isSymbol('(')) {
                        tokenizer.next();
                        enum_value.setAnnotations(this.parseAnnotations(tokenizer, "enum value"));
                    }
                    enum_type.addToValues(enum_value.build());
                    token = tokenizer.peek("enum value or end");
                    if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
                    tokenizer.next();
                    continue;
                }
                throw tokenizer.failure(token, "Unexpected token: %s", new Object[]{token.asString()});
            }
        }
        if ((token = tokenizer.peek()) != null && token.isSymbol('(')) {
            tokenizer.next();
            enum_type.setAnnotations(this.parseAnnotations(tokenizer, "enum type"));
        }
        return enum_type.build();
    }

    private MessageType parseMessage(ThriftTokenizer tokenizer, String variant, String comment, Set<String> includedPrograms) throws IOException {
        Token token;
        MessageType._Builder struct = MessageType.builder();
        if (comment != null) {
            struct.setDocumentation(comment);
            comment = null;
        }
        boolean union = variant.equals("union");
        if (!variant.equals("struct")) {
            struct.setVariant(MessageVariant.valueForName(variant.toUpperCase()));
        }
        struct.setName(tokenizer.expectIdentifier("message name identifier").asString());
        int nextAutoFieldKey = -1;
        tokenizer.expectSymbol("message start", new char[]{'{'});
        HashSet<String> fieldNames = new HashSet<String>();
        HashSet<String> fieldNameVariants = new HashSet<String>();
        HashSet<Integer> fieldIds = new HashSet<Integer>();
        while (!(token = tokenizer.expect("field def or message end")).isSymbol('}')) {
            if (token.strEquals("//")) {
                comment = this.parseDocLine(tokenizer, comment);
                continue;
            }
            if (token.strEquals("/*")) {
                comment = this.parseDocBlock(tokenizer);
                continue;
            }
            FieldType._Builder field = FieldType.builder();
            field.setDocumentation(comment);
            comment = null;
            if (token.isInteger()) {
                int fId = (int)token.parseInteger();
                if (fId < 1) {
                    throw tokenizer.failure(token, "Negative or 0 field id " + fId + " not allowed.", new Object[0]);
                }
                if (fieldIds.contains(fId)) {
                    throw tokenizer.failure(token, "Field id " + fId + " already exists in " + struct.build().getName(), new Object[0]);
                }
                fieldIds.add(fId);
                field.setId(fId);
                tokenizer.expectSymbol("field id sep", new char[]{':'});
                token = tokenizer.expect("field requirement or type", t -> t.isIdentifier() || t.isQualifiedIdentifier());
            } else {
                if (this.requireFieldId) {
                    throw tokenizer.failure(token, "Missing field ID in strict declaration", new Object[0]);
                }
                field.setId(nextAutoFieldKey--);
            }
            if (token.strEquals("required")) {
                if (union) {
                    throw tokenizer.failure(token, "Found required field in union", new Object[0]);
                }
                field.setRequirement(FieldRequirement.REQUIRED);
                token = tokenizer.expect("field type", t -> t.isIdentifier() || t.isQualifiedIdentifier());
            } else if (token.strEquals("optional")) {
                if (!union) {
                    field.setRequirement(FieldRequirement.OPTIONAL);
                }
                token = tokenizer.expect("field type", t -> t.isIdentifier() || t.isQualifiedIdentifier());
            }
            field.setType(this.parseType(tokenizer, token, includedPrograms));
            Token name = tokenizer.expectIdentifier("field name");
            String fName = name.asString();
            if (fieldNames.contains(fName)) {
                throw tokenizer.failure(name, "Field %s already exists in %s", new Object[]{fName, struct.build().getName()});
            }
            if (fieldNameVariants.contains(Strings.camelCase((String)"get", (String)fName))) {
                throw tokenizer.failure(name, "Field %s has field with conflicting name in %s", new Object[]{fName, struct.build().getName()});
            }
            fieldNames.add(fName);
            fieldNameVariants.add(Strings.camelCase((String)"get", (String)fName));
            field.setName(fName);
            token = tokenizer.peek("default sep, annotation, field def or message end");
            if (token.isSymbol('=')) {
                tokenizer.next();
                Token defaultValue = this.parseValue(tokenizer);
                field.setDefaultValue(defaultValue.asString());
                field.setStartLineNo(defaultValue.getLineNo());
                field.setStartLinePos(defaultValue.getLinePos());
                token = tokenizer.peek("field annotation, def or message end");
            }
            if (token.isSymbol('(')) {
                tokenizer.next();
                field.setAnnotations(this.parseAnnotations(tokenizer, "field"));
                token = tokenizer.peek("field def or message end");
            }
            struct.addToFields(field.build());
            if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
            tokenizer.next();
        }
        token = tokenizer.peek();
        if (token != null && token.isSymbol('(')) {
            tokenizer.next();
            struct.setAnnotations(this.parseAnnotations(tokenizer, "message"));
        }
        return struct.build();
    }

    private String parseType(ThriftTokenizer tokenizer, Token token, Set<String> includedPrograms) throws IOException {
        String program;
        String type;
        if (!token.isQualifiedIdentifier() && !token.isIdentifier()) {
            throw tokenizer.failure(token, "Expected type identifier but found " + token.asString(), new Object[0]);
        }
        switch (type = token.asString()) {
            case "list": 
            case "set": {
                tokenizer.expectSymbol(type + " generic start", new char[]{'<'});
                String item = this.parseType(tokenizer, tokenizer.expect(type + " item type", t -> t.isIdentifier() || t.isQualifiedIdentifier()), includedPrograms);
                tokenizer.expectSymbol(type + " generic end", new char[]{'>'});
                return String.format("%s<%s>", type, item);
            }
            case "map": {
                tokenizer.expectSymbol(type + " generic start", new char[]{'<'});
                String key = this.parseType(tokenizer, tokenizer.expect(type + " key type", t -> t.isIdentifier() || t.isQualifiedIdentifier()), includedPrograms);
                tokenizer.expectSymbol(type + " generic sep", new char[]{','});
                String item = this.parseType(tokenizer, tokenizer.expect(type + " item type", t -> t.isIdentifier() || t.isQualifiedIdentifier()), includedPrograms);
                tokenizer.expectSymbol(type + " generic end", new char[]{'>'});
                return String.format("%s<%s,%s>", type, key, item);
            }
        }
        if (type.contains(".") && !includedPrograms.contains(program = type.replaceAll("[.].*", ""))) {
            throw tokenizer.failure(token, "Unknown program '%s' for type %s", new Object[]{program, type});
        }
        return type;
    }
}

