/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

@Immutable
public class ProgramType
implements PMessage<ProgramType, _Field>,
Comparable<ProgramType>,
Serializable,
BinaryWriter {
    private static final long serialVersionUID = 2224801959218006031L;
    private static final String kDefaultProgramName = "";
    private static final Map<String, String> kDefaultNamespaces = new PMap.DefaultBuilder().build();
    private static final List<Declaration> kDefaultDecl = new PList.DefaultBuilder().build();
    private final transient String mDocumentation;
    private final transient String mProgramName;
    private final transient List<String> mIncludes;
    private final transient Map<String, String> mNamespaces;
    private final transient List<Declaration> mDecl;
    private volatile transient int tHashCode;
    private transient ProgramType tSerializeInstance;
    public static final PStructDescriptor<ProgramType, _Field> kDescriptor = new _Descriptor();

    private ProgramType(_Builder builder) {
        this.mDocumentation = builder.mDocumentation;
        this.mProgramName = builder.isSetProgramName() ? builder.mProgramName : kDefaultProgramName;
        this.mIncludes = builder.isSetIncludes() ? ImmutableList.copyOf((Collection)builder.mIncludes) : null;
        this.mNamespaces = builder.isSetNamespaces() ? ImmutableSortedMap.copyOf((Map)builder.mNamespaces) : kDefaultNamespaces;
        this.mDecl = builder.isSetDecl() ? ImmutableList.copyOf((Collection)builder.mDecl) : kDefaultDecl;
    }

    public boolean hasDocumentation() {
        return this.mDocumentation != null;
    }

    public String getDocumentation() {
        return this.mDocumentation;
    }

    public boolean hasProgramName() {
        return true;
    }

    @Nonnull
    public String getProgramName() {
        return this.mProgramName;
    }

    public int numIncludes() {
        return this.mIncludes != null ? this.mIncludes.size() : 0;
    }

    public boolean hasIncludes() {
        return this.mIncludes != null;
    }

    public List<String> getIncludes() {
        return this.mIncludes;
    }

    public int numNamespaces() {
        return this.mNamespaces != null ? this.mNamespaces.size() : 0;
    }

    public boolean hasNamespaces() {
        return true;
    }

    @Nonnull
    public Map<String, String> getNamespaces() {
        return this.mNamespaces;
    }

    public int numDecl() {
        return this.mDecl != null ? this.mDecl.size() : 0;
    }

    public boolean hasDecl() {
        return true;
    }

    @Nonnull
    public List<Declaration> getDecl() {
        return this.mDecl;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.mDocumentation != null;
            }
            case 2: {
                return true;
            }
            case 3: {
                return this.mIncludes != null;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public <T> T get(int key) {
        switch (key) {
            case 1: {
                return (T)this.mDocumentation;
            }
            case 2: {
                return (T)this.mProgramName;
            }
            case 3: {
                return (T)this.mIncludes;
            }
            case 4: {
                return (T)this.mNamespaces;
            }
            case 5: {
                return (T)this.mDecl;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        ProgramType other = (ProgramType)o;
        return Objects.equals(this.mDocumentation, other.mDocumentation) && Objects.equals(this.mProgramName, other.mProgramName) && Objects.equals(this.mIncludes, other.mIncludes) && Objects.equals(this.mNamespaces, other.mNamespaces) && Objects.equals(this.mDecl, other.mDecl);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{ProgramType.class, _Field.DOCUMENTATION, this.mDocumentation, _Field.PROGRAM_NAME, this.mProgramName, _Field.INCLUDES, this.mIncludes, _Field.NAMESPACES, this.mNamespaces, _Field.DECL, this.mDecl});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.ProgramType" + this.asString();
    }

    @Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasDocumentation()) {
            first = false;
            out.append("documentation:").append('\"').append(Strings.escape((CharSequence)this.mDocumentation)).append('\"');
        }
        if (!first) {
            out.append(',');
        }
        out.append("program_name:").append('\"').append(Strings.escape((CharSequence)this.mProgramName)).append('\"');
        if (this.hasIncludes()) {
            out.append(',');
            out.append("includes:").append(Strings.asString(this.mIncludes));
        }
        out.append(',');
        out.append("namespaces:").append(Strings.asString(this.mNamespaces));
        out.append(',');
        out.append("decl:").append(Strings.asString(this.mDecl));
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(ProgramType other) {
        int c = Boolean.compare(this.mDocumentation != null, other.mDocumentation != null);
        if (c != 0) {
            return c;
        }
        if (this.mDocumentation != null && (c = this.mDocumentation.compareTo(other.mDocumentation)) != 0) {
            return c;
        }
        c = this.mProgramName.compareTo(other.mProgramName);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mIncludes != null, other.mIncludes != null);
        if (c != 0) {
            return c;
        }
        if (this.mIncludes != null && (c = Integer.compare(this.mIncludes.hashCode(), other.mIncludes.hashCode())) != 0) {
            return c;
        }
        c = Integer.compare(this.mNamespaces.hashCode(), other.mNamespaces.hashCode());
        if (c != 0) {
            return c;
        }
        c = Integer.compare(this.mDecl.hashCode(), other.mDecl.hashCode());
        if (c != 0) {
            return c;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        BinarySerializer serializer = new BinarySerializer(false);
        serializer.serialize((OutputStream)oos, (PMessage)this);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        BinarySerializer serializer = new BinarySerializer(false);
        this.tSerializeInstance = (ProgramType)serializer.deserialize((InputStream)ois, kDescriptor);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.tSerializeInstance;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        if (this.hasDocumentation()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)1);
            Binary tmp_1 = Binary.wrap((byte[])this.mDocumentation.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_1.length());
            length += writer.writeBinary(tmp_1);
        }
        length += writer.writeByte((byte)11);
        length += writer.writeShort((short)2);
        Binary tmp_2 = Binary.wrap((byte[])this.mProgramName.getBytes(StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_2.length());
        length += writer.writeBinary(tmp_2);
        if (this.hasIncludes()) {
            length += writer.writeByte((byte)15);
            length += writer.writeShort((short)3);
            length += writer.writeByte((byte)11);
            length += writer.writeUInt32(this.mIncludes.size());
            for (String string : this.mIncludes) {
                Binary tmp_4 = Binary.wrap((byte[])string.getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_4.length());
                length += writer.writeBinary(tmp_4);
            }
        }
        length += writer.writeByte((byte)13);
        length += writer.writeShort((short)4);
        length += writer.writeByte((byte)11);
        length += writer.writeByte((byte)11);
        length += writer.writeUInt32(this.mNamespaces.size());
        for (Map.Entry entry : this.mNamespaces.entrySet()) {
            Binary tmp_6 = Binary.wrap((byte[])((String)entry.getKey()).getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_6.length());
            length += writer.writeBinary(tmp_6);
            Binary tmp_7 = Binary.wrap((byte[])((String)entry.getValue()).getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_7.length());
            length += writer.writeBinary(tmp_7);
        }
        length += writer.writeByte((byte)15);
        length += writer.writeShort((short)5);
        length += writer.writeByte((byte)12);
        length += writer.writeUInt32(this.mDecl.size());
        for (Declaration declaration : this.mDecl) {
            length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessage)declaration);
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    @Nonnull
    public static PStructDescriptorProvider<ProgramType, _Field> provider() {
        return new _Provider();
    }

    @Nonnull
    public PStructDescriptor<ProgramType, _Field> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<ProgramType, _Field>
    implements BinaryReader {
        private BitSet optionals = new BitSet(5);
        private BitSet modified = new BitSet(5);
        private String mDocumentation;
        private String mProgramName = "";
        private List<String> mIncludes;
        private Map<String, String> mNamespaces = ProgramType.access$600();
        private List<Declaration> mDecl = ProgramType.access$700();

        public _Builder() {
        }

        public _Builder(ProgramType base) {
            this();
            if (base.hasDocumentation()) {
                this.optionals.set(0);
                this.mDocumentation = base.mDocumentation;
            }
            this.optionals.set(1);
            this.mProgramName = base.mProgramName;
            if (base.hasIncludes()) {
                this.optionals.set(2);
                this.mIncludes = base.mIncludes;
            }
            this.optionals.set(3);
            this.mNamespaces = base.mNamespaces;
            this.optionals.set(4);
            this.mDecl = base.mDecl;
        }

        @Nonnull
        public _Builder merge(ProgramType from) {
            if (from.hasDocumentation()) {
                this.optionals.set(0);
                this.modified.set(0);
                this.mDocumentation = from.getDocumentation();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mProgramName = from.getProgramName();
            if (from.hasIncludes()) {
                this.optionals.set(2);
                this.modified.set(2);
                this.mIncludes = from.getIncludes();
            }
            this.optionals.set(3);
            this.modified.set(3);
            this.mutableNamespaces().putAll(from.getNamespaces());
            this.optionals.set(4);
            this.modified.set(4);
            this.mDecl = from.getDecl();
            return this;
        }

        @Nonnull
        public _Builder setDocumentation(String value) {
            if (value == null) {
                return this.clearDocumentation();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mDocumentation = value;
            return this;
        }

        public boolean isSetDocumentation() {
            return this.optionals.get(0);
        }

        public boolean isModifiedDocumentation() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearDocumentation() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mDocumentation = null;
            return this;
        }

        public String getDocumentation() {
            return this.mDocumentation;
        }

        @Nonnull
        public _Builder setProgramName(String value) {
            if (value == null) {
                return this.clearProgramName();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mProgramName = value;
            return this;
        }

        public boolean isSetProgramName() {
            return this.optionals.get(1);
        }

        public boolean isModifiedProgramName() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearProgramName() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mProgramName = ProgramType.kDefaultProgramName;
            return this;
        }

        public String getProgramName() {
            return this.mProgramName;
        }

        @Nonnull
        public _Builder setIncludes(Collection<String> value) {
            if (value == null) {
                return this.clearIncludes();
            }
            this.optionals.set(2);
            this.modified.set(2);
            this.mIncludes = ImmutableList.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder addToIncludes(String ... values) {
            this.optionals.set(2);
            this.modified.set(2);
            List<String> _container = this.mutableIncludes();
            for (String item : values) {
                _container.add(item);
            }
            return this;
        }

        public boolean isSetIncludes() {
            return this.optionals.get(2);
        }

        public boolean isModifiedIncludes() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearIncludes() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mIncludes = null;
            return this;
        }

        @Nonnull
        public List<String> mutableIncludes() {
            this.optionals.set(2);
            this.modified.set(2);
            if (this.mIncludes == null) {
                this.mIncludes = new LinkedList<String>();
            } else if (!(this.mIncludes instanceof LinkedList)) {
                this.mIncludes = new LinkedList<String>(this.mIncludes);
            }
            return this.mIncludes;
        }

        @Nonnull
        public _Builder setNamespaces(Map<String, String> value) {
            if (value == null) {
                return this.clearNamespaces();
            }
            this.optionals.set(3);
            this.modified.set(3);
            this.mNamespaces = ImmutableSortedMap.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder putInNamespaces(String key, String value) {
            this.optionals.set(3);
            this.modified.set(3);
            this.mutableNamespaces().put(key, value);
            return this;
        }

        public boolean isSetNamespaces() {
            return this.optionals.get(3);
        }

        public boolean isModifiedNamespaces() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearNamespaces() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mNamespaces = kDefaultNamespaces;
            return this;
        }

        @Nonnull
        public Map<String, String> mutableNamespaces() {
            this.optionals.set(3);
            this.modified.set(3);
            if (this.mNamespaces == null) {
                this.mNamespaces = new TreeMap<String, String>();
            } else if (!(this.mNamespaces instanceof TreeMap)) {
                this.mNamespaces = new TreeMap<String, String>(this.mNamespaces);
            }
            return this.mNamespaces;
        }

        @Nonnull
        public _Builder setDecl(Collection<Declaration> value) {
            if (value == null) {
                return this.clearDecl();
            }
            this.optionals.set(4);
            this.modified.set(4);
            this.mDecl = ImmutableList.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder addToDecl(Declaration ... values) {
            this.optionals.set(4);
            this.modified.set(4);
            List<Declaration> _container = this.mutableDecl();
            for (Declaration item : values) {
                _container.add(item);
            }
            return this;
        }

        public boolean isSetDecl() {
            return this.optionals.get(4);
        }

        public boolean isModifiedDecl() {
            return this.modified.get(4);
        }

        @Nonnull
        public _Builder clearDecl() {
            this.optionals.clear(4);
            this.modified.set(4);
            this.mDecl = kDefaultDecl;
            return this;
        }

        @Nonnull
        public List<Declaration> mutableDecl() {
            this.optionals.set(4);
            this.modified.set(4);
            if (this.mDecl == null) {
                this.mDecl = new LinkedList<Declaration>();
            } else if (!(this.mDecl instanceof LinkedList)) {
                this.mDecl = new LinkedList<Declaration>(this.mDecl);
            }
            return this.mDecl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
                return false;
            }
            _Builder other = (_Builder)((Object)o);
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mDocumentation, other.mDocumentation) && Objects.equals(this.mProgramName, other.mProgramName) && Objects.equals(this.mIncludes, other.mIncludes) && Objects.equals(this.mNamespaces, other.mNamespaces) && Objects.equals(this.mDecl, other.mDecl);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{ProgramType.class, this.optionals, _Field.DOCUMENTATION, this.mDocumentation, _Field.PROGRAM_NAME, this.mProgramName, _Field.INCLUDES, this.mIncludes, _Field.NAMESPACES, this.mNamespaces, _Field.DECL, this.mDecl});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                default: 
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setDocumentation((String)value);
                    break;
                }
                case 2: {
                    this.setProgramName((String)value);
                    break;
                }
                case 3: {
                    this.setIncludes((List)value);
                    break;
                }
                case 4: {
                    this.setNamespaces((Map)value);
                    break;
                }
                case 5: {
                    this.setDecl((List)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 3: {
                    return this.optionals.get(2);
                }
                case 4: {
                    return this.optionals.get(3);
                }
                case 5: {
                    return this.optionals.get(4);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 3: {
                    return this.modified.get(2);
                }
                case 4: {
                    return this.modified.get(3);
                }
                case 5: {
                    return this.modified.get(4);
                }
            }
            return false;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 3: {
                    this.addToIncludes((String)value);
                    break;
                }
                case 5: {
                    this.addToDecl((Declaration)value);
                    break;
                }
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearDocumentation();
                    break;
                }
                case 2: {
                    this.clearProgramName();
                    break;
                }
                case 3: {
                    this.clearIncludes();
                    break;
                }
                case 4: {
                    this.clearNamespaces();
                    break;
                }
                case 5: {
                    this.clearDecl();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return this.optionals.get(1);
        }

        public void validate() {
            if (!this.valid()) {
                LinkedList<String> missing = new LinkedList<String>();
                if (!this.optionals.get(1)) {
                    missing.add("program_name");
                }
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message model.ProgramType");
            }
        }

        @Nonnull
        public PStructDescriptor<ProgramType, _Field> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mDocumentation = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.ProgramType.documentation, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            this.mProgramName = new String(reader.expectBytes(len_2), StandardCharsets.UTF_8);
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.ProgramType.program_name, should be struct(12)", new Object[0]);
                    }
                    case 3: {
                        if (type == 15) {
                            PList.DefaultBuilder b_3 = new PList.DefaultBuilder();
                            byte t_5 = reader.expectByte();
                            if (t_5 == 11) {
                                int len_4 = reader.expectUInt32();
                                for (int i_6 = 0; i_6 < len_4; ++i_6) {
                                    int len_8 = reader.expectUInt32();
                                    String key_7 = new String(reader.expectBytes(len_8), StandardCharsets.UTF_8);
                                    b_3.add((Object)key_7);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_5) + " for model.ProgramType.includes, should be string(11)", new Object[0]);
                            }
                            this.mIncludes = b_3.build();
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.ProgramType.includes, should be struct(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 13) {
                            PMap.SortedBuilder b_9 = new PMap.SortedBuilder();
                            byte t_11 = reader.expectByte();
                            byte t_12 = reader.expectByte();
                            if (t_11 == 11 && t_12 == 11) {
                                int len_10 = reader.expectUInt32();
                                for (int i_13 = 0; i_13 < len_10; ++i_13) {
                                    int len_16 = reader.expectUInt32();
                                    String key_14 = new String(reader.expectBytes(len_16), StandardCharsets.UTF_8);
                                    int len_17 = reader.expectUInt32();
                                    String val_15 = new String(reader.expectBytes(len_17), StandardCharsets.UTF_8);
                                    b_9.put((Comparable)((Object)key_14), (Object)val_15);
                                }
                            } else {
                                throw new SerializerException("Wrong key type " + BinaryType.asString((byte)t_11) + " or value type " + BinaryType.asString((byte)t_12) + " for model.ProgramType.namespaces, should be string(11) and string(11)", new Object[0]);
                            }
                            this.mNamespaces = b_9.build();
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.ProgramType.namespaces, should be struct(12)", new Object[0]);
                    }
                    case 5: {
                        if (type == 15) {
                            PList.DefaultBuilder b_18 = new PList.DefaultBuilder();
                            byte t_20 = reader.expectByte();
                            if (t_20 == 12) {
                                int len_19 = reader.expectUInt32();
                                for (int i_21 = 0; i_21 < len_19; ++i_21) {
                                    Declaration key_22 = (Declaration)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, Declaration.kDescriptor, (boolean)strict);
                                    b_18.add((Object)key_22);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_20) + " for model.ProgramType.decl, should be struct(12)", new Object[0]);
                            }
                            this.mDecl = b_18.build();
                            this.optionals.set(4);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.ProgramType.decl, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        public ProgramType build() {
            return new ProgramType(this);
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<ProgramType, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<ProgramType, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<ProgramType, _Field> {
        public _Descriptor() {
            super("model", "ProgramType", _Builder::new, false);
        }

        @Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    public static enum _Field implements PField
    {
        DOCUMENTATION(1, PRequirement.OPTIONAL, "documentation", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        PROGRAM_NAME(2, PRequirement.REQUIRED, "program_name", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        INCLUDES(3, PRequirement.OPTIONAL, "includes", (PDescriptorProvider)PList.provider((PDescriptorProvider)PPrimitive.STRING.provider()), null),
        NAMESPACES(4, PRequirement.DEFAULT, "namespaces", (PDescriptorProvider)PMap.sortedProvider((PDescriptorProvider)PPrimitive.STRING.provider(), (PDescriptorProvider)PPrimitive.STRING.provider()), null),
        DECL(5, PRequirement.DEFAULT, "decl", (PDescriptorProvider)PList.provider(Declaration.provider()), null);

        private final int mId;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int id, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mId = id;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getId() {
            return this.mId;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field findById(int id) {
            switch (id) {
                case 1: {
                    return DOCUMENTATION;
                }
                case 2: {
                    return PROGRAM_NAME;
                }
                case 3: {
                    return INCLUDES;
                }
                case 4: {
                    return NAMESPACES;
                }
                case 5: {
                    return DECL;
                }
            }
            return null;
        }

        public static _Field findByName(String name) {
            switch (name) {
                case "documentation": {
                    return DOCUMENTATION;
                }
                case "program_name": {
                    return PROGRAM_NAME;
                }
                case "includes": {
                    return INCLUDES;
                }
                case "namespaces": {
                    return NAMESPACES;
                }
                case "decl": {
                    return DECL;
                }
            }
            return null;
        }

        public static _Field fieldForId(int id) {
            _Field field = _Field.findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in model.ProgramType");
            }
            return field;
        }

        public static _Field fieldForName(String name) {
            _Field field = _Field.findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in model.ProgramType");
            }
            return field;
        }
    }
}

