/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.model.ConstType;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.model.EnumType;
import net.morimekta.providence.model.EnumValue;
import net.morimekta.providence.model.FieldType;
import net.morimekta.providence.model.FunctionType;
import net.morimekta.providence.model.MessageType;
import net.morimekta.providence.model.MessageVariant;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.model.ServiceType;
import net.morimekta.providence.reflect.contained.CConst;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CEnumValue;
import net.morimekta.providence.reflect.contained.CExceptionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.contained.CServiceMethod;
import net.morimekta.providence.reflect.contained.CStructDescriptor;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;
import net.morimekta.providence.reflect.util.ConstProvider;
import net.morimekta.providence.reflect.util.ProgramRegistry;
import net.morimekta.providence.reflect.util.ProgramTypeRegistry;
import net.morimekta.providence.reflect.util.ReflectionUtils;
import net.morimekta.providence.util.TypeRegistry;

public class ProgramConverter {
    private final ProgramRegistry programRegistry;

    public ProgramConverter(ProgramRegistry programRegistry) {
        this.programRegistry = programRegistry;
    }

    public CProgram convert(String path, ProgramType program) {
        ImmutableList.Builder declaredTypes = ImmutableList.builder();
        ImmutableList.Builder constants = ImmutableList.builder();
        ImmutableMap.Builder typedefs = ImmutableMap.builder();
        ImmutableList.Builder services = ImmutableList.builder();
        ProgramTypeRegistry registry = this.programRegistry.registryForPath(path);
        File dir = new File(path).getParentFile();
        if (program.hasIncludes()) {
            for (String include : program.getIncludes()) {
                String includePath = new File(dir, include).getPath();
                registry.registerInclude(ReflectionUtils.programNameFromPath(include), this.programRegistry.registryForPath(includePath));
            }
        }
        for (Declaration decl : program.getDecl()) {
            switch (decl.unionField()) {
                case DECL_ENUM: {
                    EnumType enumType = decl.getDeclEnum();
                    int nextValue = 0;
                    Object type = new CEnumDescriptor(enumType.getDocumentation(), program.getProgramName(), enumType.getName(), enumType.getAnnotations());
                    LinkedList<CEnumValue> values = new LinkedList<CEnumValue>();
                    for (EnumValue enumValue : enumType.getValues()) {
                        int v = enumValue.hasId() ? enumValue.getId() : nextValue;
                        nextValue = v + 1;
                        values.add(new CEnumValue(enumValue.getDocumentation(), enumValue.getId(), enumValue.getName(), (PEnumDescriptor<CEnumValue>)type, enumValue.getAnnotations()));
                    }
                    ((CEnumDescriptor)type).setValues(values);
                    declaredTypes.add(type);
                    registry.register(type);
                    break;
                }
                case DECL_STRUCT: {
                    Object type;
                    MessageType messageType = decl.getDeclStruct();
                    LinkedList<CField> fields = new LinkedList<CField>();
                    if (messageType.hasFields()) {
                        fields.addAll(messageType.getFields().stream().map(field -> this.makeField((TypeRegistry)registry, program.getProgramName(), (FieldType)field, messageType.getVariant())).collect(Collectors.toList()));
                    }
                    switch (messageType.getVariant()) {
                        case STRUCT: {
                            type = new CStructDescriptor(messageType.getDocumentation(), program.getProgramName(), messageType.getName(), fields, messageType.getAnnotations());
                            break;
                        }
                        case UNION: {
                            type = new CUnionDescriptor(messageType.getDocumentation(), program.getProgramName(), messageType.getName(), fields, messageType.getAnnotations());
                            break;
                        }
                        case EXCEPTION: {
                            type = new CExceptionDescriptor(messageType.getDocumentation(), program.getProgramName(), messageType.getName(), fields, messageType.getAnnotations());
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unhandled message variant " + (Object)((Object)messageType.getVariant()));
                        }
                    }
                    declaredTypes.add(type);
                    registry.register(type);
                    break;
                }
                case DECL_CONST: {
                    ConstType constant = decl.getDeclConst();
                    constants.add((Object)this.makeConst((TypeRegistry)registry, program.getProgramName(), constant));
                    break;
                }
                case DECL_TYPEDEF: {
                    typedefs.put((Object)decl.getDeclTypedef().getName(), (Object)decl.getDeclTypedef().getType());
                    registry.registerTypedef(decl.getDeclTypedef().getName(), program.getProgramName(), decl.getDeclTypedef().getType());
                    break;
                }
                case DECL_SERVICE: {
                    ServiceType serviceType = decl.getDeclService();
                    ImmutableList.Builder methodBuilder = ImmutableList.builder();
                    if (serviceType.hasMethods()) {
                        for (FunctionType sm : serviceType.getMethods()) {
                            LinkedList<CField> rqFields = new LinkedList<CField>();
                            if (sm.numParams() > 0) {
                                for (FieldType field2 : sm.getParams()) {
                                    rqFields.add(this.makeField((TypeRegistry)registry, program.getProgramName(), field2, MessageVariant.STRUCT));
                                }
                            }
                            CStructDescriptor cStructDescriptor = new CStructDescriptor(null, program.getProgramName(), serviceType.getName() + '.' + sm.getName() + ".request", rqFields, null);
                            CUnionDescriptor response = null;
                            if (!sm.isOneWay()) {
                                CField success;
                                LinkedList<CField> rsFields = new LinkedList<CField>();
                                if (sm.getReturnType() != null) {
                                    PDescriptorProvider type = registry.getProvider(sm.getReturnType(), program.getProgramName(), sm.getAnnotations());
                                    success = new CField(null, 0, PRequirement.OPTIONAL, "success", type, null, null);
                                } else {
                                    success = new CField(null, 0, PRequirement.OPTIONAL, "success", (PDescriptorProvider)PPrimitive.VOID.provider(), null, null);
                                }
                                rsFields.add(success);
                                if (sm.numExceptions() > 0) {
                                    for (FieldType field3 : sm.getExceptions()) {
                                        rsFields.add(this.makeField((TypeRegistry)registry, program.getProgramName(), field3, MessageVariant.UNION));
                                    }
                                }
                                response = new CUnionDescriptor(null, program.getProgramName(), serviceType.getName() + '.' + sm.getName() + ".response", rsFields, null);
                            }
                            CServiceMethod method = new CServiceMethod(sm.getDocumentation(), sm.getName(), sm.isOneWay(), cStructDescriptor, response, sm.getAnnotations());
                            methodBuilder.add((Object)method);
                        }
                    }
                    PServiceProvider extendsProvider = null;
                    if (serviceType.hasExtend()) {
                        extendsProvider = registry.getServiceProvider(serviceType.getExtend(), program.getProgramName());
                    }
                    CService service = new CService(serviceType.getDocumentation(), program.getProgramName(), serviceType.getName(), extendsProvider, (Collection<CServiceMethod>)methodBuilder.build(), serviceType.getAnnotations());
                    services.add((Object)service);
                    registry.registerRecursively(service);
                }
            }
        }
        return new CProgram(path, program.getDocumentation(), program.getProgramName(), program.getNamespaces(), (Collection<String>)this.getIncludedProgramNames(program), (Collection<String>)program.getIncludes(), (Map<String, String>)typedefs.build(), (Collection<PDeclaredDescriptor<?>>)declaredTypes.build(), (Collection<CService>)services.build(), (Collection<CConst>)constants.build());
    }

    private Set<String> getIncludedProgramNames(ProgramType document) {
        TreeSet<String> out = new TreeSet<String>();
        if (document.hasIncludes()) {
            for (String include : document.getIncludes()) {
                String program = ReflectionUtils.programNameFromPath(include);
                if (out.contains(program)) {
                    throw new IllegalArgumentException("Program " + document.getProgramName() + " includes multiple programs of name " + program);
                }
                out.add(program);
            }
        }
        return out;
    }

    private CConst makeConst(TypeRegistry registry, String pkg, ConstType field) {
        PDescriptorProvider type = registry.getProvider(field.getType(), pkg, field.getAnnotations());
        if (!field.hasValue()) {
            throw new IllegalArgumentException("Const " + pkg + "." + field.getName() + " does not have a value.");
        }
        ConstProvider defaultValue = new ConstProvider(registry, field.getType(), pkg, field.getValue(), field.getStartLineNo(), field.getStartLinePos());
        CConst made = new CConst(field.getDocumentation(), field.getName(), type, defaultValue, field.getAnnotations());
        return made;
    }

    private CField makeField(TypeRegistry registry, String pkg, FieldType field, MessageVariant variant) {
        PDescriptorProvider type = registry.getProvider(field.getType(), pkg, field.getAnnotations());
        ConstProvider defaultValue = null;
        if (field.hasDefaultValue()) {
            defaultValue = new ConstProvider(registry, field.getType(), pkg, field.getDefaultValue(), field.getStartLineNo(), field.getStartLinePos());
        }
        PRequirement requirement = PRequirement.valueOf((String)field.getRequirement().asString());
        if (variant == MessageVariant.UNION) {
            if (requirement == PRequirement.REQUIRED) {
                throw new IllegalArgumentException("Required field in union");
            }
            requirement = PRequirement.OPTIONAL;
        }
        CField made = new CField(field.getDocumentation(), field.getId(), requirement, field.getName(), type, defaultValue, field.getAnnotations());
        return made;
    }
}

