/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CStruct;

public interface CMessage<Message extends PMessage<Message, CField>>
extends PMessage<Message, CField> {
    public Map<Integer, Object> values();

    default public boolean has(int key) {
        CField field = (CField)this.descriptor().findFieldById(key);
        return field != null && this.values().containsKey(key);
    }

    default public int num(int key) {
        CField field = (CField)this.descriptor().findFieldById(key);
        if (field == null) {
            return 0;
        }
        if (!this.values().containsKey(key)) {
            return 0;
        }
        switch (field.getDescriptor().getType()) {
            case MAP: {
                return ((Map)this.values().get(key)).size();
            }
            case LIST: 
            case SET: {
                return ((Collection)this.values().get(key)).size();
            }
        }
        return 0;
    }

    default public Object get(int key) {
        CField field = (CField)this.descriptor().findFieldById(key);
        if (field != null) {
            Object value = this.values().get(key);
            if (value != null) {
                return value;
            }
            if (field.hasDefaultValue()) {
                return field.getDefaultValue();
            }
            if (field.getDescriptor() instanceof PPrimitive && ((PPrimitive)field.getDescriptor()).isNativePrimitive() || field.getRequirement() != PRequirement.OPTIONAL) {
                return field.getDescriptor().getDefaultValue();
            }
        }
        return null;
    }

    default public int compareTo(@Nonnull Message other) {
        return CStruct.compareMessages(this, other);
    }

    @Nonnull
    default public String asString() {
        return CStruct.asString(this);
    }
}

