/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.ProgramParser;
import net.morimekta.providence.reflect.parser.ThriftProgramParser;
import net.morimekta.providence.reflect.util.ProgramConverter;
import net.morimekta.providence.reflect.util.ProgramRegistry;
import net.morimekta.providence.reflect.util.ProgramTypeRegistry;
import net.morimekta.providence.reflect.util.ReflectionUtils;

public class TypeLoader {
    private final ProgramRegistry programRegistry;
    private final ProgramConverter converter;
    private final ProgramParser parser;
    private final Map<String, ProgramType> loadedDocuments;
    private final Collection<File> includes;

    public TypeLoader(Collection<File> includes) {
        this(includes, new ThriftProgramParser());
    }

    public TypeLoader(Collection<File> includes, ProgramParser parser) {
        this(includes, parser, new ProgramRegistry());
    }

    private TypeLoader(Collection<File> includes, ProgramParser parser, ProgramRegistry registry) {
        this(includes, parser, registry, new ProgramConverter(registry));
    }

    protected TypeLoader(Collection<File> includes, ProgramParser parser, ProgramRegistry registry, ProgramConverter converter) {
        this.includes = includes;
        this.parser = parser;
        this.programRegistry = registry;
        this.converter = converter;
        this.loadedDocuments = new LinkedHashMap<String, ProgramType>();
    }

    public Collection<ProgramType> loadedPrograms() {
        return this.loadedDocuments.values();
    }

    public ProgramTypeRegistry load(File file) throws IOException {
        if (!(file = file.getCanonicalFile()).exists()) {
            throw new IllegalArgumentException("No such file " + file.getCanonicalPath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Unable to load thrift program: " + file.getCanonicalPath() + " is not a file.");
        }
        file = file.getAbsoluteFile();
        String path = file.getPath();
        ProgramTypeRegistry registry = this.programRegistry.registryForPath(path);
        if (this.programRegistry.containsProgramPath(path)) {
            return registry;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        ProgramType doc = this.parser.parse(in, file, this.includes);
        LinkedList<File> queue = new LinkedList<File>();
        if (doc.hasIncludes()) {
            for (String string : doc.getIncludes()) {
                File location = new File(file.getParent(), string).getCanonicalFile();
                if (!location.exists()) {
                    if (string.startsWith(".") || string.startsWith(File.separator)) {
                        throw new ParseException("No such file \"" + string + "\" to include from " + file.getName(), new Object[0]);
                    }
                    for (File inc : this.includes) {
                        File i = new File(inc, string);
                        if (!i.exists()) continue;
                        location = i.getCanonicalFile();
                        break;
                    }
                }
                if (!location.exists() || queue.contains(location)) continue;
                queue.add(location.getAbsoluteFile());
            }
        }
        Collections.reverse(queue);
        this.loadedDocuments.put(path, doc);
        for (File file2 : queue) {
            registry.registerInclude(ReflectionUtils.programNameFromPath(file2.getPath()), this.load(file2));
        }
        CProgram program = this.converter.convert(path, doc);
        this.programRegistry.putProgram(path, program);
        return registry;
    }

    public ProgramRegistry getProgramRegistry() {
        return this.programRegistry;
    }
}

