/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.io.File;
import javax.annotation.Nonnull;

public class ReflectionUtils {
    public static boolean isThriftFile(@Nonnull File file) {
        return ReflectionUtils.isThriftFile(file.getName());
    }

    public static boolean isThriftFile(@Nonnull String filePath) {
        return ReflectionUtils.programNameFromPath(filePath).length() > 0;
    }

    @Nonnull
    public static String programNameFromPath(@Nonnull String filePath) {
        String lowerCased = filePath.toLowerCase();
        if (!(lowerCased.endsWith(".providence") || lowerCased.endsWith(".thrift") || lowerCased.endsWith(".thr") || lowerCased.endsWith(".pvd"))) {
            return "";
        }
        if (lowerCased.endsWith(".providence")) {
            filePath = filePath.substring(0, filePath.length() - 11);
        } else if (lowerCased.endsWith(".thrift")) {
            filePath = filePath.substring(0, filePath.length() - 7);
        } else if (lowerCased.endsWith(".thr") || lowerCased.endsWith(".pvd")) {
            filePath = filePath.substring(0, filePath.length() - 4);
        }
        if (filePath.contains("/") || filePath.contains("\\")) {
            filePath = filePath.replaceAll(".*[/\\\\]", "");
        }
        return filePath.replaceAll("[-.]", "_");
    }
}

