/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.parser.ThriftProgramParser;
import net.morimekta.providence.reflect.util.ThriftAnnotation;
import net.morimekta.providence.reflect.util.ThriftCollection;
import net.morimekta.providence.util.TypeRegistry;

public class ProgramRegistry
extends TypeRegistry {
    private final Map<String, CProgram> documents = new LinkedHashMap<String, CProgram>();

    public boolean putDocument(String path, CProgram doc) {
        if (!this.documents.containsKey(path)) {
            this.documents.put(path, doc);
            return true;
        }
        return false;
    }

    public CProgram getDocument(String path) {
        return this.documents.get(path);
    }

    public CProgram getDocumentForPackage(String packageContext) {
        for (CProgram document : this.documents.values()) {
            if (!document.getProgramName().equals(packageContext)) continue;
            return document;
        }
        return null;
    }

    public PDescriptorProvider getProvider(String name, String context, Map<String, String> annotations) {
        String itemType;
        PPrimitive primitive = PPrimitive.findByName((String)(name = this.finalTypename(name, context)));
        if (primitive != null) {
            return primitive.provider();
        }
        if (annotations == null) {
            annotations = Collections.EMPTY_MAP;
        }
        if (name.startsWith("map<") && name.endsWith(">")) {
            String[] parts = name.substring(4, name.length() - 1).split(",", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException(name + " is not a valid map descriptor, wrong number of types.");
            }
            String keyType = parts[0];
            String valueType = parts[1];
            switch (ThriftCollection.forName((String)annotations.get(ThriftAnnotation.CONTAINER.tag))) {
                case SORTED: {
                    return PMap.sortedProvider((PDescriptorProvider)this.getProvider(keyType, context, null), (PDescriptorProvider)this.getProvider(valueType, context, null));
                }
                case ORDERED: {
                    return PMap.orderedProvider((PDescriptorProvider)this.getProvider(keyType, context, null), (PDescriptorProvider)this.getProvider(valueType, context, null));
                }
                case DEFAULT: {
                    return PMap.provider((PDescriptorProvider)this.getProvider(keyType, context, null), (PDescriptorProvider)this.getProvider(valueType, context, null));
                }
            }
        }
        if (name.startsWith("set<") && name.endsWith(">")) {
            itemType = name.substring(4, name.length() - 1);
            switch (ThriftCollection.forName((String)annotations.get(ThriftAnnotation.CONTAINER.tag))) {
                case SORTED: {
                    return PSet.sortedProvider((PDescriptorProvider)this.getProvider(itemType, context, null));
                }
                case ORDERED: {
                    return PSet.orderedProvider((PDescriptorProvider)this.getProvider(itemType, context, null));
                }
                case DEFAULT: {
                    return PSet.provider((PDescriptorProvider)this.getProvider(itemType, context, null));
                }
            }
        }
        if (name.startsWith("list<") && name.endsWith(">")) {
            itemType = name.substring(5, name.length() - 1);
            return PList.provider((PDescriptorProvider)this.getProvider(itemType, context, null));
        }
        if (!ThriftProgramParser.VALID_NAMESPACE.matcher(name).matches()) {
            throw new IllegalArgumentException(name + " is not a valid declared type identifier.");
        }
        String finalName = name;
        return () -> {
            PDeclaredDescriptor descriptor = this.getDeclaredType(finalName, context);
            if (descriptor == null) {
                throw new IllegalStateException("No such type " + finalName + " in context " + context);
            }
            return descriptor;
        };
    }

    public PServiceProvider getServiceProvider(String serviceName, String packageContext) {
        return () -> {
            PService service = this.getService(serviceName, packageContext);
            if (service == null) {
                throw new IllegalStateException("No such service " + serviceName + " in context " + packageContext);
            }
            return service;
        };
    }
}

