/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.morimekta.providence.model.ConstType;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.model.EnumType;
import net.morimekta.providence.model.EnumValue;
import net.morimekta.providence.model.FieldRequirement;
import net.morimekta.providence.model.FieldType;
import net.morimekta.providence.model.FunctionType;
import net.morimekta.providence.model.MessageType;
import net.morimekta.providence.model.MessageVariant;
import net.morimekta.providence.model.Model_Constants;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.model.ServiceType;
import net.morimekta.providence.model.TypedefType;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.ProgramParser;
import net.morimekta.providence.reflect.parser.internal.ThriftTokenizer;
import net.morimekta.providence.reflect.util.ReflectionUtils;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IOUtils;

public class ThriftProgramParser
implements ProgramParser {
    private static final Pattern RE_BLOCK_LINE = Pattern.compile("^([\\s]*[*])?[\\s]?");
    private static final Pattern VALID_PROGRAM_NAME = Pattern.compile("[-._a-zA-Z][-._a-zA-Z0-9]*");
    public static final Pattern VALID_NAMESPACE = Pattern.compile("([_a-zA-Z][_a-zA-Z0-9]*[.])*[_a-zA-Z][_a-zA-Z0-9]*");
    public static final Pattern VALID_SDI_NAMESPACE = Pattern.compile("([_a-zA-Z][-_a-zA-Z0-9]*[.])*[_a-zA-Z][-_a-zA-Z0-9]*");
    private final boolean requireFieldId;
    private final boolean requireEnumValue;

    public ThriftProgramParser() {
        this(false, false);
    }

    public ThriftProgramParser(boolean requireFieldId, boolean requireEnumValue) {
        this.requireFieldId = requireFieldId;
        this.requireEnumValue = requireEnumValue;
    }

    @Override
    public ProgramType parse(InputStream in, File file, Collection<File> includeDirs) throws IOException {
        Token token;
        ProgramType._Builder program = ProgramType.builder();
        String programName = ReflectionUtils.programNameFromPath(file.getName());
        if (!VALID_PROGRAM_NAME.matcher(programName).matches()) {
            throw new ParseException("Program name \"%s\" derived from filename \"%s\" is not valid.", Strings.escape((CharSequence)programName), Strings.escape((CharSequence)file.getName()));
        }
        program.setProgramName(programName);
        LinkedList<String> includeFiles = new LinkedList<String>();
        HashSet<String> includedPrograms = new HashSet<String>();
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        LinkedList<Declaration> declarations = new LinkedList<Declaration>();
        ThriftTokenizer tokenizer = new ThriftTokenizer(in);
        boolean hasHeader = false;
        boolean hasDeclaration = false;
        String documentation = null;
        block20: while ((token = tokenizer.next()) != null) {
            if (token.strEquals("//")) {
                documentation = this.parseDocLine(tokenizer, documentation);
                continue;
            }
            if (token.strEquals("/*")) {
                documentation = this.parseDocBlock(tokenizer);
                continue;
            }
            String id = token.asString();
            if (!Model_Constants.kThriftKeywords.contains(id)) {
                throw tokenizer.failure(token, "Unexpected token '%s'", new Object[]{token.asString()});
            }
            switch (id) {
                case "namespace": {
                    if (hasDeclaration) {
                        throw tokenizer.failure(token, "Unexpected token 'namespace', expected type declaration", new Object[0]);
                    }
                    if (documentation != null && !hasHeader) {
                        program.setDocumentation(documentation);
                    }
                    documentation = null;
                    hasHeader = true;
                    this.parseNamespace(tokenizer, namespaces);
                    continue block20;
                }
                case "include": {
                    if (hasDeclaration) {
                        throw tokenizer.failure(token, "Unexpected token 'include', expected type declaration", new Object[0]);
                    }
                    if (documentation != null && !hasHeader) {
                        program.setDocumentation(documentation);
                    }
                    documentation = null;
                    hasHeader = true;
                    this.parseIncludes(tokenizer, includeFiles, file, includedPrograms, includeDirs);
                    continue block20;
                }
                case "typedef": {
                    hasHeader = true;
                    hasDeclaration = true;
                    this.parseTypedef(tokenizer, documentation, declarations, includedPrograms);
                    documentation = null;
                    continue block20;
                }
                case "enum": {
                    hasHeader = true;
                    hasDeclaration = true;
                    EnumType et = this.parseEnum(tokenizer, documentation);
                    declarations.add(Declaration.withDeclEnum(et));
                    documentation = null;
                    continue block20;
                }
                case "struct": 
                case "union": 
                case "exception": {
                    hasHeader = true;
                    hasDeclaration = true;
                    MessageType st = this.parseMessage(tokenizer, token.asString(), documentation, includedPrograms);
                    declarations.add(Declaration.withDeclStruct(st));
                    documentation = null;
                    continue block20;
                }
                case "service": {
                    hasHeader = true;
                    hasDeclaration = true;
                    ServiceType srv = this.parseService(tokenizer, documentation, includedPrograms);
                    declarations.add(Declaration.withDeclService(srv));
                    documentation = null;
                    continue block20;
                }
                case "const": {
                    hasHeader = true;
                    hasDeclaration = true;
                    ConstType cnst = this.parseConst(tokenizer, documentation, includedPrograms);
                    declarations.add(Declaration.withDeclConst(cnst));
                    documentation = null;
                    continue block20;
                }
            }
            throw tokenizer.failure(token, "Unexpected token '%s'", new Object[]{Strings.escape((CharSequence)token.asString())});
        }
        if (namespaces.size() > 0) {
            program.setNamespaces(namespaces);
        }
        if (includeFiles.size() > 0) {
            program.setIncludes(includeFiles);
        }
        if (declarations.size() > 0) {
            program.setDecl(declarations);
        }
        return program.build();
    }

    private ConstType parseConst(ThriftTokenizer tokenizer, String comment, Set<String> includedPrograms) throws IOException, ParseException {
        Token token = tokenizer.expect("const typename", t -> t.isIdentifier() || t.isQualifiedIdentifier());
        String type = this.parseType(tokenizer, token, includedPrograms);
        Token id = tokenizer.expectIdentifier("const identifier");
        tokenizer.expectSymbol("const value separator", new char[]{'='});
        Token value = this.parseValue(tokenizer);
        Token sep = tokenizer.peek();
        if (sep != null && (sep.isSymbol(',') || sep.isSymbol(';'))) {
            tokenizer.next();
        }
        return ConstType.builder().setDocumentation(comment).setName(id.asString()).setType(type).setValue(value.asString()).setStartLineNo(value.getLineNo()).setStartLinePos(value.getLinePos()).build();
    }

    private Token parseValue(ThriftTokenizer tokenizer) throws IOException {
        Token token;
        Stack<Character> enclosures = new Stack<Character>();
        int startLineNo = 0;
        int startLinePos = 0;
        int offset = -1;
        while (true) {
            token = tokenizer.expect("const value");
            if (offset < 0) {
                offset = token.getOffset();
                startLineNo = token.getLineNo();
                startLinePos = token.getLinePos();
            }
            if (token.strEquals("/*")) {
                this.parseDocBlock(tokenizer);
                continue;
            }
            if (token.strEquals("//")) {
                this.parseDocLine(tokenizer, null);
                continue;
            }
            if (token.isSymbol('{')) {
                enclosures.push(Character.valueOf('}'));
            } else if (token.isSymbol('[')) {
                enclosures.push(Character.valueOf(']'));
            } else if ((token.isSymbol('}') || token.isSymbol(']')) && ((Character)enclosures.peek()).equals(Character.valueOf(token.charAt(0)))) {
                enclosures.pop();
            }
            if (enclosures.isEmpty()) break;
        }
        return tokenizer.token(offset, token.getOffset() - offset + token.length(), startLineNo, startLinePos);
    }

    private String parseDocLine(ThriftTokenizer tokenizer, String comment) throws IOException {
        String line = IOUtils.readString((InputStream)((Object)tokenizer), (String)"\n").trim();
        if (comment != null) {
            return comment + "\n" + line;
        }
        return line;
    }

    private String parseDocBlock(ThriftTokenizer tokenizer) throws IOException {
        String block = IOUtils.readString((InputStream)((Object)tokenizer), (String)"*/").trim();
        String[] lines = block.split("\\r?\\n");
        StringBuilder builder = new StringBuilder();
        Pattern re = RE_BLOCK_LINE;
        for (String line : lines) {
            builder.append(re.matcher(line).replaceFirst(""));
            builder.append('\n');
        }
        return builder.toString().trim();
    }

    private ServiceType parseService(ThriftTokenizer tokenizer, String comment, Set<String> includedPrograms) throws IOException, ParseException {
        String name;
        Token token;
        ServiceType._Builder service = ServiceType.builder();
        if (comment != null) {
            service.setDocumentation(comment);
            comment = null;
        }
        Token identifier = tokenizer.expectIdentifier("service identifier");
        service.setName(identifier.asString());
        if (tokenizer.peek("service start or extends").strEquals("extends")) {
            tokenizer.next();
            service.setExtend(tokenizer.expect("service extending identifier", t -> t.isIdentifier() || t.isQualifiedIdentifier()).asString());
        }
        tokenizer.expectSymbol("reading service start", new char[]{'{'});
        TreeSet<String> methodNames = new TreeSet<String>();
        while (!(token = tokenizer.expect("service method initializer")).isSymbol('}')) {
            String normalized;
            if (token.strEquals("//")) {
                comment = this.parseDocLine(tokenizer, comment);
                continue;
            }
            if (token.strEquals("/*")) {
                comment = this.parseDocBlock(tokenizer);
                continue;
            }
            FunctionType._Builder method = FunctionType.builder();
            if (comment != null) {
                method.setDocumentation(comment);
                comment = null;
            }
            if (token.strEquals("oneway")) {
                method.setOneWay(true);
                token = tokenizer.expect("service method type");
            }
            if (!token.strEquals("void")) {
                if (method.isSetOneWay()) {
                    throw tokenizer.failure(token, "Oneway methods must have void return type, found '%s'", new Object[]{Strings.escape((CharSequence)token.asString())});
                }
                method.setReturnType(this.parseType(tokenizer, token, includedPrograms));
            }
            if (methodNames.contains(normalized = Strings.camelCase((String)"", (String)(name = tokenizer.expectIdentifier("method name").asString())))) {
                throw tokenizer.failure(token, "Service method " + name + " has normalized name conflict", new Object[0]);
            }
            methodNames.add(normalized);
            method.setName(name);
            tokenizer.expectSymbol("method params begin", new char[]{'('});
            int nextAutoParamKey = -1;
            while (!(token = tokenizer.expect("method params")).isSymbol(')')) {
                if (token.strEquals("//")) {
                    comment = this.parseDocLine(tokenizer, comment);
                    continue;
                }
                if (token.strEquals("/*")) {
                    comment = this.parseDocBlock(tokenizer);
                    continue;
                }
                FieldType._Builder field = FieldType.builder();
                if (comment != null) {
                    field.setDocumentation(comment);
                    comment = null;
                }
                if (token.isInteger()) {
                    field.setKey((int)token.parseInteger());
                    tokenizer.expectSymbol("params kv sep", new char[]{':'});
                    token = tokenizer.expect("param type");
                } else {
                    if (this.requireFieldId) {
                        throw tokenizer.failure(token, "Missing param ID in strict declaration", new Object[0]);
                    }
                    field.setKey(nextAutoParamKey--);
                }
                field.setType(this.parseType(tokenizer, token, includedPrograms));
                field.setName(tokenizer.expectIdentifier("param name").asString());
                if (tokenizer.peek("method param annotation").isSymbol('(')) {
                    tokenizer.next();
                    int sep = 40;
                    while (sep != 41) {
                        token = tokenizer.expect("annotation name", t -> t.isIdentifier() || t.isQualifiedIdentifier());
                        name = token.asString();
                        tokenizer.expectSymbol("", new char[]{'='});
                        Token value = tokenizer.expectLiteral("annotation value");
                        field.putInAnnotations(name, value.decodeLiteral(true));
                        sep = tokenizer.expectSymbol("annotation sep", new char[]{')', ',', ';'});
                    }
                }
                if ((token = tokenizer.peek("method params")).isSymbol(',') || token.isSymbol(';')) {
                    tokenizer.next();
                }
                method.addToParams(field.build());
            }
            comment = null;
            if (tokenizer.peek("parsing method exceptions").strEquals("throws")) {
                tokenizer.next();
                tokenizer.expectSymbol("parsing method exceptions", new char[]{'('});
                int nextAutoExceptionKey = -1;
                while (!(token = tokenizer.expect("parsing method exception")).isSymbol(')')) {
                    if (token.strEquals("//")) {
                        comment = this.parseDocLine(tokenizer, comment);
                        continue;
                    }
                    if (token.strEquals("/*")) {
                        comment = this.parseDocBlock(tokenizer);
                        continue;
                    }
                    FieldType._Builder field = FieldType.builder();
                    if (comment != null) {
                        field.setDocumentation(comment);
                        comment = null;
                    }
                    if (token.isInteger()) {
                        field.setKey((int)token.parseInteger());
                        tokenizer.expectSymbol("reading method exception", new char[]{':'});
                        token = tokenizer.expect("reading method exception type");
                    } else {
                        if (this.requireFieldId) {
                            throw tokenizer.failure(token, "Missing exception ID in strict declaration", new Object[0]);
                        }
                        field.setKey(nextAutoExceptionKey--);
                    }
                    field.setType(this.parseType(tokenizer, token, includedPrograms));
                    field.setName(tokenizer.expectIdentifier("reading method exception name").asString());
                    if (tokenizer.peek("reading method exception annotation").isSymbol('(')) {
                        tokenizer.next();
                        int sep = 40;
                        while (sep != 41) {
                            token = tokenizer.expect("exception annotation name", t -> t.isIdentifier() || t.isQualifiedIdentifier());
                            name = token.asString();
                            tokenizer.expectSymbol("", new char[]{'='});
                            Token value = tokenizer.expectLiteral("exception annotation value");
                            field.putInAnnotations(name, value.decodeLiteral(true));
                            sep = tokenizer.expectSymbol("exception annotation sep", new char[]{')', ',', ';'});
                        }
                    }
                    method.addToExceptions(field.build());
                    token = tokenizer.peek("reading method exceptions");
                    if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
                    tokenizer.next();
                }
            }
            if ((token = tokenizer.peek("")).isSymbol('(')) {
                tokenizer.next();
                int sep = 40;
                while (sep != 41) {
                    token = tokenizer.expect("annotation name", Token::isReferenceIdentifier);
                    name = token.asString();
                    tokenizer.expectSymbol("", new char[]{'='});
                    Token value = tokenizer.expectLiteral("annotation value");
                    method.putInAnnotations(name, value.decodeLiteral(true));
                    sep = tokenizer.expectSymbol("annotation sep", new char[]{')', ',', ';'});
                }
                token = tokenizer.peek("reading method params");
            }
            service.addToMethods(method.build());
            if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
            tokenizer.next();
        }
        token = tokenizer.peek();
        if (token != null && token.isSymbol('(')) {
            tokenizer.next();
            int sep = 40;
            while (sep != 41) {
                token = tokenizer.expect("annotation name", Token::isReferenceIdentifier);
                name = token.asString();
                tokenizer.expectSymbol("", new char[]{'='});
                Token value = tokenizer.expectLiteral("annotation value");
                service.putInAnnotations(name, value.decodeLiteral(true));
                sep = tokenizer.expectSymbol("annotation sep", new char[]{')', ',', ';'});
            }
        }
        return service.build();
    }

    private void parseNamespace(ThriftTokenizer tokenizer, Map<String, String> namespaces) throws IOException {
        Token language = tokenizer.expect("namespace language", Token::isReferenceIdentifier);
        if (namespaces.containsKey(language.asString())) {
            throw tokenizer.failure(language, "Namespace for %s already defined.", new Object[]{language.asString()});
        }
        Token namespace = tokenizer.expect("parsing namespace", t -> VALID_NAMESPACE.matcher(t.asString()).matches() || VALID_SDI_NAMESPACE.matcher(t.asString()).matches());
        namespaces.put(language.asString(), namespace.asString());
    }

    private void parseIncludes(ThriftTokenizer tokenizer, List<String> includeFiles, File currentFile, Set<String> includePrograms, Collection<File> includeDirs) throws IOException {
        Token include = tokenizer.expectLiteral("include file");
        String filePath = include.decodeLiteral(true);
        if (!ReflectionUtils.isThriftFile(filePath)) {
            throw tokenizer.failure(include, "Include not valid for thrift files " + filePath, new Object[0]);
        }
        if (!this.includeExists(currentFile, filePath, includeDirs)) {
            throw tokenizer.failure(include, "Included file not found " + filePath, new Object[0]);
        }
        includeFiles.add(filePath);
        includePrograms.add(ReflectionUtils.programNameFromPath(filePath));
    }

    private boolean includeExists(File currentFile, String filePath, Collection<File> includeDirs) {
        File currentDir = currentFile.getParentFile();
        if (new File(currentDir, filePath).isFile()) {
            return true;
        }
        for (File I : includeDirs) {
            if (!new File(I, filePath).isFile()) continue;
            return true;
        }
        return false;
    }

    private void parseTypedef(ThriftTokenizer tokenizer, String comment, List<Declaration> declarations, Set<String> includedPrograms) throws IOException {
        String type = this.parseType(tokenizer, tokenizer.expect("parsing typedef type."), includedPrograms);
        Token id = tokenizer.expectIdentifier("parsing typedef identifier.");
        TypedefType typedef = TypedefType.builder().setDocumentation(comment).setType(type).setName(id.asString()).build();
        declarations.add(Declaration.withDeclTypedef(typedef));
    }

    private EnumType parseEnum(ThriftTokenizer tokenizer, String comment) throws IOException {
        Token token;
        String id = tokenizer.expectIdentifier("parsing enum identifier").asString();
        EnumType._Builder etb = EnumType.builder();
        if (comment != null) {
            etb.setDocumentation(comment);
            comment = null;
        }
        etb.setName(id);
        int nextValue = 0;
        tokenizer.expectSymbol("parsing enum " + id, new char[]{'{'});
        if (!tokenizer.peek("").isSymbol('}')) {
            while (!(token = tokenizer.expect("parsing enum " + id)).isSymbol('}')) {
                if (token.strEquals("//")) {
                    comment = this.parseDocLine(tokenizer, comment);
                    continue;
                }
                if (token.strEquals("/*")) {
                    comment = this.parseDocBlock(tokenizer);
                    continue;
                }
                if (token.isIdentifier()) {
                    EnumValue._Builder evb = EnumValue.builder();
                    evb.setName(token.asString());
                    if (comment != null) {
                        evb.setDocumentation(comment);
                        comment = null;
                    }
                    int value = nextValue++;
                    if (tokenizer.peek("parsing enum " + id).isSymbol('=')) {
                        tokenizer.next();
                        Token v = tokenizer.expectInteger("enum value");
                        value = (int)v.parseInteger();
                        nextValue = value + 1;
                    } else if (this.requireEnumValue) {
                        if (tokenizer.hasNext()) {
                            token = tokenizer.next();
                        }
                        throw tokenizer.failure(token, "Missing enum value in strict declaration", new Object[0]);
                    }
                    evb.setValue(value);
                    if (tokenizer.peek("parsing enum " + id).isSymbol('(')) {
                        tokenizer.next();
                        int sep2 = 40;
                        while (sep2 != 41) {
                            token = tokenizer.expect("annotation name", Token::isReferenceIdentifier);
                            String name = token.asString();
                            tokenizer.expectSymbol("", new char[]{'='});
                            Token val = tokenizer.expectLiteral("annotation value");
                            evb.putInAnnotations(name, val.decodeLiteral(true));
                            sep2 = tokenizer.expectSymbol("annotation sep", new char[]{')', ',', ';'});
                        }
                    }
                    etb.addToValues(evb.build());
                    token = tokenizer.peek("parsing enum " + id);
                    if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
                    tokenizer.next();
                    continue;
                }
                throw tokenizer.failure(token, "Unexpected token while parsing enum %d: %s", new Object[]{id, token.asString()});
            }
        }
        if ((token = tokenizer.peek()) != null && token.isSymbol('(')) {
            tokenizer.next();
            char sep = token.charAt(0);
            while (sep != ')') {
                token = tokenizer.expect("annotation name", Token::isReferenceIdentifier);
                String name = token.asString();
                tokenizer.expectSymbol("", new char[]{'='});
                Token val = tokenizer.expectLiteral("annotation value");
                etb.putInAnnotations(name, val.decodeLiteral(true));
                sep = tokenizer.expectSymbol("annotation sep", new char[]{')', ',', ';'});
            }
        }
        return etb.build();
    }

    private MessageType parseMessage(ThriftTokenizer tokenizer, String type, String comment, Set<String> includedPrograms) throws IOException {
        Token token;
        Token id;
        MessageType._Builder struct = MessageType.builder();
        if (comment != null) {
            struct.setDocumentation(comment);
            comment = null;
        }
        boolean union = type.equals("union");
        if (!type.equals("struct")) {
            struct.setVariant(MessageVariant.forName(type.toUpperCase()));
        }
        if (!(id = tokenizer.expectIdentifier("parsing " + type + " identifier")).isIdentifier()) {
            throw tokenizer.failure(id, "Invalid type identifier " + id.asString(), new Object[0]);
        }
        struct.setName(id.asString());
        int nextAutoFieldKey = -1;
        tokenizer.expectSymbol("struct start", new char[]{'{'});
        HashSet<String> fieldNames = new HashSet<String>();
        HashSet<String> fieldNameVariants = new HashSet<String>();
        HashSet<Integer> fieldIds = new HashSet<Integer>();
        while (!(token = tokenizer.expect("field def")).isSymbol('}')) {
            if (token.strEquals("//")) {
                comment = this.parseDocLine(tokenizer, comment);
                continue;
            }
            if (token.strEquals("/*")) {
                comment = this.parseDocBlock(tokenizer);
                continue;
            }
            FieldType._Builder field = FieldType.builder();
            field.setDocumentation(comment);
            comment = null;
            if (token.isInteger()) {
                int fId = (int)token.parseInteger();
                if (fId < 1) {
                    throw tokenizer.failure(token, "Negative field id " + fId + " not allowed.", new Object[0]);
                }
                if (fieldIds.contains(fId)) {
                    throw tokenizer.failure(token, "Field id " + fId + " already exists in struct " + struct.build().getName(), new Object[0]);
                }
                fieldIds.add(fId);
                field.setKey(fId);
                tokenizer.expectSymbol("field id sep", new char[]{':'});
                token = tokenizer.expect("field requirement or type", t -> t.isIdentifier() || t.isQualifiedIdentifier());
            } else {
                if (this.requireFieldId) {
                    throw tokenizer.failure(token, "Missing field ID in strict declaration", new Object[0]);
                }
                field.setKey(nextAutoFieldKey--);
            }
            if (token.strEquals("required")) {
                if (union) {
                    throw tokenizer.failure(token, "Found required field in union", new Object[0]);
                }
                field.setRequirement(FieldRequirement.REQUIRED);
                token = tokenizer.expect("field type", t -> t.isIdentifier() || t.isQualifiedIdentifier());
            } else if (token.strEquals("optional")) {
                if (!union) {
                    field.setRequirement(FieldRequirement.OPTIONAL);
                }
                token = tokenizer.expect("field type", t -> t.isIdentifier() || t.isQualifiedIdentifier());
            }
            field.setType(this.parseType(tokenizer, token, includedPrograms));
            Token name = tokenizer.expectIdentifier("parsing struct " + id.asString());
            String fName = name.asString();
            if (fieldNames.contains(fName)) {
                throw tokenizer.failure(name, "Field %s already exists in struct %s", new Object[]{fName, struct.build().getName()});
            }
            if (fieldNameVariants.contains(Strings.camelCase((String)"get", (String)fName))) {
                throw tokenizer.failure(name, "Field %s has field with conflicting name in %s", new Object[]{fName, struct.build().getName()});
            }
            fieldNames.add(fName);
            fieldNameVariants.add(Strings.camelCase((String)"get", (String)fName));
            field.setName(fName);
            token = tokenizer.peek("");
            if (token.isSymbol('=')) {
                tokenizer.next();
                Token defaultValue = this.parseValue(tokenizer);
                field.setDefaultValue(defaultValue.asString());
                field.setStartLineNo(defaultValue.getLineNo());
                field.setStartLinePos(defaultValue.getLinePos());
                token = tokenizer.peek("");
            }
            if (token.isSymbol('(')) {
                tokenizer.next();
                char sep = token.charAt(0);
                while (sep != ')') {
                    token = tokenizer.expect("annotation name", Token::isReferenceIdentifier);
                    String aName = token.asString();
                    tokenizer.expectSymbol("", new char[]{'='});
                    Token val = tokenizer.expectLiteral("annotation value");
                    field.putInAnnotations(aName, val.decodeLiteral(true));
                    sep = tokenizer.expectSymbol("annotation sep", new char[]{')', ',', ';'});
                }
                token = tokenizer.peek("");
            }
            struct.addToFields(field.build());
            if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
            tokenizer.next();
        }
        token = tokenizer.peek();
        if (token != null && token.isSymbol('(')) {
            tokenizer.next();
            char sep = token.charAt(0);
            while (sep != ')') {
                token = tokenizer.expect("annotation name", Token::isReferenceIdentifier);
                String annotationKey = token.asString();
                sep = tokenizer.expectSymbol("annotation value sep", new char[]{'=', ')', ',', ';'});
                if (sep != '=') {
                    struct.putInAnnotations(annotationKey, "");
                    continue;
                }
                Token annotationValue = tokenizer.expectLiteral("annotation value");
                struct.putInAnnotations(annotationKey, annotationValue.decodeLiteral(true));
                sep = tokenizer.expectSymbol("annotation sep", new char[]{')', ',', ';'});
            }
        }
        return struct.build();
    }

    private String parseType(ThriftTokenizer tokenizer, Token token, Set<String> includedPrograms) throws IOException {
        String program;
        String type;
        if (!token.isQualifiedIdentifier() && !token.isIdentifier()) {
            throw tokenizer.failure(token, "Expected type identifier but found " + token, new Object[0]);
        }
        switch (type = token.asString()) {
            case "list": 
            case "set": {
                tokenizer.expectSymbol("parsing " + type + " item type", new char[]{'<'});
                String item = this.parseType(tokenizer, tokenizer.expect("parsing " + type + " item type", t -> t.isIdentifier() || t.isQualifiedIdentifier()), includedPrograms);
                tokenizer.expectSymbol("parsing " + type + " item type", new char[]{'>'});
                return String.format("%s<%s>", type, item);
            }
            case "map": {
                tokenizer.expectSymbol("parsing " + type + " item type", new char[]{'<'});
                String key = this.parseType(tokenizer, tokenizer.expect("parsing " + type + " key type", t -> t.isIdentifier() || t.isQualifiedIdentifier()), includedPrograms);
                tokenizer.expectSymbol("parsing " + type + " item type", new char[]{','});
                String item = this.parseType(tokenizer, tokenizer.expect("parsing " + type + " item type", t -> t.isIdentifier() || t.isQualifiedIdentifier()), includedPrograms);
                tokenizer.expectSymbol("parsing " + type + " item type", new char[]{'>'});
                return String.format("%s<%s,%s>", type, key, item);
            }
        }
        if (type.contains(".") && !includedPrograms.contains(program = type.replaceAll("[.].*", ""))) {
            throw tokenizer.failure(token, "Unknown program %s for type %s", new Object[]{program, type});
        }
        return type;
    }
}

