/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CStruct;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;

public class CUnion
implements PUnion<CUnion, CField> {
    private final CUnionDescriptor descriptor;
    private final CField unionField;
    private final Object unionValue;

    private CUnion(Builder builder) {
        this.unionField = builder.unionField;
        this.descriptor = builder.descriptor;
        this.unionValue = builder.currentValue instanceof PMessageBuilder ? ((PMessageBuilder)builder.currentValue).build() : (builder.currentValue instanceof PMap.Builder ? ((PMap.Builder)builder.currentValue).build() : (builder.currentValue instanceof PList.Builder ? ((PList.Builder)builder.currentValue).build() : (builder.currentValue instanceof PSet.Builder ? ((PSet.Builder)builder.currentValue).build() : builder.currentValue)));
    }

    public boolean has(int key) {
        return this.unionField != null && this.unionField.getKey() == key && this.unionValue != null;
    }

    public int num(int key) {
        if (!this.has(key)) {
            return 0;
        }
        switch (this.unionField.getType()) {
            case MAP: {
                return ((Map)this.unionValue).size();
            }
            case LIST: 
            case SET: {
                return ((Collection)this.unionValue).size();
            }
        }
        return 0;
    }

    public Object get(int key) {
        return this.has(key) ? this.unionValue : null;
    }

    @Nonnull
    public PMessageBuilder<CUnion, CField> mutate() {
        return new Builder(this.descriptor).merge(this);
    }

    @Nonnull
    public String asString() {
        return CStruct.asString(this);
    }

    @Nonnull
    public CUnionDescriptor descriptor() {
        return this.descriptor;
    }

    @Nonnull
    public CField unionField() {
        return this.unionField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CUnion)) {
            return false;
        }
        CUnion other = (CUnion)o;
        return Objects.equals(this.descriptor, other.descriptor) && Objects.equals(this.unionField, other.unionField) && Objects.equals(this.unionValue, other.unionValue);
    }

    public int hashCode() {
        return Objects.hash(this.descriptor().getQualifiedName(), this.unionField, this.unionValue);
    }

    public int compareTo(@Nonnull CUnion other) {
        return CStruct.compareMessages(this, other);
    }

    public static class Builder
    extends PMessageBuilder<CUnion, CField> {
        private final CUnionDescriptor descriptor;
        private CField unionField;
        private Object currentValue;

        public Builder(CUnionDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Nonnull
        public PMessageBuilder mutator(int key) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                throw new IllegalArgumentException("No such field ID " + key);
            }
            if (field.getType() != PType.MESSAGE) {
                throw new IllegalArgumentException("Not a message field ID " + key + ": " + field.getName());
            }
            if (this.unionField != field) {
                this.unionField = field;
                this.currentValue = null;
            }
            if (this.currentValue == null) {
                this.currentValue = ((PMessageDescriptor)field.getDescriptor()).builder();
            } else if (this.currentValue instanceof PMessage) {
                this.currentValue = ((PMessage)this.currentValue).mutate();
            } else if (!(this.currentValue instanceof PMessageBuilder)) {
                throw new IllegalArgumentException("Invalid currentValue in map on message type: " + this.currentValue.getClass().getSimpleName());
            }
            return (PMessageBuilder)this.currentValue;
        }

        @Nonnull
        public Builder merge(CUnion from) {
            if (this.unionField == null || this.unionField != from.unionField()) {
                this.set(from.unionField.getKey(), from.get(from.unionField.getKey()));
            } else {
                int key = this.unionField.getKey();
                switch (this.unionField.getType()) {
                    case MESSAGE: {
                        PMessageBuilder src = this.currentValue instanceof PMessageBuilder ? (PMessageBuilder)this.currentValue : ((PMessage)this.currentValue).mutate();
                        PMessage toMerge = (PMessage)from.get(key);
                        this.currentValue = src.merge(toMerge);
                        break;
                    }
                    case SET: {
                        ((PSet.Builder)this.currentValue).addAll((Collection)from.get(key));
                        break;
                    }
                    case MAP: {
                        ((PMap.Builder)this.currentValue).putAll((Map)from.get(key));
                        break;
                    }
                    default: {
                        this.set(key, from.get(key));
                    }
                }
            }
            return this;
        }

        @Nonnull
        public PUnionDescriptor<CUnion, CField> descriptor() {
            return this.descriptor;
        }

        @Nonnull
        public CUnion build() {
            return new CUnion(this);
        }

        public boolean valid() {
            return this.unionField != null && this.currentValue != null;
        }

        public void validate() {
            if (!this.valid()) {
                throw new IllegalStateException("No union field set in " + this.descriptor().getQualifiedName());
            }
        }

        @Nonnull
        public Builder set(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (value == null) {
                return this.clear(key);
            }
            this.unionField = field;
            switch (field.getType()) {
                case SET: {
                    this.currentValue = ((PSet)field.getDescriptor()).builder().addAll((Collection)value);
                    break;
                }
                case LIST: {
                    this.currentValue = ((PList)field.getDescriptor()).builder().addAll((Collection)value);
                    break;
                }
                case MAP: {
                    this.currentValue = ((PMap)field.getDescriptor()).builder().putAll((Map)value);
                    break;
                }
                default: {
                    this.currentValue = value;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            return this.unionField != null && this.unionField.getKey() == key;
        }

        public boolean isModified(int key) {
            return false;
        }

        @Nonnull
        public Builder addTo(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (field.getType() != PType.LIST && field.getType() != PType.SET) {
                throw new IllegalArgumentException("Unable to accept addTo on non-list field " + field.getName());
            }
            if (value == null) {
                throw new IllegalArgumentException("Adding null item to collection " + field.getName());
            }
            if (this.unionField != field || this.currentValue == null) {
                this.unionField = field;
                switch (field.getType()) {
                    case LIST: {
                        this.currentValue = ((PList)field.getDescriptor()).builder();
                        break;
                    }
                    case SET: {
                        this.currentValue = ((PSet)field.getDescriptor()).builder();
                        break;
                    }
                }
            }
            switch (field.getType()) {
                case LIST: {
                    ((PList.Builder)this.currentValue).add(value);
                    break;
                }
                case SET: {
                    ((PList.Builder)this.currentValue).add(value);
                    break;
                }
            }
            return this;
        }

        @Nonnull
        public Builder clear(int key) {
            if (this.isSet(key)) {
                this.unionField = null;
                this.currentValue = null;
            }
            return this;
        }
    }
}

