/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.reflect.contained.CField;

public abstract class CMessageBuilder<Builder extends CMessageBuilder<Builder, Message>, Message extends PMessage<Message, CField>>
extends PMessageBuilder<Message, CField> {
    private final Map<Integer, Object> values = new TreeMap<Integer, Object>();
    private final Set<Integer> modified = new TreeSet<Integer>();

    @Nonnull
    public Builder merge(Message from) {
        for (CField field : (CField[])this.descriptor().getFields()) {
            int key = field.getKey();
            if (!from.has(key)) continue;
            switch (field.getType()) {
                case MESSAGE: {
                    if (this.values.containsKey(key)) {
                        this.mutator(key).merge((PMessage)from.get(key));
                        break;
                    }
                    this.set(key, from.get(key));
                    break;
                }
                case SET: {
                    if (this.values.containsKey(key)) {
                        ((PSet.Builder)this.values.get(key)).addAll((Collection)from.get(key));
                        break;
                    }
                    this.set(key, from.get(key));
                    break;
                }
                case MAP: {
                    if (this.values.containsKey(key)) {
                        ((PMap.Builder)this.values.get(key)).putAll((Map)from.get(key));
                        break;
                    }
                    this.set(key, from.get(key));
                    break;
                }
                default: {
                    this.set(key, from.get(key));
                }
            }
            this.modified.add(key);
        }
        return (Builder)((Object)this);
    }

    @Nonnull
    public PMessageBuilder mutator(int key) {
        CField field = (CField)this.descriptor().getField(key);
        if (field == null) {
            throw new IllegalArgumentException("No such field ID " + key);
        }
        if (field.getType() != PType.MESSAGE) {
            throw new IllegalArgumentException("Not a message field ID " + key + ": " + field.getName());
        }
        Object current = this.values.get(key);
        if (current == null) {
            current = ((PMessageDescriptor)field.getDescriptor()).builder();
            this.values.put(key, current);
        } else if (current instanceof PMessage) {
            current = ((PMessage)current).mutate();
            this.values.put(key, current);
        } else if (!(current instanceof PMessageBuilder)) {
            throw new IllegalArgumentException("Invalid value in map on message type: " + current.getClass().getSimpleName());
        }
        this.modified.add(key);
        return (PMessageBuilder)current;
    }

    public boolean valid() {
        for (CField field : (CField[])this.descriptor().getFields()) {
            if (field.getRequirement() != PRequirement.REQUIRED || this.values.containsKey(field.getKey())) continue;
            return false;
        }
        return true;
    }

    public void validate() {
        LinkedList<String> missing = new LinkedList<String>();
        for (CField field : (CField[])this.descriptor().getFields()) {
            if (field.getRequirement() != PRequirement.REQUIRED || this.values.containsKey(field.getKey())) continue;
            missing.add(field.getName());
        }
        if (missing.size() > 0) {
            throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message " + this.descriptor().getQualifiedName());
        }
    }

    @Nonnull
    public Builder set(int key, Object value) {
        PField field = this.descriptor().getField(key);
        if (field == null) {
            return (Builder)((Object)this);
        }
        if (value == null) {
            this.values.remove(key);
        } else {
            switch (field.getType()) {
                case LIST: {
                    PList.Builder builder = ((PList)field.getDescriptor()).builder();
                    builder.addAll((Collection)value);
                    this.values.put(key, builder);
                    break;
                }
                case SET: {
                    PSet.Builder builder = ((PSet)field.getDescriptor()).builder();
                    builder.addAll((Collection)value);
                    this.values.put(key, builder);
                    break;
                }
                case MAP: {
                    PMap.Builder builder = ((PMap)field.getDescriptor()).builder();
                    builder.putAll((Map)value);
                    this.values.put(key, builder);
                    break;
                }
                default: {
                    this.values.put(key, value);
                }
            }
        }
        this.modified.add(key);
        return (Builder)((Object)this);
    }

    public boolean isSet(int key) {
        return this.values.containsKey(key);
    }

    public boolean isModified(int key) {
        return this.modified.contains(key);
    }

    @Nonnull
    public Builder addTo(int key, Object value) {
        PField field = this.descriptor().getField(key);
        if (field == null) {
            return (Builder)((Object)this);
        }
        if (value == null) {
            throw new IllegalArgumentException("Adding null value");
        }
        if (field.getType() == PType.LIST) {
            PList.Builder list = (PList.Builder)this.values.get(field.getKey());
            if (list == null) {
                list = ((PList)field.getDescriptor()).builder();
                this.values.put(field.getKey(), list);
            }
            list.add(value);
        } else if (field.getType() == PType.SET) {
            PSet.Builder set = (PSet.Builder)this.values.get(field.getKey());
            if (set == null) {
                set = ((PSet)field.getDescriptor()).builder();
                this.values.put(field.getKey(), set);
            }
            set.add(value);
        } else {
            throw new IllegalArgumentException("Key " + key + " is not a collection: " + field.getType());
        }
        this.modified.add(key);
        return (Builder)((Object)this);
    }

    @Nonnull
    public Builder clear(int key) {
        this.values.remove(key);
        this.modified.add(key);
        return (Builder)((Object)this);
    }

    Map<Integer, Object> getValueMap() {
        ImmutableMap.Builder out = ImmutableMap.builder();
        for (CField field : (CField[])this.descriptor().getFields()) {
            int key = field.getKey();
            if (this.values.containsKey(key)) {
                switch (field.getType()) {
                    case SET: {
                        out.put((Object)key, (Object)((PSet.Builder)this.values.get(key)).build());
                        break;
                    }
                    case LIST: {
                        out.put((Object)key, (Object)((PList.Builder)this.values.get(key)).build());
                        break;
                    }
                    case MAP: {
                        out.put((Object)key, (Object)((PMap.Builder)this.values.get(key)).build());
                        break;
                    }
                    case MESSAGE: {
                        Object current = this.values.get(key);
                        if (current instanceof PMessageBuilder) {
                            out.put((Object)key, ((PMessageBuilder)current).build());
                            break;
                        }
                        out.put((Object)key, current);
                        break;
                    }
                    default: {
                        out.put((Object)key, this.values.get(key));
                        break;
                    }
                }
                continue;
            }
            if (field.getRequirement() == PRequirement.OPTIONAL) continue;
            if (field.hasDefaultValue()) {
                out.put((Object)key, field.getDefaultValue());
                continue;
            }
            if (field.getDescriptor().getDefaultValue() == null) continue;
            out.put((Object)key, field.getDescriptor().getDefaultValue());
        }
        return out.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("values", this.values).add("modified", this.modified).toString();
    }
}

