/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.EnumValue;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.rw.BinaryFormatUtils;
import net.morimekta.providence.serializer.rw.BinaryReader;
import net.morimekta.providence.serializer.rw.BinaryType;
import net.morimekta.providence.serializer.rw.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

public class EnumType
implements PMessage<EnumType, _Field>,
Comparable<EnumType>,
Serializable,
BinaryWriter {
    private static final long serialVersionUID = 5720337451968926862L;
    private static final String kDefaultName = "";
    private static final List<EnumValue> kDefaultValues = new PList.ImmutableListBuilder().build();
    private final String mDocumentation;
    private final String mName;
    private final List<EnumValue> mValues;
    private final Map<String, String> mAnnotations;
    private volatile int tHashCode;
    public static final PStructDescriptor<EnumType, _Field> kDescriptor = new _Descriptor();

    public EnumType(String pDocumentation, String pName, List<EnumValue> pValues, Map<String, String> pAnnotations) {
        this.mDocumentation = pDocumentation;
        this.mName = pName != null ? pName : kDefaultName;
        this.mValues = pValues != null ? ImmutableList.copyOf(pValues) : kDefaultValues;
        this.mAnnotations = pAnnotations != null ? ImmutableMap.copyOf(pAnnotations) : null;
    }

    private EnumType(_Builder builder) {
        this.mDocumentation = builder.mDocumentation;
        this.mName = builder.isSetName() ? builder.mName : kDefaultName;
        this.mValues = builder.isSetValues() ? builder.mValues.build() : kDefaultValues;
        this.mAnnotations = builder.isSetAnnotations() ? builder.mAnnotations.build() : null;
    }

    public boolean hasDocumentation() {
        return this.mDocumentation != null;
    }

    public String getDocumentation() {
        return this.mDocumentation;
    }

    public boolean hasName() {
        return true;
    }

    public String getName() {
        return this.mName;
    }

    public int numValues() {
        return this.mValues != null ? this.mValues.size() : 0;
    }

    public boolean hasValues() {
        return true;
    }

    public List<EnumValue> getValues() {
        return this.mValues;
    }

    public int numAnnotations() {
        return this.mAnnotations != null ? this.mAnnotations.size() : 0;
    }

    public boolean hasAnnotations() {
        return this.mAnnotations != null;
    }

    public Map<String, String> getAnnotations() {
        return this.mAnnotations;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasDocumentation();
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return this.hasAnnotations();
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasDocumentation() ? 1 : 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return this.numValues();
            }
            case 4: {
                return this.numAnnotations();
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getDocumentation();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getValues();
            }
            case 4: {
                return this.getAnnotations();
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        EnumType other = (EnumType)o;
        return Objects.equals(this.mDocumentation, other.mDocumentation) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mValues, other.mValues) && Objects.equals(this.mAnnotations, other.mAnnotations);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{EnumType.class, _Field.DOCUMENTATION, this.mDocumentation, _Field.NAME, this.mName, _Field.VALUES, this.mValues, _Field.ANNOTATIONS, this.mAnnotations});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.EnumType" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasDocumentation()) {
            first = false;
            out.append("documentation:").append('\"').append(Strings.escape((CharSequence)this.mDocumentation)).append('\"');
        }
        if (!first) {
            out.append(',');
        }
        out.append("name:").append('\"').append(Strings.escape((CharSequence)this.mName)).append('\"');
        out.append(',');
        out.append("values:").append(Strings.asString(this.mValues));
        if (this.hasAnnotations()) {
            out.append(',');
            out.append("annotations:").append(Strings.asString(this.mAnnotations));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(EnumType other) {
        int c = Boolean.compare(this.mDocumentation != null, other.mDocumentation != null);
        if (c != 0) {
            return c;
        }
        if (this.mDocumentation != null && (c = this.mDocumentation.compareTo(other.mDocumentation)) != 0) {
            return c;
        }
        c = this.mName.compareTo(other.mName);
        if (c != 0) {
            return c;
        }
        c = Integer.compare(this.mValues.hashCode(), other.mValues.hashCode());
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mAnnotations != null, other.mAnnotations != null);
        if (c != 0) {
            return c;
        }
        if (this.mAnnotations != null && (c = Integer.compare(this.mAnnotations.hashCode(), other.mAnnotations.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        if (this.hasDocumentation()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)1);
            Binary tmp_1 = Binary.wrap((byte[])this.mDocumentation.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_1.length());
            length += writer.writeBinary(tmp_1);
        }
        length += writer.writeByte((byte)11);
        length += writer.writeShort((short)2);
        Binary tmp_2 = Binary.wrap((byte[])this.mName.getBytes(StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_2.length());
        length += writer.writeBinary(tmp_2);
        length += writer.writeByte((byte)15);
        length += writer.writeShort((short)3);
        length += writer.writeByte((byte)12);
        length += writer.writeUInt32(this.mValues.size());
        for (EnumValue enumValue : this.mValues) {
            length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessage)enumValue);
        }
        if (this.hasAnnotations()) {
            length += writer.writeByte((byte)13);
            length += writer.writeShort((short)4);
            length += writer.writeByte((byte)11);
            length += writer.writeByte((byte)11);
            length += writer.writeUInt32(this.mAnnotations.size());
            for (Map.Entry entry : this.mAnnotations.entrySet()) {
                Binary tmp_5 = Binary.wrap((byte[])((String)entry.getKey()).getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_5.length());
                length += writer.writeBinary(tmp_5);
                Binary tmp_6 = Binary.wrap((byte[])((String)entry.getValue()).getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_6.length());
                length += writer.writeBinary(tmp_6);
            }
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static PStructDescriptorProvider<EnumType, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<EnumType, _Field> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<EnumType, _Field>
    implements BinaryReader {
        private BitSet optionals = new BitSet(4);
        private BitSet modified = new BitSet(4);
        private String mDocumentation;
        private String mName = "";
        private PList.Builder<EnumValue> mValues = new PList.ImmutableListBuilder();
        private PMap.Builder<String, String> mAnnotations = new PMap.ImmutableMapBuilder();

        public _Builder() {
        }

        public _Builder(EnumType base) {
            this();
            if (base.hasDocumentation()) {
                this.optionals.set(0);
                this.mDocumentation = base.mDocumentation;
            }
            this.optionals.set(1);
            this.mName = base.mName;
            this.optionals.set(2);
            this.mValues.addAll((Collection)base.mValues);
            if (base.hasAnnotations()) {
                this.optionals.set(3);
                this.mAnnotations.putAll(base.mAnnotations);
            }
        }

        @Nonnull
        public _Builder merge(EnumType from) {
            if (from.hasDocumentation()) {
                this.optionals.set(0);
                this.modified.set(0);
                this.mDocumentation = from.getDocumentation();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mName = from.getName();
            this.optionals.set(2);
            this.modified.set(2);
            this.mValues.clear();
            this.mValues.addAll(from.getValues());
            if (from.hasAnnotations()) {
                this.optionals.set(3);
                this.modified.set(3);
                this.mAnnotations.putAll(from.getAnnotations());
            }
            return this;
        }

        @Nonnull
        public _Builder setDocumentation(String value) {
            if (value == null) {
                return this.clearDocumentation();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mDocumentation = value;
            return this;
        }

        public boolean isSetDocumentation() {
            return this.optionals.get(0);
        }

        public boolean isModifiedDocumentation() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearDocumentation() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mDocumentation = null;
            return this;
        }

        public String getDocumentation() {
            return this.mDocumentation;
        }

        @Nonnull
        public _Builder setName(String value) {
            if (value == null) {
                return this.clearName();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(1);
        }

        public boolean isModifiedName() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearName() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mName = EnumType.kDefaultName;
            return this;
        }

        public String getName() {
            return this.mName;
        }

        @Nonnull
        public _Builder setValues(Collection<EnumValue> value) {
            if (value == null) {
                return this.clearValues();
            }
            this.optionals.set(2);
            this.modified.set(2);
            this.mValues.clear();
            this.mValues.addAll(value);
            return this;
        }

        @Nonnull
        public _Builder addToValues(EnumValue ... values) {
            this.optionals.set(2);
            this.modified.set(2);
            for (EnumValue item : values) {
                this.mValues.add((Object)item);
            }
            return this;
        }

        public boolean isSetValues() {
            return this.optionals.get(2);
        }

        public boolean isModifiedValues() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearValues() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mValues.clear();
            return this;
        }

        public PList.Builder<EnumValue> mutableValues() {
            this.optionals.set(2);
            this.modified.set(2);
            return this.mValues;
        }

        @Nonnull
        public _Builder setAnnotations(Map<String, String> value) {
            if (value == null) {
                return this.clearAnnotations();
            }
            this.optionals.set(3);
            this.modified.set(3);
            this.mAnnotations.clear();
            this.mAnnotations.putAll(value);
            return this;
        }

        @Nonnull
        public _Builder putInAnnotations(String key, String value) {
            this.optionals.set(3);
            this.modified.set(3);
            this.mAnnotations.put((Object)key, (Object)value);
            return this;
        }

        public boolean isSetAnnotations() {
            return this.optionals.get(3);
        }

        public boolean isModifiedAnnotations() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearAnnotations() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mAnnotations.clear();
            return this;
        }

        public PMap.Builder<String, String> mutableAnnotations() {
            this.optionals.set(3);
            this.modified.set(3);
            return this.mAnnotations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
                return false;
            }
            _Builder other = (_Builder)((Object)o);
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mDocumentation, other.mDocumentation) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mValues, other.mValues) && Objects.equals(this.mAnnotations, other.mAnnotations);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{EnumType.class, this.optionals, _Field.DOCUMENTATION, this.mDocumentation, _Field.NAME, this.mName, _Field.VALUES, this.mValues, _Field.ANNOTATIONS, this.mAnnotations});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                default: 
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setDocumentation((String)value);
                    break;
                }
                case 2: {
                    this.setName((String)value);
                    break;
                }
                case 3: {
                    this.setValues((List)value);
                    break;
                }
                case 4: {
                    this.setAnnotations((Map)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 3: {
                    return this.optionals.get(2);
                }
                case 4: {
                    return this.optionals.get(3);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 3: {
                    return this.modified.get(2);
                }
                case 4: {
                    return this.modified.get(3);
                }
            }
            return false;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 3: {
                    this.addToValues((EnumValue)value);
                    break;
                }
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearDocumentation();
                    break;
                }
                case 2: {
                    this.clearName();
                    break;
                }
                case 3: {
                    this.clearValues();
                    break;
                }
                case 4: {
                    this.clearAnnotations();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return this.optionals.get(1);
        }

        public void validate() {
            if (!this.valid()) {
                LinkedList<String> missing = new LinkedList<String>();
                if (!this.optionals.get(1)) {
                    missing.add("name");
                }
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message model.EnumType");
            }
        }

        @Nonnull
        public PStructDescriptor<EnumType, _Field> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mDocumentation = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.EnumType.documentation, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            this.mName = new String(reader.expectBytes(len_2), StandardCharsets.UTF_8);
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.EnumType.name, should be struct(12)", new Object[0]);
                    }
                    case 3: {
                        if (type == 15) {
                            byte t_4 = reader.expectByte();
                            if (t_4 == 12) {
                                int len_3 = reader.expectUInt32();
                                for (int i_5 = 0; i_5 < len_3; ++i_5) {
                                    EnumValue key_6 = (EnumValue)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, EnumValue.kDescriptor, (boolean)strict);
                                    this.mValues.add((Object)key_6);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_4) + " for model.EnumType.values, should be struct(12)", new Object[0]);
                            }
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.EnumType.values, should be struct(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 13) {
                            byte t_8 = reader.expectByte();
                            byte t_9 = reader.expectByte();
                            if (t_8 == 11 && t_9 == 11) {
                                int len_7 = reader.expectUInt32();
                                for (int i_10 = 0; i_10 < len_7; ++i_10) {
                                    int len_13 = reader.expectUInt32();
                                    String key_11 = new String(reader.expectBytes(len_13), StandardCharsets.UTF_8);
                                    int len_14 = reader.expectUInt32();
                                    String val_12 = new String(reader.expectBytes(len_14), StandardCharsets.UTF_8);
                                    this.mAnnotations.put((Object)key_11, (Object)val_12);
                                }
                            } else {
                                throw new SerializerException("Wrong key type " + BinaryType.asString((byte)t_8) + " or value type " + BinaryType.asString((byte)t_9) + " for model.EnumType.annotations, should be string(11) and string(11)", new Object[0]);
                            }
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.EnumType.annotations, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        public EnumType build() {
            return new EnumType(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<EnumType, _Field> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<EnumType, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<EnumType, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<EnumType, _Field> {
        public _Descriptor() {
            super("model", "EnumType", (PMessageBuilderFactory)new _Factory(), false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        DOCUMENTATION(1, PRequirement.OPTIONAL, "documentation", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        NAME(2, PRequirement.REQUIRED, "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        VALUES(3, PRequirement.DEFAULT, "values", (PDescriptorProvider)PList.provider(EnumValue.provider()), null),
        ANNOTATIONS(4, PRequirement.OPTIONAL, "annotations", (PDescriptorProvider)PMap.provider((PDescriptorProvider)PPrimitive.STRING.provider(), (PDescriptorProvider)PPrimitive.STRING.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return DOCUMENTATION;
                }
                case 2: {
                    return NAME;
                }
                case 3: {
                    return VALUES;
                }
                case 4: {
                    return ANNOTATIONS;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "documentation": {
                    return DOCUMENTATION;
                }
                case "name": {
                    return NAME;
                }
                case "values": {
                    return VALUES;
                }
                case "annotations": {
                    return ANNOTATIONS;
                }
            }
            return null;
        }
    }
}

