/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser;

import java.io.IOException;
import net.morimekta.providence.reflect.parser.internal.Token;
import net.morimekta.providence.reflect.parser.internal.Tokenizer;
import net.morimekta.util.Stringable;
import net.morimekta.util.Strings;

public class ParseException
extends Exception
implements Stringable {
    private final String line;
    private final Token token;

    public ParseException(Throwable cause, String message, Object ... params) {
        super(String.format(message, params), cause);
        this.line = null;
        this.token = null;
    }

    public ParseException(String message, Object ... params) {
        super(String.format(message, params));
        this.line = null;
        this.token = null;
    }

    public ParseException(Tokenizer tokenizer, Token token, String message, Object ... params) {
        super(String.format(message, params));
        String line = null;
        try {
            line = tokenizer.getLine(token.getLineNo());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.line = line;
        this.token = token;
    }

    public Token getToken() {
        return this.token;
    }

    public String getLine() {
        return this.line;
    }

    public String asString() {
        if (this.line != null && this.token != null) {
            return String.format("Parse error on line %d, pos %d: %s%n%s%n%s^", this.token.getLineNo(), this.token.getLinePos(), this.getLocalizedMessage(), this.line, Strings.times((String)"-", (int)this.token.getLinePos()));
        }
        return String.format("Parse error: %s", this.getLocalizedMessage());
    }

    @Override
    public String toString() {
        if (this.line != null && this.token != null) {
            return String.format("ParseException(\"%s\",%d:%d,\"%s\")", Strings.escape((CharSequence)this.getLocalizedMessage()), this.token.getLineNo(), this.token.getLinePos(), Strings.escape((CharSequence)this.line));
        }
        return String.format("ParseException(\"%s\")", Strings.escape((CharSequence)this.getLocalizedMessage()));
    }
}

