/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CServiceMethod;

public class CService
extends PService
implements CAnnotatedDescriptor {
    private final Map<String, String> annotations;
    private String comment;

    public CService(String comment, String packageName, String name, PServiceProvider extendsService, Collection<CServiceMethod> methods, Map<String, String> annotations) {
        super(packageName, name, extendsService, methods);
        this.comment = comment;
        this.annotations = annotations;
    }

    @Nonnull
    public Collection<CServiceMethod> getMethods() {
        return super.getMethods();
    }

    public CServiceMethod getMethod(String name) {
        for (CServiceMethod method : this.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        if (this.getExtendsService() != null) {
            return this.getExtendsService().getMethod(name);
        }
        return null;
    }

    public CService getExtendsService() {
        return (CService)super.getExtendsService();
    }

    @Override
    @Nonnull
    public Set<String> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAnnotation(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.get(name);
        }
        return null;
    }

    @Override
    public String getDocumentation() {
        return this.comment;
    }
}

