/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.FieldRequirement;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.rw.BinaryFormatUtils;
import net.morimekta.providence.serializer.rw.BinaryReader;
import net.morimekta.providence.serializer.rw.BinaryType;
import net.morimekta.providence.serializer.rw.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

public class FieldType
implements PMessage<FieldType, _Field>,
Comparable<FieldType>,
Serializable,
BinaryWriter {
    private static final long serialVersionUID = -5885640707344801505L;
    private static final int kDefaultKey = 0;
    private static final FieldRequirement kDefaultRequirement = FieldRequirement.DEFAULT;
    private final String mDocumentation;
    private final int mKey;
    private final FieldRequirement mRequirement;
    private final String mType;
    private final String mName;
    private final String mDefaultValue;
    private final Map<String, String> mAnnotations;
    private volatile int tHashCode;
    public static final PStructDescriptor<FieldType, _Field> kDescriptor = new _Descriptor();

    public FieldType(String pDocumentation, int pKey, FieldRequirement pRequirement, String pType, String pName, String pDefaultValue, Map<String, String> pAnnotations) {
        this.mDocumentation = pDocumentation;
        this.mKey = pKey;
        this.mRequirement = pRequirement;
        this.mType = pType;
        this.mName = pName;
        this.mDefaultValue = pDefaultValue;
        this.mAnnotations = pAnnotations != null ? ImmutableMap.copyOf(pAnnotations) : null;
    }

    private FieldType(_Builder builder) {
        this.mDocumentation = builder.mDocumentation;
        this.mKey = builder.mKey;
        this.mRequirement = builder.mRequirement;
        this.mType = builder.mType;
        this.mName = builder.mName;
        this.mDefaultValue = builder.mDefaultValue;
        this.mAnnotations = builder.isSetAnnotations() ? builder.mAnnotations.build() : null;
    }

    public boolean hasDocumentation() {
        return this.mDocumentation != null;
    }

    public String getDocumentation() {
        return this.mDocumentation;
    }

    public boolean hasKey() {
        return true;
    }

    public int getKey() {
        return this.mKey;
    }

    public boolean hasRequirement() {
        return this.mRequirement != null;
    }

    public FieldRequirement getRequirement() {
        return this.hasRequirement() ? this.mRequirement : kDefaultRequirement;
    }

    public boolean hasType() {
        return this.mType != null;
    }

    public String getType() {
        return this.mType;
    }

    public boolean hasName() {
        return this.mName != null;
    }

    public String getName() {
        return this.mName;
    }

    public boolean hasDefaultValue() {
        return this.mDefaultValue != null;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    public int numAnnotations() {
        return this.mAnnotations != null ? this.mAnnotations.size() : 0;
    }

    public boolean hasAnnotations() {
        return this.mAnnotations != null;
    }

    public Map<String, String> getAnnotations() {
        return this.mAnnotations;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasDocumentation();
            }
            case 2: {
                return true;
            }
            case 3: {
                return this.hasRequirement();
            }
            case 4: {
                return this.hasType();
            }
            case 5: {
                return this.hasName();
            }
            case 6: {
                return this.hasDefaultValue();
            }
            case 7: {
                return this.hasAnnotations();
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasDocumentation() ? 1 : 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return this.hasRequirement() ? 1 : 0;
            }
            case 4: {
                return this.hasType() ? 1 : 0;
            }
            case 5: {
                return this.hasName() ? 1 : 0;
            }
            case 6: {
                return this.hasDefaultValue() ? 1 : 0;
            }
            case 7: {
                return this.numAnnotations();
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getDocumentation();
            }
            case 2: {
                return this.getKey();
            }
            case 3: {
                return this.getRequirement();
            }
            case 4: {
                return this.getType();
            }
            case 5: {
                return this.getName();
            }
            case 6: {
                return this.getDefaultValue();
            }
            case 7: {
                return this.getAnnotations();
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        FieldType other = (FieldType)o;
        return Objects.equals(this.mDocumentation, other.mDocumentation) && Objects.equals(this.mKey, other.mKey) && Objects.equals((Object)this.mRequirement, (Object)other.mRequirement) && Objects.equals(this.mType, other.mType) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mDefaultValue, other.mDefaultValue) && Objects.equals(this.mAnnotations, other.mAnnotations);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{FieldType.class, _Field.DOCUMENTATION, this.mDocumentation, _Field.KEY, this.mKey, _Field.REQUIREMENT, this.mRequirement, _Field.TYPE, this.mType, _Field.NAME, this.mName, _Field.DEFAULT_VALUE, this.mDefaultValue, _Field.ANNOTATIONS, this.mAnnotations});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.FieldType" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasDocumentation()) {
            first = false;
            out.append("documentation:").append('\"').append(Strings.escape((CharSequence)this.mDocumentation)).append('\"');
        }
        out.append("key:").append(this.mKey);
        if (this.hasRequirement()) {
            out.append(',');
            out.append("requirement:").append(this.mRequirement.asString());
        }
        if (this.hasType()) {
            out.append(',');
            out.append("type:").append('\"').append(Strings.escape((CharSequence)this.mType)).append('\"');
        }
        if (this.hasName()) {
            out.append(',');
            out.append("name:").append('\"').append(Strings.escape((CharSequence)this.mName)).append('\"');
        }
        if (this.hasDefaultValue()) {
            out.append(',');
            out.append("default_value:").append('\"').append(Strings.escape((CharSequence)this.mDefaultValue)).append('\"');
        }
        if (this.hasAnnotations()) {
            out.append(',');
            out.append("annotations:").append(Strings.asString(this.mAnnotations));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(FieldType other) {
        int c = Boolean.compare(this.mDocumentation != null, other.mDocumentation != null);
        if (c != 0) {
            return c;
        }
        if (this.mDocumentation != null && (c = this.mDocumentation.compareTo(other.mDocumentation)) != 0) {
            return c;
        }
        c = Integer.compare(this.mKey, other.mKey);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mRequirement != null, other.mRequirement != null);
        if (c != 0) {
            return c;
        }
        if (this.mRequirement != null && (c = Integer.compare(this.mRequirement.ordinal(), this.mRequirement.ordinal())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mType != null, other.mType != null);
        if (c != 0) {
            return c;
        }
        if (this.mType != null && (c = this.mType.compareTo(other.mType)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mName != null, other.mName != null);
        if (c != 0) {
            return c;
        }
        if (this.mName != null && (c = this.mName.compareTo(other.mName)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mDefaultValue != null, other.mDefaultValue != null);
        if (c != 0) {
            return c;
        }
        if (this.mDefaultValue != null && (c = this.mDefaultValue.compareTo(other.mDefaultValue)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mAnnotations != null, other.mAnnotations != null);
        if (c != 0) {
            return c;
        }
        if (this.mAnnotations != null && (c = Integer.compare(this.mAnnotations.hashCode(), other.mAnnotations.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        if (this.hasDocumentation()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)1);
            Binary tmp_1 = Binary.wrap((byte[])this.mDocumentation.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_1.length());
            length += writer.writeBinary(tmp_1);
        }
        length += writer.writeByte((byte)8);
        length += writer.writeShort((short)2);
        length += writer.writeInt(this.mKey);
        if (this.hasRequirement()) {
            length += writer.writeByte((byte)8);
            length += writer.writeShort((short)3);
            length += writer.writeInt(this.mRequirement.getValue());
        }
        if (this.hasType()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)4);
            Binary tmp_2 = Binary.wrap((byte[])this.mType.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }
        if (this.hasName()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)5);
            Binary tmp_3 = Binary.wrap((byte[])this.mName.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_3.length());
            length += writer.writeBinary(tmp_3);
        }
        if (this.hasDefaultValue()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)6);
            Binary tmp_4 = Binary.wrap((byte[])this.mDefaultValue.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_4.length());
            length += writer.writeBinary(tmp_4);
        }
        if (this.hasAnnotations()) {
            length += writer.writeByte((byte)13);
            length += writer.writeShort((short)7);
            length += writer.writeByte((byte)11);
            length += writer.writeByte((byte)11);
            length += writer.writeUInt32(this.mAnnotations.size());
            for (Map.Entry<String, String> entry_5 : this.mAnnotations.entrySet()) {
                Binary tmp_6 = Binary.wrap((byte[])entry_5.getKey().getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_6.length());
                length += writer.writeBinary(tmp_6);
                Binary tmp_7 = Binary.wrap((byte[])entry_5.getValue().getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_7.length());
                length += writer.writeBinary(tmp_7);
            }
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static PStructDescriptorProvider<FieldType, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<FieldType, _Field> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<FieldType, _Field>
    implements BinaryReader {
        private BitSet optionals = new BitSet(7);
        private BitSet modified = new BitSet(7);
        private String mDocumentation;
        private int mKey = 0;
        private FieldRequirement mRequirement;
        private String mType;
        private String mName;
        private String mDefaultValue;
        private PMap.Builder<String, String> mAnnotations = new PMap.ImmutableMapBuilder();

        public _Builder() {
        }

        public _Builder(FieldType base) {
            this();
            if (base.hasDocumentation()) {
                this.optionals.set(0);
                this.mDocumentation = base.mDocumentation;
            }
            this.optionals.set(1);
            this.mKey = base.mKey;
            if (base.hasRequirement()) {
                this.optionals.set(2);
                this.mRequirement = base.mRequirement;
            }
            if (base.hasType()) {
                this.optionals.set(3);
                this.mType = base.mType;
            }
            if (base.hasName()) {
                this.optionals.set(4);
                this.mName = base.mName;
            }
            if (base.hasDefaultValue()) {
                this.optionals.set(5);
                this.mDefaultValue = base.mDefaultValue;
            }
            if (base.hasAnnotations()) {
                this.optionals.set(6);
                this.mAnnotations.putAll(base.mAnnotations);
            }
        }

        @Nonnull
        public _Builder merge(FieldType from) {
            if (from.hasDocumentation()) {
                this.optionals.set(0);
                this.modified.set(0);
                this.mDocumentation = from.getDocumentation();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mKey = from.getKey();
            if (from.hasRequirement()) {
                this.optionals.set(2);
                this.modified.set(2);
                this.mRequirement = from.getRequirement();
            }
            if (from.hasType()) {
                this.optionals.set(3);
                this.modified.set(3);
                this.mType = from.getType();
            }
            if (from.hasName()) {
                this.optionals.set(4);
                this.modified.set(4);
                this.mName = from.getName();
            }
            if (from.hasDefaultValue()) {
                this.optionals.set(5);
                this.modified.set(5);
                this.mDefaultValue = from.getDefaultValue();
            }
            if (from.hasAnnotations()) {
                this.optionals.set(6);
                this.modified.set(6);
                this.mAnnotations.putAll(from.getAnnotations());
            }
            return this;
        }

        @Nonnull
        public _Builder setDocumentation(String value) {
            this.optionals.set(0);
            this.modified.set(0);
            this.mDocumentation = value;
            return this;
        }

        public boolean isSetDocumentation() {
            return this.optionals.get(0);
        }

        public boolean isModifiedDocumentation() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearDocumentation() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mDocumentation = null;
            return this;
        }

        public String getDocumentation() {
            return this.mDocumentation;
        }

        @Nonnull
        public _Builder setKey(int value) {
            this.optionals.set(1);
            this.modified.set(1);
            this.mKey = value;
            return this;
        }

        public boolean isSetKey() {
            return this.optionals.get(1);
        }

        public boolean isModifiedKey() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearKey() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mKey = 0;
            return this;
        }

        public int getKey() {
            return this.mKey;
        }

        @Nonnull
        public _Builder setRequirement(FieldRequirement value) {
            this.optionals.set(2);
            this.modified.set(2);
            this.mRequirement = value;
            return this;
        }

        public boolean isSetRequirement() {
            return this.optionals.get(2);
        }

        public boolean isModifiedRequirement() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearRequirement() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mRequirement = null;
            return this;
        }

        public FieldRequirement getRequirement() {
            return this.isSetRequirement() ? this.mRequirement : kDefaultRequirement;
        }

        @Nonnull
        public _Builder setType(String value) {
            this.optionals.set(3);
            this.modified.set(3);
            this.mType = value;
            return this;
        }

        public boolean isSetType() {
            return this.optionals.get(3);
        }

        public boolean isModifiedType() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearType() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mType = null;
            return this;
        }

        public String getType() {
            return this.mType;
        }

        @Nonnull
        public _Builder setName(String value) {
            this.optionals.set(4);
            this.modified.set(4);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(4);
        }

        public boolean isModifiedName() {
            return this.modified.get(4);
        }

        @Nonnull
        public _Builder clearName() {
            this.optionals.clear(4);
            this.modified.set(4);
            this.mName = null;
            return this;
        }

        public String getName() {
            return this.mName;
        }

        @Nonnull
        public _Builder setDefaultValue(String value) {
            this.optionals.set(5);
            this.modified.set(5);
            this.mDefaultValue = value;
            return this;
        }

        public boolean isSetDefaultValue() {
            return this.optionals.get(5);
        }

        public boolean isModifiedDefaultValue() {
            return this.modified.get(5);
        }

        @Nonnull
        public _Builder clearDefaultValue() {
            this.optionals.clear(5);
            this.modified.set(5);
            this.mDefaultValue = null;
            return this;
        }

        public String getDefaultValue() {
            return this.mDefaultValue;
        }

        @Nonnull
        public _Builder setAnnotations(Map<String, String> value) {
            this.optionals.set(6);
            this.modified.set(6);
            this.mAnnotations.clear();
            this.mAnnotations.putAll(value);
            return this;
        }

        @Nonnull
        public _Builder putInAnnotations(String key, String value) {
            this.optionals.set(6);
            this.modified.set(6);
            this.mAnnotations.put((Object)key, (Object)value);
            return this;
        }

        public boolean isSetAnnotations() {
            return this.optionals.get(6);
        }

        public boolean isModifiedAnnotations() {
            return this.modified.get(6);
        }

        @Nonnull
        public _Builder clearAnnotations() {
            this.optionals.clear(6);
            this.modified.set(6);
            this.mAnnotations.clear();
            return this;
        }

        public PMap.Builder<String, String> mutableAnnotations() {
            this.optionals.set(6);
            this.modified.set(6);
            return this.mAnnotations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
                return false;
            }
            _Builder other = (_Builder)((Object)o);
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mDocumentation, other.mDocumentation) && Objects.equals(this.mKey, other.mKey) && Objects.equals((Object)this.mRequirement, (Object)other.mRequirement) && Objects.equals(this.mType, other.mType) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mDefaultValue, other.mDefaultValue) && Objects.equals(this.mAnnotations, other.mAnnotations);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{FieldType.class, this.optionals, _Field.DOCUMENTATION, this.mDocumentation, _Field.KEY, this.mKey, _Field.REQUIREMENT, this.mRequirement, _Field.TYPE, this.mType, _Field.NAME, this.mName, _Field.DEFAULT_VALUE, this.mDefaultValue, _Field.ANNOTATIONS, this.mAnnotations});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                default: 
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setDocumentation((String)value);
                    break;
                }
                case 2: {
                    this.setKey((Integer)value);
                    break;
                }
                case 3: {
                    this.setRequirement((FieldRequirement)((Object)value));
                    break;
                }
                case 4: {
                    this.setType((String)value);
                    break;
                }
                case 5: {
                    this.setName((String)value);
                    break;
                }
                case 6: {
                    this.setDefaultValue((String)value);
                    break;
                }
                case 7: {
                    this.setAnnotations((Map)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 3: {
                    return this.optionals.get(2);
                }
                case 4: {
                    return this.optionals.get(3);
                }
                case 5: {
                    return this.optionals.get(4);
                }
                case 6: {
                    return this.optionals.get(5);
                }
                case 7: {
                    return this.optionals.get(6);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 3: {
                    return this.modified.get(2);
                }
                case 4: {
                    return this.modified.get(3);
                }
                case 5: {
                    return this.modified.get(4);
                }
                case 6: {
                    return this.modified.get(5);
                }
                case 7: {
                    return this.modified.get(6);
                }
            }
            return false;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearDocumentation();
                    break;
                }
                case 2: {
                    this.clearKey();
                    break;
                }
                case 3: {
                    this.clearRequirement();
                    break;
                }
                case 4: {
                    this.clearType();
                    break;
                }
                case 5: {
                    this.clearName();
                    break;
                }
                case 6: {
                    this.clearDefaultValue();
                    break;
                }
                case 7: {
                    this.clearAnnotations();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return this.optionals.get(1) && this.optionals.get(3) && this.optionals.get(4);
        }

        public void validate() {
            if (!this.valid()) {
                LinkedList<String> missing = new LinkedList<String>();
                if (!this.optionals.get(1)) {
                    missing.add("key");
                }
                if (!this.optionals.get(3)) {
                    missing.add("type");
                }
                if (!this.optionals.get(4)) {
                    missing.add("name");
                }
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message model.FieldType");
            }
        }

        @Nonnull
        public PStructDescriptor<FieldType, _Field> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mDocumentation = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.FieldType.documentation, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 8) {
                            this.mKey = reader.expectInt();
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.FieldType.key, should be struct(12)", new Object[0]);
                    }
                    case 3: {
                        if (type == 8) {
                            this.mRequirement = FieldRequirement.forValue(reader.expectInt());
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.FieldType.requirement, should be struct(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            this.mType = new String(reader.expectBytes(len_2), StandardCharsets.UTF_8);
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.FieldType.type, should be struct(12)", new Object[0]);
                    }
                    case 5: {
                        if (type == 11) {
                            int len_3 = reader.expectUInt32();
                            this.mName = new String(reader.expectBytes(len_3), StandardCharsets.UTF_8);
                            this.optionals.set(4);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.FieldType.name, should be struct(12)", new Object[0]);
                    }
                    case 6: {
                        if (type == 11) {
                            int len_4 = reader.expectUInt32();
                            this.mDefaultValue = new String(reader.expectBytes(len_4), StandardCharsets.UTF_8);
                            this.optionals.set(5);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.FieldType.default_value, should be struct(12)", new Object[0]);
                    }
                    case 7: {
                        if (type == 13) {
                            byte t_6 = reader.expectByte();
                            byte t_7 = reader.expectByte();
                            if (t_6 == 11 && t_7 == 11) {
                                int len_5 = reader.expectUInt32();
                                for (int i_8 = 0; i_8 < len_5; ++i_8) {
                                    int len_11 = reader.expectUInt32();
                                    String key_9 = new String(reader.expectBytes(len_11), StandardCharsets.UTF_8);
                                    int len_12 = reader.expectUInt32();
                                    String val_10 = new String(reader.expectBytes(len_12), StandardCharsets.UTF_8);
                                    this.mAnnotations.put((Object)key_9, (Object)val_10);
                                }
                            } else {
                                throw new SerializerException("Wrong key type " + BinaryType.asString((byte)t_6) + " or value type " + BinaryType.asString((byte)t_7) + " for model.FieldType.annotations, should be string(11) and string(11)", new Object[0]);
                            }
                            this.optionals.set(6);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for model.FieldType.annotations, should be struct(12)", new Object[0]);
                    }
                    default: {
                        if (strict) {
                            throw new SerializerException("No field with id " + field + " exists in model.FieldType", new Object[0]);
                        }
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        public FieldType build() {
            return new FieldType(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<FieldType, _Field> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<FieldType, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<FieldType, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<FieldType, _Field> {
        public _Descriptor() {
            super("model", "FieldType", (PMessageBuilderFactory)new _Factory(), false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        DOCUMENTATION(1, PRequirement.DEFAULT, "documentation", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        KEY(2, PRequirement.REQUIRED, "key", (PDescriptorProvider)PPrimitive.I32.provider(), null),
        REQUIREMENT(3, PRequirement.DEFAULT, "requirement", (PDescriptorProvider)FieldRequirement.provider(), (PValueProvider<?>)new PDefaultValueProvider((Object)((Object)FieldType.access$700()))),
        TYPE(4, PRequirement.REQUIRED, "type", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        NAME(5, PRequirement.REQUIRED, "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        DEFAULT_VALUE(6, PRequirement.DEFAULT, "default_value", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        ANNOTATIONS(7, PRequirement.DEFAULT, "annotations", (PDescriptorProvider)PMap.provider((PDescriptorProvider)PPrimitive.STRING.provider(), (PDescriptorProvider)PPrimitive.STRING.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return DOCUMENTATION;
                }
                case 2: {
                    return KEY;
                }
                case 3: {
                    return REQUIREMENT;
                }
                case 4: {
                    return TYPE;
                }
                case 5: {
                    return NAME;
                }
                case 6: {
                    return DEFAULT_VALUE;
                }
                case 7: {
                    return ANNOTATIONS;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "documentation": {
                    return DOCUMENTATION;
                }
                case "key": {
                    return KEY;
                }
                case "requirement": {
                    return REQUIREMENT;
                }
                case "type": {
                    return TYPE;
                }
                case "name": {
                    return NAME;
                }
                case "default_value": {
                    return DEFAULT_VALUE;
                }
                case "annotations": {
                    return ANNOTATIONS;
                }
            }
            return null;
        }
    }
}

