/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumBuilderFactory;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CEnumValue;

public class CEnumDescriptor
extends PEnumDescriptor<CEnumValue>
implements CAnnotatedDescriptor {
    private CEnumValue[] values = new CEnumValue[0];
    private final Map<String, String> annotations;
    private final String comment;

    public CEnumDescriptor(String comment, String packageName, String name, Map<String, String> annotations) {
        super(packageName, name, (PEnumBuilderFactory)new _Factory());
        this.comment = comment;
        this.annotations = annotations;
        ((_Factory)this.getFactoryInternal()).setType(this);
    }

    public void setValues(List<CEnumValue> values) {
        this.values = new CEnumValue[values.size()];
        Iterator<CEnumValue> iter = values.iterator();
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = iter.next();
        }
    }

    @Override
    public final String getDocumentation() {
        return this.comment;
    }

    @Nonnull
    public CEnumValue[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public CEnumValue getValueById(int id) {
        for (CEnumValue value : this.getValues()) {
            if (value.getValue() != id) continue;
            return value;
        }
        return null;
    }

    public CEnumValue getValueByName(String name) {
        for (CEnumValue value : this.getValues()) {
            if (!value.getName().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    @Override
    @Nonnull
    public Set<String> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAnnotation(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.get(name);
        }
        return null;
    }

    private static class _Factory
    extends PEnumBuilderFactory<CEnumValue> {
        private CEnumDescriptor mType;

        private _Factory() {
        }

        public void setType(CEnumDescriptor type) {
            this.mType = type;
        }

        @Nonnull
        public PEnumBuilder<CEnumValue> builder() {
            return new CEnumValue.Builder(this.mType);
        }
    }
}

