/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.internal.ConstParser;
import net.morimekta.providence.reflect.util.ProgramRegistry;

public class ConstProvider
implements PValueProvider<Object> {
    private final ProgramRegistry registry;
    private final String typeName;
    private final String programContext;
    private final String defaultValue;
    private Object parsedValue;

    public ConstProvider(@Nonnull ProgramRegistry registry, @Nonnull String typeName, @Nonnull String programContext, @Nonnull String defaultValue) {
        this.registry = registry;
        this.typeName = typeName;
        this.programContext = programContext;
        this.defaultValue = defaultValue;
        this.parsedValue = null;
    }

    public Object get() {
        if (this.parsedValue == null) {
            ConstParser parser = new ConstParser(this.registry, this.programContext);
            PDescriptor type = this.registry.getProvider(this.typeName, this.programContext, Collections.EMPTY_MAP).descriptor();
            try (ByteArrayInputStream in = new ByteArrayInputStream(this.defaultValue.getBytes(StandardCharsets.UTF_8));){
                this.parsedValue = parser.parse(in, type);
            }
            catch (IOException | ParseException e) {
                e.printStackTrace();
            }
        }
        return this.parsedValue;
    }
}

