/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.rw.BinaryFormatUtils;
import net.morimekta.providence.serializer.rw.BinaryReader;
import net.morimekta.providence.serializer.rw.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

public class ProgramType
implements PMessage<ProgramType, _Field>,
Comparable<ProgramType>,
Serializable,
BinaryWriter {
    private static final long serialVersionUID = 2224801959218006031L;
    private final String mDocumentation;
    private final String mProgramName;
    private final List<String> mIncludes;
    private final Map<String, String> mNamespaces;
    private final List<Declaration> mDecl;
    private volatile int tHashCode;
    public static final PStructDescriptor<ProgramType, _Field> kDescriptor = new _Descriptor();

    public ProgramType(String pDocumentation, String pProgramName, List<String> pIncludes, Map<String, String> pNamespaces, List<Declaration> pDecl) {
        this.mDocumentation = pDocumentation;
        this.mProgramName = pProgramName;
        this.mIncludes = pIncludes != null ? ImmutableList.copyOf(pIncludes) : null;
        this.mNamespaces = pNamespaces != null ? ImmutableMap.copyOf(pNamespaces) : null;
        this.mDecl = pDecl != null ? ImmutableList.copyOf(pDecl) : null;
    }

    private ProgramType(_Builder builder) {
        this.mDocumentation = builder.mDocumentation;
        this.mProgramName = builder.mProgramName;
        this.mIncludes = builder.isSetIncludes() ? builder.mIncludes.build() : null;
        this.mNamespaces = builder.isSetNamespaces() ? builder.mNamespaces.build() : null;
        this.mDecl = builder.isSetDecl() ? builder.mDecl.build() : null;
    }

    public boolean hasDocumentation() {
        return this.mDocumentation != null;
    }

    public String getDocumentation() {
        return this.mDocumentation;
    }

    public boolean hasProgramName() {
        return this.mProgramName != null;
    }

    public String getProgramName() {
        return this.mProgramName;
    }

    public int numIncludes() {
        return this.mIncludes != null ? this.mIncludes.size() : 0;
    }

    public boolean hasIncludes() {
        return this.mIncludes != null;
    }

    public List<String> getIncludes() {
        return this.mIncludes;
    }

    public int numNamespaces() {
        return this.mNamespaces != null ? this.mNamespaces.size() : 0;
    }

    public boolean hasNamespaces() {
        return this.mNamespaces != null;
    }

    public Map<String, String> getNamespaces() {
        return this.mNamespaces;
    }

    public int numDecl() {
        return this.mDecl != null ? this.mDecl.size() : 0;
    }

    public boolean hasDecl() {
        return this.mDecl != null;
    }

    public List<Declaration> getDecl() {
        return this.mDecl;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasDocumentation();
            }
            case 2: {
                return this.hasProgramName();
            }
            case 3: {
                return this.hasIncludes();
            }
            case 4: {
                return this.hasNamespaces();
            }
            case 5: {
                return this.hasDecl();
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasDocumentation() ? 1 : 0;
            }
            case 2: {
                return this.hasProgramName() ? 1 : 0;
            }
            case 3: {
                return this.numIncludes();
            }
            case 4: {
                return this.numNamespaces();
            }
            case 5: {
                return this.numDecl();
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getDocumentation();
            }
            case 2: {
                return this.getProgramName();
            }
            case 3: {
                return this.getIncludes();
            }
            case 4: {
                return this.getNamespaces();
            }
            case 5: {
                return this.getDecl();
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        ProgramType other = (ProgramType)o;
        return Objects.equals(this.mDocumentation, other.mDocumentation) && Objects.equals(this.mProgramName, other.mProgramName) && Objects.equals(this.mIncludes, other.mIncludes) && Objects.equals(this.mNamespaces, other.mNamespaces) && Objects.equals(this.mDecl, other.mDecl);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{ProgramType.class, _Field.DOCUMENTATION, this.mDocumentation, _Field.PROGRAM_NAME, this.mProgramName, _Field.INCLUDES, this.mIncludes, _Field.NAMESPACES, this.mNamespaces, _Field.DECL, this.mDecl});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.ProgramType" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasDocumentation()) {
            first = false;
            out.append("documentation:").append('\"').append(Strings.escape((CharSequence)this.mDocumentation)).append('\"');
        }
        if (this.hasProgramName()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("program_name:").append('\"').append(Strings.escape((CharSequence)this.mProgramName)).append('\"');
        }
        if (this.hasIncludes()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("includes:").append(Strings.asString(this.mIncludes));
        }
        if (this.hasNamespaces()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("namespaces:").append(Strings.asString(this.mNamespaces));
        }
        if (this.hasDecl()) {
            if (!first) {
                out.append(',');
            }
            out.append("decl:").append(Strings.asString(this.mDecl));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(ProgramType other) {
        int c = Boolean.compare(this.mDocumentation != null, other.mDocumentation != null);
        if (c != 0) {
            return c;
        }
        if (this.mDocumentation != null && (c = this.mDocumentation.compareTo(other.mDocumentation)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mProgramName != null, other.mProgramName != null);
        if (c != 0) {
            return c;
        }
        if (this.mProgramName != null && (c = this.mProgramName.compareTo(other.mProgramName)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mIncludes != null, other.mIncludes != null);
        if (c != 0) {
            return c;
        }
        if (this.mIncludes != null && (c = Integer.compare(this.mIncludes.hashCode(), other.mIncludes.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mNamespaces != null, other.mNamespaces != null);
        if (c != 0) {
            return c;
        }
        if (this.mNamespaces != null && (c = Integer.compare(this.mNamespaces.hashCode(), other.mNamespaces.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mDecl != null, other.mDecl != null);
        if (c != 0) {
            return c;
        }
        if (this.mDecl != null && (c = Integer.compare(this.mDecl.hashCode(), other.mDecl.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        if (this.hasDocumentation()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)1);
            Binary tmp_1 = Binary.wrap((byte[])this.mDocumentation.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_1.length());
            length += writer.writeBinary(tmp_1);
        }
        if (this.hasProgramName()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)2);
            Binary tmp_2 = Binary.wrap((byte[])this.mProgramName.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }
        if (this.hasIncludes()) {
            length += writer.writeByte((byte)15);
            length += writer.writeShort((short)3);
            length += writer.writeByte((byte)11);
            length += writer.writeUInt32(this.mIncludes.size());
            for (String string : this.mIncludes) {
                Binary tmp_4 = Binary.wrap((byte[])string.getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_4.length());
                length += writer.writeBinary(tmp_4);
            }
        }
        if (this.hasNamespaces()) {
            length += writer.writeByte((byte)13);
            length += writer.writeShort((short)4);
            length += writer.writeByte((byte)11);
            length += writer.writeByte((byte)11);
            length += writer.writeUInt32(this.mNamespaces.size());
            for (Map.Entry entry : this.mNamespaces.entrySet()) {
                Binary tmp_6 = Binary.wrap((byte[])((String)entry.getKey()).getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_6.length());
                length += writer.writeBinary(tmp_6);
                Binary tmp_7 = Binary.wrap((byte[])((String)entry.getValue()).getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_7.length());
                length += writer.writeBinary(tmp_7);
            }
        }
        if (this.hasDecl()) {
            length += writer.writeByte((byte)15);
            length += writer.writeShort((short)5);
            length += writer.writeByte((byte)12);
            length += writer.writeUInt32(this.mDecl.size());
            for (Declaration declaration : this.mDecl) {
                length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessage)declaration);
            }
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static PStructDescriptorProvider<ProgramType, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<ProgramType, _Field> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<ProgramType, _Field>
    implements BinaryReader {
        private BitSet optionals = new BitSet(5);
        private BitSet modified = new BitSet(5);
        private String mDocumentation;
        private String mProgramName;
        private PList.Builder<String> mIncludes = new PList.ImmutableListBuilder();
        private PMap.Builder<String, String> mNamespaces = new PMap.ImmutableMapBuilder();
        private PList.Builder<Declaration> mDecl = new PList.ImmutableListBuilder();

        public _Builder() {
        }

        public _Builder(ProgramType base) {
            this();
            if (base.hasDocumentation()) {
                this.optionals.set(0);
                this.mDocumentation = base.mDocumentation;
            }
            if (base.hasProgramName()) {
                this.optionals.set(1);
                this.mProgramName = base.mProgramName;
            }
            if (base.hasIncludes()) {
                this.optionals.set(2);
                this.mIncludes.addAll((Collection)base.mIncludes);
            }
            if (base.hasNamespaces()) {
                this.optionals.set(3);
                this.mNamespaces.putAll(base.mNamespaces);
            }
            if (base.hasDecl()) {
                this.optionals.set(4);
                this.mDecl.addAll((Collection)base.mDecl);
            }
        }

        @Nonnull
        public _Builder merge(ProgramType from) {
            if (from.hasDocumentation()) {
                this.optionals.set(0);
                this.modified.set(0);
                this.mDocumentation = from.getDocumentation();
            }
            if (from.hasProgramName()) {
                this.optionals.set(1);
                this.modified.set(1);
                this.mProgramName = from.getProgramName();
            }
            if (from.hasIncludes()) {
                this.optionals.set(2);
                this.modified.set(2);
                this.mIncludes.clear();
                this.mIncludes.addAll(from.getIncludes());
            }
            if (from.hasNamespaces()) {
                this.optionals.set(3);
                this.modified.set(3);
                this.mNamespaces.putAll(from.getNamespaces());
            }
            if (from.hasDecl()) {
                this.optionals.set(4);
                this.modified.set(4);
                this.mDecl.clear();
                this.mDecl.addAll(from.getDecl());
            }
            return this;
        }

        @Nonnull
        public _Builder setDocumentation(String value) {
            this.optionals.set(0);
            this.modified.set(0);
            this.mDocumentation = value;
            return this;
        }

        public boolean isSetDocumentation() {
            return this.optionals.get(0);
        }

        public boolean isModifiedDocumentation() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearDocumentation() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mDocumentation = null;
            return this;
        }

        public String getDocumentation() {
            return this.mDocumentation;
        }

        @Nonnull
        public _Builder setProgramName(String value) {
            this.optionals.set(1);
            this.modified.set(1);
            this.mProgramName = value;
            return this;
        }

        public boolean isSetProgramName() {
            return this.optionals.get(1);
        }

        public boolean isModifiedProgramName() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearProgramName() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mProgramName = null;
            return this;
        }

        public String getProgramName() {
            return this.mProgramName;
        }

        @Nonnull
        public _Builder setIncludes(Collection<String> value) {
            this.optionals.set(2);
            this.modified.set(2);
            this.mIncludes.clear();
            this.mIncludes.addAll(value);
            return this;
        }

        @Nonnull
        public _Builder addToIncludes(String ... values) {
            this.optionals.set(2);
            this.modified.set(2);
            for (String item : values) {
                this.mIncludes.add((Object)item);
            }
            return this;
        }

        public boolean isSetIncludes() {
            return this.optionals.get(2);
        }

        public boolean isModifiedIncludes() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearIncludes() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mIncludes.clear();
            return this;
        }

        public PList.Builder<String> mutableIncludes() {
            this.optionals.set(2);
            this.modified.set(2);
            return this.mIncludes;
        }

        @Nonnull
        public _Builder setNamespaces(Map<String, String> value) {
            this.optionals.set(3);
            this.modified.set(3);
            this.mNamespaces.clear();
            this.mNamespaces.putAll(value);
            return this;
        }

        @Nonnull
        public _Builder putInNamespaces(String key, String value) {
            this.optionals.set(3);
            this.modified.set(3);
            this.mNamespaces.put((Object)key, (Object)value);
            return this;
        }

        public boolean isSetNamespaces() {
            return this.optionals.get(3);
        }

        public boolean isModifiedNamespaces() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearNamespaces() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mNamespaces.clear();
            return this;
        }

        public PMap.Builder<String, String> mutableNamespaces() {
            this.optionals.set(3);
            this.modified.set(3);
            return this.mNamespaces;
        }

        @Nonnull
        public _Builder setDecl(Collection<Declaration> value) {
            this.optionals.set(4);
            this.modified.set(4);
            this.mDecl.clear();
            this.mDecl.addAll(value);
            return this;
        }

        @Nonnull
        public _Builder addToDecl(Declaration ... values) {
            this.optionals.set(4);
            this.modified.set(4);
            for (Declaration item : values) {
                this.mDecl.add((Object)item);
            }
            return this;
        }

        public boolean isSetDecl() {
            return this.optionals.get(4);
        }

        public boolean isModifiedDecl() {
            return this.modified.get(4);
        }

        @Nonnull
        public _Builder clearDecl() {
            this.optionals.clear(4);
            this.modified.set(4);
            this.mDecl.clear();
            return this;
        }

        public PList.Builder<Declaration> mutableDecl() {
            this.optionals.set(4);
            this.modified.set(4);
            return this.mDecl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
                return false;
            }
            _Builder other = (_Builder)((Object)o);
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mDocumentation, other.mDocumentation) && Objects.equals(this.mProgramName, other.mProgramName) && Objects.equals(this.mIncludes, other.mIncludes) && Objects.equals(this.mNamespaces, other.mNamespaces) && Objects.equals(this.mDecl, other.mDecl);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{ProgramType.class, this.optionals, _Field.DOCUMENTATION, this.mDocumentation, _Field.PROGRAM_NAME, this.mProgramName, _Field.INCLUDES, this.mIncludes, _Field.NAMESPACES, this.mNamespaces, _Field.DECL, this.mDecl});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                default: 
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setDocumentation((String)value);
                    break;
                }
                case 2: {
                    this.setProgramName((String)value);
                    break;
                }
                case 3: {
                    this.setIncludes((List)value);
                    break;
                }
                case 4: {
                    this.setNamespaces((Map)value);
                    break;
                }
                case 5: {
                    this.setDecl((List)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 3: {
                    return this.optionals.get(2);
                }
                case 4: {
                    return this.optionals.get(3);
                }
                case 5: {
                    return this.optionals.get(4);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 3: {
                    return this.modified.get(2);
                }
                case 4: {
                    return this.modified.get(3);
                }
                case 5: {
                    return this.modified.get(4);
                }
            }
            return false;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 3: {
                    this.addToIncludes((String)value);
                    break;
                }
                case 5: {
                    this.addToDecl((Declaration)value);
                    break;
                }
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearDocumentation();
                    break;
                }
                case 2: {
                    this.clearProgramName();
                    break;
                }
                case 3: {
                    this.clearIncludes();
                    break;
                }
                case 4: {
                    this.clearNamespaces();
                    break;
                }
                case 5: {
                    this.clearDecl();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return this.optionals.get(1);
        }

        public void validate() {
            if (!this.valid()) {
                LinkedList<String> missing = new LinkedList<String>();
                if (!this.optionals.get(1)) {
                    missing.add("program_name");
                }
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message model.ProgramType");
            }
        }

        @Nonnull
        public PStructDescriptor<ProgramType, _Field> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mDocumentation = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + PType.nameForId((byte)type) + "(" + type + ") for model.ProgramType.documentation, should be message(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            this.mProgramName = new String(reader.expectBytes(len_2), StandardCharsets.UTF_8);
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + PType.nameForId((byte)type) + "(" + type + ") for model.ProgramType.program_name, should be message(12)", new Object[0]);
                    }
                    case 3: {
                        if (type == 15) {
                            byte t_4 = reader.expectByte();
                            if (t_4 == 11) {
                                int len_3 = reader.expectUInt32();
                                for (int i_5 = 0; i_5 < len_3; ++i_5) {
                                    int len_7 = reader.expectUInt32();
                                    String key_6 = new String(reader.expectBytes(len_7), StandardCharsets.UTF_8);
                                    this.mIncludes.add((Object)key_6);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + PType.nameForId((byte)t_4) + "(" + t_4 + ") for model.ProgramType.includes, should be string(11)", new Object[0]);
                            }
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + PType.nameForId((byte)type) + "(" + type + ") for model.ProgramType.includes, should be message(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 13) {
                            byte t_9 = reader.expectByte();
                            byte t_10 = reader.expectByte();
                            if (t_9 == 11 && t_10 == 11) {
                                int len_8 = reader.expectUInt32();
                                for (int i_11 = 0; i_11 < len_8; ++i_11) {
                                    int len_14 = reader.expectUInt32();
                                    String key_12 = new String(reader.expectBytes(len_14), StandardCharsets.UTF_8);
                                    int len_15 = reader.expectUInt32();
                                    String val_13 = new String(reader.expectBytes(len_15), StandardCharsets.UTF_8);
                                    this.mNamespaces.put((Object)key_12, (Object)val_13);
                                }
                            } else {
                                throw new SerializerException("Wrong key type " + PType.nameForId((byte)t_9) + "(" + t_9 + ") or value type " + PType.nameForId((byte)t_10) + "(" + t_10 + ") for model.ProgramType.namespaces, should be string(11) and string(11)", new Object[0]);
                            }
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + PType.nameForId((byte)type) + "(" + type + ") for model.ProgramType.namespaces, should be message(12)", new Object[0]);
                    }
                    case 5: {
                        if (type == 15) {
                            byte t_17 = reader.expectByte();
                            if (t_17 == 12) {
                                int len_16 = reader.expectUInt32();
                                for (int i_18 = 0; i_18 < len_16; ++i_18) {
                                    Declaration key_19 = (Declaration)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, Declaration.kDescriptor, (boolean)strict);
                                    this.mDecl.add((Object)key_19);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + PType.nameForId((byte)t_17) + "(" + t_17 + ") for model.ProgramType.decl, should be message(12)", new Object[0]);
                            }
                            this.optionals.set(4);
                            break;
                        }
                        throw new SerializerException("Wrong type " + PType.nameForId((byte)type) + "(" + type + ") for model.ProgramType.decl, should be message(12)", new Object[0]);
                    }
                    default: {
                        if (strict) {
                            throw new SerializerException("No field with id " + field + " exists in model.ProgramType", new Object[0]);
                        }
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        public ProgramType build() {
            return new ProgramType(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<ProgramType, _Field> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<ProgramType, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<ProgramType, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<ProgramType, _Field> {
        public _Descriptor() {
            super("model", "ProgramType", (PMessageBuilderFactory)new _Factory(), false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        DOCUMENTATION(1, PRequirement.DEFAULT, "documentation", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        PROGRAM_NAME(2, PRequirement.REQUIRED, "program_name", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        INCLUDES(3, PRequirement.DEFAULT, "includes", (PDescriptorProvider)PList.provider((PDescriptorProvider)PPrimitive.STRING.provider()), null),
        NAMESPACES(4, PRequirement.DEFAULT, "namespaces", (PDescriptorProvider)PMap.provider((PDescriptorProvider)PPrimitive.STRING.provider(), (PDescriptorProvider)PPrimitive.STRING.provider()), null),
        DECL(5, PRequirement.DEFAULT, "decl", (PDescriptorProvider)PList.provider(Declaration.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.toString((PField)this);
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return DOCUMENTATION;
                }
                case 2: {
                    return PROGRAM_NAME;
                }
                case 3: {
                    return INCLUDES;
                }
                case 4: {
                    return NAMESPACES;
                }
                case 5: {
                    return DECL;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "documentation": {
                    return DOCUMENTATION;
                }
                case "program_name": {
                    return PROGRAM_NAME;
                }
                case "includes": {
                    return INCLUDES;
                }
                case "namespaces": {
                    return NAMESPACES;
                }
                case "decl": {
                    return DECL;
                }
            }
            return null;
        }
    }
}

