/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.FieldType;
import net.morimekta.providence.model.MessageVariant;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.rw.BinaryFormatUtils;
import net.morimekta.providence.serializer.rw.BinaryReader;
import net.morimekta.providence.serializer.rw.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

public class MessageType
implements PMessage<MessageType, _Field>,
Comparable<MessageType>,
Serializable,
BinaryWriter {
    private static final long serialVersionUID = -7041659190974449690L;
    private static final MessageVariant kDefaultVariant = MessageVariant.STRUCT;
    private final String mDocumentation;
    private final MessageVariant mVariant;
    private final String mName;
    private final List<FieldType> mFields;
    private final Map<String, String> mAnnotations;
    private volatile int tHashCode;
    public static final PStructDescriptor<MessageType, _Field> kDescriptor = new _Descriptor();

    public MessageType(String pDocumentation, MessageVariant pVariant, String pName, List<FieldType> pFields, Map<String, String> pAnnotations) {
        this.mDocumentation = pDocumentation;
        this.mVariant = pVariant;
        this.mName = pName;
        this.mFields = pFields != null ? ImmutableList.copyOf(pFields) : null;
        this.mAnnotations = pAnnotations != null ? ImmutableMap.copyOf(pAnnotations) : null;
    }

    private MessageType(_Builder builder) {
        this.mDocumentation = builder.mDocumentation;
        this.mVariant = builder.mVariant;
        this.mName = builder.mName;
        this.mFields = builder.isSetFields() ? builder.mFields.build() : null;
        this.mAnnotations = builder.isSetAnnotations() ? builder.mAnnotations.build() : null;
    }

    public boolean hasDocumentation() {
        return this.mDocumentation != null;
    }

    public String getDocumentation() {
        return this.mDocumentation;
    }

    public boolean hasVariant() {
        return this.mVariant != null;
    }

    public MessageVariant getVariant() {
        return this.hasVariant() ? this.mVariant : kDefaultVariant;
    }

    public boolean hasName() {
        return this.mName != null;
    }

    public String getName() {
        return this.mName;
    }

    public int numFields() {
        return this.mFields != null ? this.mFields.size() : 0;
    }

    public boolean hasFields() {
        return this.mFields != null;
    }

    public List<FieldType> getFields() {
        return this.mFields;
    }

    public int numAnnotations() {
        return this.mAnnotations != null ? this.mAnnotations.size() : 0;
    }

    public boolean hasAnnotations() {
        return this.mAnnotations != null;
    }

    public Map<String, String> getAnnotations() {
        return this.mAnnotations;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasDocumentation();
            }
            case 2: {
                return this.hasVariant();
            }
            case 3: {
                return this.hasName();
            }
            case 4: {
                return this.hasFields();
            }
            case 5: {
                return this.hasAnnotations();
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasDocumentation() ? 1 : 0;
            }
            case 2: {
                return this.hasVariant() ? 1 : 0;
            }
            case 3: {
                return this.hasName() ? 1 : 0;
            }
            case 4: {
                return this.numFields();
            }
            case 5: {
                return this.numAnnotations();
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getDocumentation();
            }
            case 2: {
                return this.getVariant();
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return this.getFields();
            }
            case 5: {
                return this.getAnnotations();
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        MessageType other = (MessageType)o;
        return Objects.equals(this.mDocumentation, other.mDocumentation) && Objects.equals((Object)this.mVariant, (Object)other.mVariant) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mFields, other.mFields) && Objects.equals(this.mAnnotations, other.mAnnotations);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{MessageType.class, _Field.DOCUMENTATION, this.mDocumentation, _Field.VARIANT, this.mVariant, _Field.NAME, this.mName, _Field.FIELDS, this.mFields, _Field.ANNOTATIONS, this.mAnnotations});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.MessageType" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasDocumentation()) {
            first = false;
            out.append("documentation:").append('\"').append(Strings.escape((CharSequence)this.mDocumentation)).append('\"');
        }
        if (this.hasVariant()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("variant:").append(this.mVariant.asString());
        }
        if (this.hasName()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("name:").append('\"').append(Strings.escape((CharSequence)this.mName)).append('\"');
        }
        if (this.hasFields()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("fields:").append(Strings.asString(this.mFields));
        }
        if (this.hasAnnotations()) {
            if (!first) {
                out.append(',');
            }
            out.append("annotations:").append(Strings.asString(this.mAnnotations));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(MessageType other) {
        int c = Boolean.compare(this.mDocumentation != null, other.mDocumentation != null);
        if (c != 0) {
            return c;
        }
        if (this.mDocumentation != null && (c = this.mDocumentation.compareTo(other.mDocumentation)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mVariant != null, other.mVariant != null);
        if (c != 0) {
            return c;
        }
        if (this.mVariant != null && (c = Integer.compare(this.mVariant.ordinal(), this.mVariant.ordinal())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mName != null, other.mName != null);
        if (c != 0) {
            return c;
        }
        if (this.mName != null && (c = this.mName.compareTo(other.mName)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mFields != null, other.mFields != null);
        if (c != 0) {
            return c;
        }
        if (this.mFields != null && (c = Integer.compare(this.mFields.hashCode(), other.mFields.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mAnnotations != null, other.mAnnotations != null);
        if (c != 0) {
            return c;
        }
        if (this.mAnnotations != null && (c = Integer.compare(this.mAnnotations.hashCode(), other.mAnnotations.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        if (this.hasDocumentation()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)1);
            Binary tmp_1 = Binary.wrap((byte[])this.mDocumentation.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_1.length());
            length += writer.writeBinary(tmp_1);
        }
        if (this.hasVariant()) {
            length += writer.writeByte((byte)8);
            length += writer.writeShort((short)2);
            length += writer.writeInt(this.mVariant.getValue());
        }
        if (this.hasName()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)3);
            Binary tmp_2 = Binary.wrap((byte[])this.mName.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }
        if (this.hasFields()) {
            length += writer.writeByte((byte)15);
            length += writer.writeShort((short)4);
            length += writer.writeByte((byte)12);
            length += writer.writeUInt32(this.mFields.size());
            for (FieldType fieldType : this.mFields) {
                length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessage)fieldType);
            }
        }
        if (this.hasAnnotations()) {
            length += writer.writeByte((byte)13);
            length += writer.writeShort((short)5);
            length += writer.writeByte((byte)11);
            length += writer.writeByte((byte)11);
            length += writer.writeUInt32(this.mAnnotations.size());
            for (Map.Entry entry : this.mAnnotations.entrySet()) {
                Binary tmp_5 = Binary.wrap((byte[])((String)entry.getKey()).getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_5.length());
                length += writer.writeBinary(tmp_5);
                Binary tmp_6 = Binary.wrap((byte[])((String)entry.getValue()).getBytes(StandardCharsets.UTF_8));
                length += writer.writeUInt32(tmp_6.length());
                length += writer.writeBinary(tmp_6);
            }
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static PStructDescriptorProvider<MessageType, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<MessageType, _Field> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<MessageType, _Field>
    implements BinaryReader {
        private BitSet optionals = new BitSet(5);
        private BitSet modified = new BitSet(5);
        private String mDocumentation;
        private MessageVariant mVariant;
        private String mName;
        private PList.Builder<FieldType> mFields = new PList.ImmutableListBuilder();
        private PMap.Builder<String, String> mAnnotations = new PMap.ImmutableMapBuilder();

        public _Builder() {
        }

        public _Builder(MessageType base) {
            this();
            if (base.hasDocumentation()) {
                this.optionals.set(0);
                this.mDocumentation = base.mDocumentation;
            }
            if (base.hasVariant()) {
                this.optionals.set(1);
                this.mVariant = base.mVariant;
            }
            if (base.hasName()) {
                this.optionals.set(2);
                this.mName = base.mName;
            }
            if (base.hasFields()) {
                this.optionals.set(3);
                this.mFields.addAll((Collection)base.mFields);
            }
            if (base.hasAnnotations()) {
                this.optionals.set(4);
                this.mAnnotations.putAll(base.mAnnotations);
            }
        }

        @Nonnull
        public _Builder merge(MessageType from) {
            if (from.hasDocumentation()) {
                this.optionals.set(0);
                this.modified.set(0);
                this.mDocumentation = from.getDocumentation();
            }
            if (from.hasVariant()) {
                this.optionals.set(1);
                this.modified.set(1);
                this.mVariant = from.getVariant();
            }
            if (from.hasName()) {
                this.optionals.set(2);
                this.modified.set(2);
                this.mName = from.getName();
            }
            if (from.hasFields()) {
                this.optionals.set(3);
                this.modified.set(3);
                this.mFields.clear();
                this.mFields.addAll(from.getFields());
            }
            if (from.hasAnnotations()) {
                this.optionals.set(4);
                this.modified.set(4);
                this.mAnnotations.putAll(from.getAnnotations());
            }
            return this;
        }

        @Nonnull
        public _Builder setDocumentation(String value) {
            this.optionals.set(0);
            this.modified.set(0);
            this.mDocumentation = value;
            return this;
        }

        public boolean isSetDocumentation() {
            return this.optionals.get(0);
        }

        public boolean isModifiedDocumentation() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearDocumentation() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mDocumentation = null;
            return this;
        }

        public String getDocumentation() {
            return this.mDocumentation;
        }

        @Nonnull
        public _Builder setVariant(MessageVariant value) {
            this.optionals.set(1);
            this.modified.set(1);
            this.mVariant = value;
            return this;
        }

        public boolean isSetVariant() {
            return this.optionals.get(1);
        }

        public boolean isModifiedVariant() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearVariant() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mVariant = null;
            return this;
        }

        public MessageVariant getVariant() {
            return this.isSetVariant() ? this.mVariant : kDefaultVariant;
        }

        @Nonnull
        public _Builder setName(String value) {
            this.optionals.set(2);
            this.modified.set(2);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(2);
        }

        public boolean isModifiedName() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearName() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mName = null;
            return this;
        }

        public String getName() {
            return this.mName;
        }

        @Nonnull
        public _Builder setFields(Collection<FieldType> value) {
            this.optionals.set(3);
            this.modified.set(3);
            this.mFields.clear();
            this.mFields.addAll(value);
            return this;
        }

        @Nonnull
        public _Builder addToFields(FieldType ... values) {
            this.optionals.set(3);
            this.modified.set(3);
            for (FieldType item : values) {
                this.mFields.add((Object)item);
            }
            return this;
        }

        public boolean isSetFields() {
            return this.optionals.get(3);
        }

        public boolean isModifiedFields() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearFields() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mFields.clear();
            return this;
        }

        public PList.Builder<FieldType> mutableFields() {
            this.optionals.set(3);
            this.modified.set(3);
            return this.mFields;
        }

        @Nonnull
        public _Builder setAnnotations(Map<String, String> value) {
            this.optionals.set(4);
            this.modified.set(4);
            this.mAnnotations.clear();
            this.mAnnotations.putAll(value);
            return this;
        }

        @Nonnull
        public _Builder putInAnnotations(String key, String value) {
            this.optionals.set(4);
            this.modified.set(4);
            this.mAnnotations.put((Object)key, (Object)value);
            return this;
        }

        public boolean isSetAnnotations() {
            return this.optionals.get(4);
        }

        public boolean isModifiedAnnotations() {
            return this.modified.get(4);
        }

        @Nonnull
        public _Builder clearAnnotations() {
            this.optionals.clear(4);
            this.modified.set(4);
            this.mAnnotations.clear();
            return this;
        }

        public PMap.Builder<String, String> mutableAnnotations() {
            this.optionals.set(4);
            this.modified.set(4);
            return this.mAnnotations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
                return false;
            }
            _Builder other = (_Builder)((Object)o);
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mDocumentation, other.mDocumentation) && Objects.equals((Object)this.mVariant, (Object)other.mVariant) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mFields, other.mFields) && Objects.equals(this.mAnnotations, other.mAnnotations);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{MessageType.class, this.optionals, _Field.DOCUMENTATION, this.mDocumentation, _Field.VARIANT, this.mVariant, _Field.NAME, this.mName, _Field.FIELDS, this.mFields, _Field.ANNOTATIONS, this.mAnnotations});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                default: 
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setDocumentation((String)value);
                    break;
                }
                case 2: {
                    this.setVariant((MessageVariant)((Object)value));
                    break;
                }
                case 3: {
                    this.setName((String)value);
                    break;
                }
                case 4: {
                    this.setFields((List)value);
                    break;
                }
                case 5: {
                    this.setAnnotations((Map)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 3: {
                    return this.optionals.get(2);
                }
                case 4: {
                    return this.optionals.get(3);
                }
                case 5: {
                    return this.optionals.get(4);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 3: {
                    return this.modified.get(2);
                }
                case 4: {
                    return this.modified.get(3);
                }
                case 5: {
                    return this.modified.get(4);
                }
            }
            return false;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 4: {
                    this.addToFields((FieldType)value);
                    break;
                }
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearDocumentation();
                    break;
                }
                case 2: {
                    this.clearVariant();
                    break;
                }
                case 3: {
                    this.clearName();
                    break;
                }
                case 4: {
                    this.clearFields();
                    break;
                }
                case 5: {
                    this.clearAnnotations();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return this.optionals.get(2);
        }

        public void validate() {
            if (!this.valid()) {
                LinkedList<String> missing = new LinkedList<String>();
                if (!this.optionals.get(2)) {
                    missing.add("name");
                }
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message model.MessageType");
            }
        }

        @Nonnull
        public PStructDescriptor<MessageType, _Field> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mDocumentation = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + PType.nameForId((byte)type) + "(" + type + ") for model.MessageType.documentation, should be message(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 8) {
                            this.mVariant = MessageVariant.forValue(reader.expectInt());
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + PType.nameForId((byte)type) + "(" + type + ") for model.MessageType.variant, should be message(12)", new Object[0]);
                    }
                    case 3: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            this.mName = new String(reader.expectBytes(len_2), StandardCharsets.UTF_8);
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + PType.nameForId((byte)type) + "(" + type + ") for model.MessageType.name, should be message(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 15) {
                            byte t_4 = reader.expectByte();
                            if (t_4 == 12) {
                                int len_3 = reader.expectUInt32();
                                for (int i_5 = 0; i_5 < len_3; ++i_5) {
                                    FieldType key_6 = (FieldType)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, FieldType.kDescriptor, (boolean)strict);
                                    this.mFields.add((Object)key_6);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + PType.nameForId((byte)t_4) + "(" + t_4 + ") for model.MessageType.fields, should be message(12)", new Object[0]);
                            }
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + PType.nameForId((byte)type) + "(" + type + ") for model.MessageType.fields, should be message(12)", new Object[0]);
                    }
                    case 5: {
                        if (type == 13) {
                            byte t_8 = reader.expectByte();
                            byte t_9 = reader.expectByte();
                            if (t_8 == 11 && t_9 == 11) {
                                int len_7 = reader.expectUInt32();
                                for (int i_10 = 0; i_10 < len_7; ++i_10) {
                                    int len_13 = reader.expectUInt32();
                                    String key_11 = new String(reader.expectBytes(len_13), StandardCharsets.UTF_8);
                                    int len_14 = reader.expectUInt32();
                                    String val_12 = new String(reader.expectBytes(len_14), StandardCharsets.UTF_8);
                                    this.mAnnotations.put((Object)key_11, (Object)val_12);
                                }
                            } else {
                                throw new SerializerException("Wrong key type " + PType.nameForId((byte)t_8) + "(" + t_8 + ") or value type " + PType.nameForId((byte)t_9) + "(" + t_9 + ") for model.MessageType.annotations, should be string(11) and string(11)", new Object[0]);
                            }
                            this.optionals.set(4);
                            break;
                        }
                        throw new SerializerException("Wrong type " + PType.nameForId((byte)type) + "(" + type + ") for model.MessageType.annotations, should be message(12)", new Object[0]);
                    }
                    default: {
                        if (strict) {
                            throw new SerializerException("No field with id " + field + " exists in model.MessageType", new Object[0]);
                        }
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        public MessageType build() {
            return new MessageType(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<MessageType, _Field> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<MessageType, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<MessageType, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<MessageType, _Field> {
        public _Descriptor() {
            super("model", "MessageType", (PMessageBuilderFactory)new _Factory(), false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        DOCUMENTATION(1, PRequirement.DEFAULT, "documentation", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        VARIANT(2, PRequirement.DEFAULT, "variant", (PDescriptorProvider)MessageVariant.provider(), (PValueProvider<?>)new PDefaultValueProvider((Object)((Object)MessageType.access$500()))),
        NAME(3, PRequirement.REQUIRED, "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        FIELDS(4, PRequirement.DEFAULT, "fields", (PDescriptorProvider)PList.provider(FieldType.provider()), null),
        ANNOTATIONS(5, PRequirement.DEFAULT, "annotations", (PDescriptorProvider)PMap.provider((PDescriptorProvider)PPrimitive.STRING.provider(), (PDescriptorProvider)PPrimitive.STRING.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.toString((PField)this);
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return DOCUMENTATION;
                }
                case 2: {
                    return VARIANT;
                }
                case 3: {
                    return NAME;
                }
                case 4: {
                    return FIELDS;
                }
                case 5: {
                    return ANNOTATIONS;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "documentation": {
                    return DOCUMENTATION;
                }
                case "variant": {
                    return VARIANT;
                }
                case "name": {
                    return NAME;
                }
                case "fields": {
                    return FIELDS;
                }
                case "annotations": {
                    return ANNOTATIONS;
                }
            }
            return null;
        }
    }
}

